/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JFrame;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.AbstractMoveActionHandler;
import oracle.ide.refactoring.ActionHandlerConfirmationDialog;
import oracle.ide.resource.RenameDialogArb;
import oracle.ide.util.Assert;
import org.openide.util.RequestProcessor;

public abstract class SimpleMoveActionHandler<T extends Element>
extends AbstractMoveActionHandler<T> {
    private static final RequestProcessor processor = new RequestProcessor(SimpleMoveActionHandler.class);
    private ActionHandlerConfirmationDialog confirmationDialog;

    protected SimpleMoveActionHandler(Context context) {
        super(context);
    }

    @Override
    public final void doit() {
        this.confirmationDialog = this.createMoveConfirmationDialog((JFrame)((Object)Ide.getMainWindow()));
        if (this.runDialog()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SimpleMoveActionHandler.this.doMove();
                }
            };
            if (EventQueue.isDispatchThread()) {
                processor.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }

    protected abstract boolean doMove();

    protected abstract Component createDialogContent();

    protected Component createMoveDetailsComponent() {
        return null;
    }

    private final ActionHandlerConfirmationDialog createMoveConfirmationDialog(JFrame dialogOwner) {
        ActionHandlerConfirmationDialog detailDialog = ActionHandlerConfirmationDialog.createDialog(dialogOwner, RenameDialogArb.getString(1), this.createDialogContent(), this.createMoveDetailsComponent());
        detailDialog.setButtonTextWhenDetailsHidden(RenameDialogArb.getString(3), true);
        detailDialog.setButtonTextWhenDetailsShown(RenameDialogArb.getString(4), false);
        detailDialog.setHelpTopicId("f1_jrf_dmovetype_html");
        return detailDialog;
    }

    protected final void setStatus(String text, Icon icon) {
        this.confirmationDialog.setStatus(text, icon);
    }

    protected final void clearStatus() {
        this.setStatus("", null);
    }

    protected final void moveDetailsAvailable(boolean detailsAvailable) {
        this.confirmationDialog.setDetailsAvailable(detailsAvailable);
    }

    protected final void setOKButtonEnabled(boolean enabled) {
        if (this.confirmationDialog != null) {
            this.confirmationDialog.setOKButtonEnabled(enabled);
        }
    }

    private boolean runDialog() {
        boolean ret = false;
        if (this.confirmationDialog.runDialog()) {
            ret = true;
        }
        this.confirmationDialog.dispose();
        return ret;
    }

    public static boolean moveNode(Node node, String destination) {
        if (node.isOpen()) {
            try {
                node.close();
            }
            catch (IOException e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        URL oldUrl = node.getURL();
        String nameAndExtension = node.getShortLabel();
        if (nameAndExtension != null) {
            String newFilePath = new File(destination, nameAndExtension).getPath();
            URL newUrl = URLFactory.newFileURL((String)newFilePath);
            boolean succeeded = URLFileSystem.renameTo((URL)oldUrl, (URL)newUrl);
            return succeeded;
        }
        return false;
    }
}

