/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.io.File;
import java.util.StringTokenizer;

public class ViewId {
    public static final String DELIMETER = ".";
    public static final char NAME_SEPARATOR = '-';
    protected String type;
    protected String name;
    protected String displayName;
    protected String id;

    public ViewId(String type, String name) {
        this.type = ViewId.validate(type);
        this.name = ViewId.validate(name);
        this.displayName = name;
    }

    public ViewId(String viewId) {
        if (viewId == null || viewId.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(viewId, DELIMETER);
        this.type = st.nextToken();
        if (st.hasMoreTokens()) {
            this.name = st.nextToken();
        }
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.type;
            if (this.name != null && this.name.length() > 0) {
                this.id = this.id + DELIMETER + this.name;
            }
        }
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isValid() {
        return this.type != null;
    }

    public static String validate(String name) {
        if (name == null || name.length() <= 0) {
            return null;
        }
        String newName = name.replace(File.separatorChar, '-');
        newName = newName.replace(':', '-');
        return newName.replace('.', '-');
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ViewId)) {
            return false;
        }
        ViewId viewId = (ViewId)object;
        return this.getId().equals(viewId.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    protected ViewId() {
    }
}

