/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension.rules;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.ide.extension.Extension;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.extension.rules.RuleType;
import oracle.ide.performance.PerformanceLogger;

public class SimpleRule
extends Rule {
    private final RuleType _type;
    private LinkedHashMap<String, RuleFunctionParameter> _parameterMap = new LinkedHashMap();
    private Map<String, RuleFunctionParameter> _unmodifiableParameterMap = Collections.unmodifiableMap(this._parameterMap);

    public SimpleRule(String id, Extension extension, RuleType type) {
        super(id, extension);
        if (type == null) {
            throw new IllegalArgumentException("SimpleRule constructur passed null type argument");
        }
        this._type = type;
    }

    public RuleType getType() {
        return this._type;
    }

    public boolean hasParameter(String name) {
        return this._parameterMap.containsKey(name);
    }

    public boolean addParameter(RuleFunctionParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("addParameter passed a null RuleFunctionParameter argument");
        }
        if (!this._parameterMap.containsKey(parameter.getName())) {
            this._parameterMap.put(parameter.getName(), parameter);
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluate(RuleEvaluationContext ruleContext) throws RuleEvaluationException {
        if (ruleContext == null) {
            throw new IllegalArgumentException("evaluate() passed a null ruleContext argument");
        }
        RuleFunction ruleFunction = this._type.getRuleFunction();
        boolean returnValue = false;
        long start = System.nanoTime();
        try {
            returnValue = ruleFunction.evaluate(ruleContext, this._unmodifiableParameterMap);
        }
        catch (Exception e) {
            throw new RuleEvaluationException("Exception encountered during evaluation of rule: " + this.getId(), e);
        }
        finally {
            long time = System.nanoTime() - start;
            PerformanceLogger.get().log("RuleFunction.evaluate", this.getId(), time);
        }
        return returnValue;
    }

    @Override
    public boolean matchesType(Set<String> ruleTypeIdSet) {
        return ruleTypeIdSet.contains(this._type.getId());
    }
}

