/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleTypeParameter;

public final class RuleType {
    private String _id;
    private MetaClass<RuleFunction> _implClass;
    private Extension _extension;
    private LinkedHashMap<String, RuleTypeParameter> _parameterMap = new LinkedHashMap();
    private Map<String, RuleTypeParameter> _unmodifiableParameterMap = Collections.unmodifiableMap(this._parameterMap);

    public RuleType(String id, MetaClass<RuleFunction> implClass, Extension extension) {
        if (id == null || implClass == null || extension == null) {
            throw new IllegalArgumentException("RuleType constructur passed null argument");
        }
        this._id = id;
        this._implClass = implClass;
        this._extension = extension;
    }

    public String getId() {
        return this._id;
    }

    public Extension getExtension() {
        return this._extension;
    }

    public synchronized RuleFunction getRuleFunction() throws RuleEvaluationException {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        if (!registry.isFullyLoaded(this._extension)) {
            throw new RuleEvaluationException("Illegal attempt to instantiate the class " + this._implClass.getClassName() + " defined in rule-type '" + this.getId() + "'" + " when the defining extension '" + this._extension.getID() + "' is not fully loaded.");
        }
        RuleFunction ruleFunction = null;
        try {
            ruleFunction = (RuleFunction)this._implClass.newInstance();
        }
        catch (Exception e) {
            throw new RuleEvaluationException("Can't instantiate the class " + this._implClass.getClassName() + " defined in rule-type '" + this.getId() + "'", e);
        }
        return ruleFunction;
    }

    public boolean isParameterSupported(String paramName) {
        return this._unmodifiableParameterMap.containsKey(paramName);
    }

    public Collection<RuleTypeParameter> getSupportedParameters() {
        return this._unmodifiableParameterMap.values();
    }

    public boolean hasRequiredParameters() {
        for (RuleTypeParameter param : this.getSupportedParameters()) {
            if (!param.isRequired()) continue;
            return true;
        }
        return false;
    }

    public boolean addSupportedParameter(RuleTypeParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("addParameter passed a null RuleTypeParameter argument");
        }
        if (!this._parameterMap.containsKey(parameter.getName())) {
            this._parameterMap.put(parameter.getName(), parameter);
            return true;
        }
        return false;
    }
}

