/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension.rules;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.Context;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleType;

public final class RuleEngine {
    private static RuleEngine _sInstance = new RuleEngine();
    private ConcurrentHashMap<String, RuleType> _ruleTypeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Rule> _ruleMap = new ConcurrentHashMap();
    private static final Logger _sLogger = Logger.getLogger(RuleEngine.class.getName());

    public static RuleEngine getInstance() {
        return _sInstance;
    }

    public final boolean evaluateRule(String ruleId, Context ideContext) {
        if (ideContext == null) {
            throw new IllegalArgumentException("RuleEngine evaluate method passed null ideContext");
        }
        RuleEvaluationContext ruleContext = new RuleEvaluationContext(ideContext);
        return this.evaluateRule(ruleId, ruleContext);
    }

    public boolean evaluateRule(String ruleId, RuleEvaluationContext ruleContext) {
        boolean returnValue = false;
        try {
            returnValue = this.evaluateRuleOrThrow(ruleId, ruleContext);
        }
        catch (RuleEvaluationException e) {
            returnValue = false;
        }
        return returnValue;
    }

    public final boolean evaluateRuleOrThrow(String ruleId, Context ideContext) throws RuleEvaluationException {
        if (ideContext == null) {
            throw new IllegalArgumentException("RuleEngine evaluate method passed null ideContext");
        }
        RuleEvaluationContext ruleContext = new RuleEvaluationContext(ideContext);
        return this.evaluateRuleOrThrow(ruleId, ruleContext);
    }

    public boolean evaluateRuleOrThrow(String ruleId, RuleEvaluationContext ruleContext) throws RuleEvaluationException {
        if (ruleId == null) {
            throw new IllegalArgumentException("RuleEngine evaluate method passed a null ruleId");
        }
        if (ruleContext == null) {
            throw new IllegalArgumentException("RuleEngine evaluate method passed a null ruleContext");
        }
        boolean returnValue = false;
        try {
            Rule rule = this.getRule(ruleId);
            if (rule == null) {
                throw new RuleEvaluationException("Unknown rule.  No rule is registered with the id: " + ruleId);
            }
            ruleContext.setAdditionalData("ruleId", ruleId);
            returnValue = rule.evaluate(ruleContext);
        }
        catch (RuleEvaluationException e) {
            _sLogger.log(Level.SEVERE, "RuleEvaluationException encountered while evaluating rule: " + ruleId, e);
            throw e;
        }
        return returnValue;
    }

    public boolean registerRuleType(RuleType ruleType) {
        RuleType existingType = this._ruleTypeMap.putIfAbsent(ruleType.getId(), ruleType);
        return existingType == null;
    }

    public RuleType getRuleType(String id) {
        return this._ruleTypeMap.get(id);
    }

    public boolean registerRule(Rule rule) {
        Rule existingRule = this._ruleMap.putIfAbsent(rule.getId(), rule);
        return existingRule == null;
    }

    public Rule getRule(String id) {
        return this._ruleMap.get(id);
    }

    public boolean isKnownRule(String ruleId) {
        if (ruleId == null) {
            throw new IllegalArgumentException("isKnownRule called with null ruleId argument");
        }
        return this._ruleMap.containsKey(ruleId);
    }

    private boolean isDependentOnRuleProviderExtension(String ruleId, Extension extReferencingRule) {
        Rule rule = this.getRule(ruleId);
        Extension extDefiningRule = rule.getExtension();
        if (extDefiningRule.getID().equals(extReferencingRule.getID())) {
            return true;
        }
        for (ExtensionDependency extDep : extReferencingRule.getDependencies()) {
            if (!extDep.getID().equals(extDefiningRule.getID())) continue;
            return true;
        }
        return false;
    }

    public boolean matchesType(String ruleId, Set<String> ruleTypeIdSet) {
        if (ruleId == null || ruleTypeIdSet == null || ruleTypeIdSet.isEmpty()) {
            throw new IllegalArgumentException("matchesType requires non-null ruleId and a non-empty ruleTypeIdSet arguments");
        }
        Rule rule = this.getRule(ruleId);
        if (rule != null) {
            return rule.matchesType(ruleTypeIdSet);
        }
        return false;
    }

    public boolean validateRuleReference(String ruleId, ElementContext referenceContext) {
        return this.validateRuleReference(ruleId, null, referenceContext);
    }

    public boolean validateRuleReference(String ruleId, Set<String> expectedRuleTypes, ElementContext referenceContext) {
        if (ruleId == null) {
            throw new IllegalArgumentException("validateRuleReference called with null ruleId");
        }
        if (ruleId.isEmpty()) {
            this._logErrorToContext(referenceContext, "Empty string is an invalid rule reference.");
        }
        if (!this.isKnownRule(ruleId)) {
            this._logErrorToContext(referenceContext, "'" + ruleId + "' is an invalid rule reference, it does not match any rule id defined in this extension.xml or its dependencies.");
            return false;
        }
        if (expectedRuleTypes != null && !this.matchesType(ruleId, expectedRuleTypes)) {
            this._logErrorToContext(referenceContext, "Rule id '" + ruleId + "' is invalid at this location.  Only rules matching the following expected types can be referenced from this location:  " + expectedRuleTypes.toString());
            return false;
        }
        if (referenceContext != null && !this.isDependentOnRuleProviderExtension(ruleId, referenceContext.getExtension())) {
            this._logErrorToContext(referenceContext, "Rule id '" + ruleId + "' referenced in extension " + referenceContext.getExtension().getID() + " is not defined in it, or any of its dependencies. Luckily, it was found in extension " + this.getRule(ruleId).getExtension().getID() + ". This will work correctly this time, but is " + "not guaranteed to work every time unless a dependency exists.");
            return true;
        }
        return true;
    }

    public boolean validateRuleReference(String ruleId, Set<String> expectedRuleTypes, Logger logger) {
        if (ruleId == null) {
            throw new IllegalArgumentException("validateRuleReference called with null ruleId");
        }
        if (ruleId.isEmpty()) {
            logger.log(Level.SEVERE, "Empty string is an invalid rule reference.");
        }
        if (!this.isKnownRule(ruleId)) {
            logger.log(Level.SEVERE, "'" + ruleId + "' is an invalid rule reference, it does not match any rule id defined in this extension.xml or its dependencies.");
            return false;
        }
        if (expectedRuleTypes != null && !this.matchesType(ruleId, expectedRuleTypes)) {
            logger.log(Level.SEVERE, "Rule id '" + ruleId + "' is invalid at this location.  Only rules matching the following expected types can be referenced from this location:  " + expectedRuleTypes.toString());
            return false;
        }
        return true;
    }

    private void _logErrorToContext(ElementContext referenceContext, String message) {
        if (referenceContext != null) {
            Logger logger = referenceContext.getLogger();
            ExtensionLogRecord record = new ExtensionLogRecord(referenceContext, Level.SEVERE, message);
            logger.log((LogRecord)record);
        }
    }

    private RuleEngine() {
    }
}

