/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.naming.InitialContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controller.MenuWeightComparator;
import oracle.ide.controls.ChangeAdaptor;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.RadioMenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MenuCJKUtil;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.javatools.jndi.Names;
import oracle.javatools.util.AccessibleUtils;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.StringUtil;

public abstract class MenuManager {
    private final MenuListener _menuListener = new PrivateMenuListener();
    final ContainerListener _containerListener = new PrivateContainerListener();
    private final L _listener = new L();
    private static final int LAST_POSITION = -1;
    private static final String ALPHA_SORT_SECTION_KEY = "alpha-sort-sections";
    private static final String SORT_MENU_KEY = "menu-is-sorted";
    private static final String RESOLVE_MNEMONICS_FOR_SECTION_KEY = "resolve-section-mnemonics";
    private static final String MENU_CLIENT_PROPERTY = "oide.menu.id";
    private final List<MenuFilter> _menuFilters = new ArrayList<MenuFilter>();
    private MenuFilter _globalFilter;
    private final Map<String, Map<String, Float>> _menuSectionMap = new HashMap<String, Map<String, Float>>(20);
    private static final Logger LOG = Logger.getLogger(MenuManager.class.getName());
    private static final InitialContext _ic = Names.newInitialContext();
    private final ContainerListener filterContainerListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            if (!MenuManager.this.isMenuComponentAccepted(e.getChild())) {
                e.getContainer().remove(e.getChild());
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
        }
    };

    MenuManager() {
    }

    List<MenuFilter> getMenuFilters() {
        return this._menuFilters;
    }

    public void addMenuFilter(MenuFilter menuFilter) {
        if (menuFilter == null) {
            throw new NullPointerException("menuFilter is null");
        }
        this._menuFilters.add(menuFilter);
    }

    public void removeMenuFilter(MenuFilter menuFilter) {
        this._menuFilters.remove(menuFilter);
    }

    public final void applyGlobalFilter(MenuFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter is null");
        }
        if (filter != this._globalFilter) {
            if (this._globalFilter != null) {
                this.clearGlobalFilter();
            }
            assert (this._globalFilter == null);
            this._globalFilter = filter;
            this.applyGlobalFilterImpl(filter);
        }
    }

    protected void applyGlobalFilterImpl(MenuFilter filter) {
    }

    public final void clearGlobalFilter() {
        if (this._globalFilter != null) {
            this._globalFilter = null;
        }
        this.clearGlobalFilterImpl();
    }

    protected void clearGlobalFilterImpl() {
    }

    MenuFilter getGlobalFilter() {
        return this._globalFilter;
    }

    public Float lookupMenuSection(String menuId, String sectionId) {
        if (!this._menuSectionMap.isEmpty() && menuId != null && this._menuSectionMap.containsKey(menuId)) {
            Map<String, Float> sectionMap = this._menuSectionMap.get(menuId);
            if (sectionId != null && sectionMap.containsKey(sectionId)) {
                return sectionMap.get(sectionId);
            }
        }
        return null;
    }

    public void storeMenuSection(String menuId, String sectionId, Float section) {
        Assert.precondition((menuId != null ? 1 : 0) != 0, (String)"menuId must not be null");
        Assert.precondition((sectionId != null ? 1 : 0) != 0, (String)"sectionId must not be null");
        Assert.precondition((section != null ? 1 : 0) != 0, (String)"section must not be null");
        if (!this._menuSectionMap.containsKey(menuId)) {
            HashMap<String, Float> map = new HashMap<String, Float>(5);
            map.put(sectionId, section);
            this._menuSectionMap.put(menuId, map);
        } else {
            Map<String, Float> sectionMap = this._menuSectionMap.get(menuId);
            if (!sectionMap.containsKey(sectionId)) {
                sectionMap.put(sectionId, section);
            } else {
                Assert.println((String)(sectionId + " is alreay mapped to " + sectionMap.get(sectionId)));
            }
        }
    }

    public static final void setMenuId(JMenu menu, String id) {
        menu.putClientProperty(MENU_CLIENT_PROPERTY, id);
    }

    public static final String getMenuId(JMenu menu) {
        return (String)menu.getClientProperty(MENU_CLIENT_PROPERTY);
    }

    protected final boolean isMenuComponentAccepted(Component component) {
        return MenuManager.isMenuComponentAccepted(component, this._menuFilters);
    }

    protected static final boolean isMenuComponentAccepted(Component component, Collection<MenuFilter> filters) {
        if (component == null) {
            return false;
        }
        for (MenuFilter filter : filters) {
            if (filter.accept(component)) continue;
            return false;
        }
        return true;
    }

    public static final JMenu getJMenu(String id) {
        return (JMenu)Names.lookup((javax.naming.Context)_ic, (String)MenuManager.menuKey(id));
    }

    public static final void putJMenu(String id, JMenu menu) {
        String menuKey = MenuManager.menuKey(id);
        if (menu == null) {
            Names.unbind((javax.naming.Context)_ic, (String)menuKey);
        } else {
            MenuManager.setMenuId(menu, id);
            Names.bind((javax.naming.Context)_ic, (String)menuKey, (Object)menu);
        }
    }

    private static String menuKey(String id) {
        return "env/menus/" + id;
    }

    public JMenu createMenu(String caption, Integer mnemonic) {
        return this.createMenu(caption, mnemonic, Float.MAX_VALUE);
    }

    public JMenu createMenu(String caption, float weight, float addinSectionId) {
        return this.createMenu(caption, null, weight, addinSectionId);
    }

    public JMenu createMenu(String caption, Integer mnemonic, float weight) {
        return this.createMenu(caption, mnemonic, weight, Float.MAX_VALUE);
    }

    public JMenu createMenu(String caption, float weight) {
        return this.createMenu(caption, null, weight, Float.MAX_VALUE);
    }

    public JMenu createMenu(String caption, Integer mnemonic, float weight, float addinSectionId) {
        return this.createMenu(caption, mnemonic, weight, Float.MAX_VALUE, addinSectionId);
    }

    private JMenu createMenu(String caption, Integer mnemonic, float weight, float sectionId, float addinSectionId) {
        int mnem;
        Assert.printStackTrace((caption == null ? 1 : 0) != 0, (String)"The menu caption is null.");
        CustomMenu menu = new CustomMenu();
        menu.setText(StringUtils.stripMnemonic((String)caption));
        if ((mnemonic == null || mnemonic == 0) && (mnem = StringUtils.getMnemonicKeyCode((String)caption)) != -1) {
            mnemonic = mnem;
        }
        menu.setMnemonic(mnemonic);
        this.setWeight(menu, weight, "menu-weight");
        this.setWeight(menu, sectionId, "menu-section-id");
        this.setWeight(menu, addinSectionId, "menu-addin-section-id");
        this.addMenuManagerAsListener(menu);
        return menu;
    }

    public int getKeyboardMnemonic(String menuLabel, Integer mnemonic) {
        Integer mn = mnemonic;
        int keyCode = StringUtils.getMnemonicKeyCode((String)menuLabel);
        if (mnemonic == null || keyCode != 0) {
            mn = keyCode;
        }
        return CustomMenu.getKeyboardMnemonic(mn);
    }

    public JMenu createSubMenu(String caption, Integer mnemonic) {
        return this.createSubMenu(caption, mnemonic, Float.MAX_VALUE);
    }

    public JMenu createSubMenu(String caption, Integer mnemonic, float weight) {
        return this.createSubMenu(caption, mnemonic, weight, Float.MAX_VALUE);
    }

    public JMenu createSubMenu(String caption, Integer mnemonic, float weight, float sectionId) {
        JMenu menu = this.createMenu(caption, mnemonic, weight, sectionId, Float.MAX_VALUE);
        this.registerFilterContainerListener(menu);
        if (PlatformUtils.isMac()) {
            menu.setIcon((Icon)new NullIcon());
        }
        return menu;
    }

    protected void registerFilterContainerListener(JMenu menu) {
        menu.getPopupMenu().addContainerListener(this.filterContainerListener);
    }

    protected final void unregisterFilterContainerListener(JMenu menu) {
        menu.getPopupMenu().removeContainerListener(this.filterContainerListener);
    }

    public JMenuItem createMenuItem(ToggleAction action) {
        return this.createMenuItem(action, Float.MAX_VALUE);
    }

    public JMenuItem createMenuItem(ToggleAction action, float menuWeight) {
        String cjkMenuLabel;
        String menuText;
        if (action == null) {
            return null;
        }
        JMenuItem menuItem = action.isRadio() ? new RadioMenuItem(action) : (action.isToggle() ? new ToggleMenuItem(action) : new MenuItem(action));
        if (menuWeight == Float.MAX_VALUE) {
            menuWeight = action.getMenuWeight();
        }
        menuItem.putClientProperty("menu-weight", new Float(menuWeight));
        Integer mnemonic = (Integer)action.getValue("MnemonicKey");
        if (mnemonic != null && !ModelUtil.areEqual((Object)(menuText = menuItem.getText()), (Object)(cjkMenuLabel = MenuCJKUtil.getCJKMenuLabel(menuText, mnemonic)))) {
            menuItem.setText(cjkMenuLabel);
        }
        if (action instanceof IdeAction) {
            MenuManager.refreshMenuItem(menuItem);
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            InnerChangeAdaptor changeListener = new InnerChangeAdaptor(menuItem, keyStrokeOptions);
            keyStrokeOptions.addChangeListener(changeListener);
        }
        return menuItem;
    }

    public void add(Component child) {
        this.add(child, Float.MAX_VALUE);
    }

    public void add(Component child, float sectionId) {
        Container gui;
        this.checkEDT("MenuManager.add", child);
        if (this.isMenuComponentAccepted(child) && (gui = this.getGUI(true)) != null) {
            this.setWeight(child, sectionId, "menu-section-id");
            if (SwingUtilities.isEventDispatchThread()) {
                this.addToMenuImpl(child, gui);
            } else {
                final Component comp = child;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuManager.this.addToMenuImpl(comp, gui);
                    }
                });
            }
            this.addMenuManagerAsListener(child);
        }
    }

    private void addToMenuImpl(Component child, Container gui) {
        if (gui instanceof JMenuBar) {
            this.addToMenubar((JMenuBar)gui, child);
        } else {
            gui.add(child);
        }
    }

    public void add(Component child, JMenu parent) {
        this.add(child, parent, Float.MAX_VALUE);
    }

    public void add(Component child, JMenu parent, float sectionId) {
        this.checkEDT("MenuManager.add", child, parent);
        if (child == null) {
            throw new NullPointerException("child is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        if (this.isMenuComponentAccepted(child)) {
            if (sectionId == Float.MAX_VALUE) {
                Float menuWeight;
                Float section;
                if (child instanceof JComponent && (section = (Float)((JComponent)child).getClientProperty("menu-section-id")) != null) {
                    sectionId = section.floatValue();
                }
                if (sectionId == Float.MAX_VALUE && (menuWeight = (Float)parent.getClientProperty("menu-addin-section-id")) != null) {
                    sectionId = menuWeight.floatValue();
                }
            }
            this.setWeight(child, sectionId, "menu-section-id");
            parent.add(child);
            MenuManager.ensureAccessibleParentSet(child, parent);
            this.addMenuManagerAsListener(child);
        }
    }

    public boolean contains(Component component) {
        Container gui = this.getGUI(false);
        if (gui != null) {
            for (Component c : gui.getComponents()) {
                if (c != component) continue;
                return true;
            }
        }
        return false;
    }

    public void remove(Component child) {
        Container gui;
        if (child != null && (gui = this.getGUI(false)) != null) {
            gui.remove(child);
            this.adjustSeparators(gui);
            this.removeMenuManagerAsListener(child);
        }
    }

    public void remove(Component child, JMenu parent) {
        int index;
        if (child != null && parent != null && (index = this.getIndexOfChild(parent, child)) != -1) {
            parent.remove(index);
            this.removeMenuManagerAsListener(child);
        }
    }

    public void removeAll(JMenu parent) {
        if (parent != null) {
            for (Component component : parent.getMenuComponents()) {
                this.remove(component, parent);
            }
        }
    }

    public abstract Container getGUI(boolean var1);

    protected ContainerListener getContainerListener() {
        return this._containerListener;
    }

    public int getIndexOfChild(Container parent, Component child) {
        if (parent != null && child != null) {
            Component[] components = MenuManager.getComponents(parent);
            for (int i = 0; i < components.length; ++i) {
                Component component = components[i];
                if (component != child) continue;
                return i;
            }
        }
        return -1;
    }

    public int getIndexOfCommandId(Container parent, int commandId) {
        if (parent != null) {
            Component[] components = MenuManager.getComponents(parent);
            for (int i = 0; i < components.length; ++i) {
                JComponent component = (JComponent)components[i];
                IdeAction action = this._getIdeAction(component);
                if (action == null || action.getCommandId() != commandId) continue;
                return i;
            }
        }
        return -1;
    }

    public Component getChildById(Container parent, int commandId) {
        if (parent != null) {
            Component[] components;
            for (Component c : components = MenuManager.getComponents(parent)) {
                JComponent component = (JComponent)c;
                IdeAction action = this._getIdeAction(component);
                if (action == null || action.getCommandId() != commandId) continue;
                return component;
            }
        }
        return null;
    }

    private static Component[] getComponents(Container parent) {
        if (parent != null) {
            if (parent instanceof JMenu) {
                return ((JMenu)parent).getMenuComponents();
            }
            return parent.getComponents();
        }
        return new Component[0];
    }

    public void sortSectionByName(JComponent menu, float sectionID) {
        Float f;
        HashSet<Float> sortedSections = (HashSet<Float>)menu.getClientProperty(ALPHA_SORT_SECTION_KEY);
        if (sortedSections == null) {
            sortedSections = new HashSet<Float>(1);
        }
        if (!sortedSections.contains(f = new Float(sectionID))) {
            sortedSections.add(f);
        }
        menu.putClientProperty(ALPHA_SORT_SECTION_KEY, sortedSections);
    }

    public void resolveMnemonicsForMenuItemsInSection(JMenu menu, float sectionID) {
        HashSet<Float> sections = (HashSet<Float>)menu.getClientProperty(RESOLVE_MNEMONICS_FOR_SECTION_KEY);
        if (sections == null) {
            sections = new HashSet<Float>(1);
        }
        if (!sections.contains(Float.valueOf(sectionID))) {
            sections.add(Float.valueOf(sectionID));
        }
        menu.putClientProperty(RESOLVE_MNEMONICS_FOR_SECTION_KEY, sections);
    }

    public void removeMenuManagerMenuListener(JMenu menu) {
        if (menu != null) {
            menu.removeMenuListener(this._listener);
        }
    }

    private void checkEDT(String violationLocation, Component ... components) {
        if (!Ide.isStarting() && !SwingUtilities.isEventDispatchThread()) {
            StringBuilder error = new StringBuilder(violationLocation);
            String delim = " '";
            for (Component c : components) {
                error.append(delim);
                error.append(c instanceof JMenuItem ? ((JMenuItem)c).getText() : c);
                error.append("'");
                delim = " to '";
            }
            error.append(" was called off EDT.");
            Assert.printStackTrace((String)error.toString());
            error.append(" See console for stack trace.");
            LOG.severe(error.toString());
        }
    }

    protected void setWeight(Component component, float weight, String weightId) {
        if (!(component instanceof JComponent)) {
            return;
        }
        JComponent item = (JComponent)component;
        if (weight != Float.MAX_VALUE) {
            item.putClientProperty(weightId, new Float(weight));
        } else {
            Float menuWeight = (Float)item.getClientProperty(weightId);
            if (menuWeight == null || menuWeight.floatValue() == Float.MAX_VALUE) {
                item.putClientProperty(weightId, new Float(weight));
            }
        }
    }

    private IdeAction _getIdeAction(Component c) {
        AbstractButton button;
        Action action;
        if (c instanceof AbstractButton && (action = (button = (AbstractButton)c).getAction()) != null && action instanceof IdeAction) {
            return (IdeAction)action;
        }
        return null;
    }

    private static void updateMenuItems(JMenu menu, EventObject event) {
        MenuManager.workaroundExpandingSwingJPopupMenuBug(menu.getPopupMenu());
        View activeView = Ide.getMainWindow().getLastActiveView();
        Context context = activeView != null ? activeView.getContext(event) : Context.newIdeContext();
        Context contextCopy = new Context(context);
        for (Component comp : menu.getMenuComponents()) {
            if (!(comp instanceof JMenuItem)) continue;
            MenuManager.updateMenuItemAction((JMenuItem)comp, contextCopy);
        }
    }

    static void updatePopupMenuItems(JPopupMenu menu, Context context) {
        MenuManager.workaroundExpandingSwingJPopupMenuBug(menu);
        MenuElement[] items = menu.getSubElements();
        if (items != null) {
            for (MenuElement item : items) {
                if (!(item instanceof JMenuItem)) continue;
                MenuManager.updateMenuItemAction((JMenuItem)item, context);
            }
        }
    }

    private static void workaroundExpandingSwingJPopupMenuBug(JComponent jcomp) {
        jcomp.putClientProperty("maxTextWidth", null);
        jcomp.putClientProperty("maxAccWidth", null);
    }

    private static void updateMenuItemAction(JMenuItem item, Context context) {
        Action swingAction;
        if (item != null && (swingAction = item.getAction()) instanceof IdeAction) {
            String tip;
            IdeAction ideAction = (IdeAction)swingAction;
            ideAction.updateAction(context);
            if (IdeAction.DEBUG && ((tip = (String)ideAction.getValue("ShortDescription")) == null || tip.indexOf("[menu item weight") == -1)) {
                StringBuilder buf = new StringBuilder();
                if (tip != null) {
                    buf.append(tip);
                }
                buf.append("\n[menu item weight=");
                Float weight = (Float)item.getClientProperty("menu-weight");
                if (weight == null) {
                    buf.append("null");
                } else {
                    buf.append(weight.floatValue() == Float.MAX_VALUE ? "undefined" : weight);
                }
                buf.append(", section=");
                Float section = (Float)item.getClientProperty("menu-section-id");
                if (section == null) {
                    buf.append("null");
                } else {
                    buf.append(section.floatValue() == Float.MAX_VALUE ? "undefined" : section);
                }
                buf.append("]");
                ideAction.putValue("ShortDescription", buf.toString());
            }
        }
    }

    private static void resolveMnemonics(JMenu menu) {
        HashSet sections = (HashSet)menu.getClientProperty(RESOLVE_MNEMONICS_FOR_SECTION_KEY);
        if (sections != null && !sections.isEmpty()) {
            for (Float sectionId : sections) {
                MenuManager.resolveMnemonics(menu, sectionId);
            }
        }
    }

    private static void resolveMnemonics(JMenu menu, Float sectionId) {
        MnemonicSolver solver = null;
        int count = menu.getItemCount();
        for (int i = 0; i < count; ++i) {
            int mnemonic;
            JMenuItem item = menu.getItem(i);
            if (item == null || !sectionId.equals(item.getClientProperty("menu-section-id"))) continue;
            if (solver == null) {
                solver = new MnemonicSolver();
            }
            solver.addMenuLabel(item, (mnemonic = item.getMnemonic()) != 0);
        }
        if (solver != null) {
            solver.solve();
        }
    }

    private static void refreshMenuItem(JMenuItem menuItem) {
        KeyStroke ksOld;
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        IdeAction action = (IdeAction)menuItem.getAction();
        KeyStroke accelerator = null;
        if (action != null) {
            HashMap localKeyMaps;
            int nCmdID = action.getCommandId();
            KeyStrokeMap ksm = kso.getGlobalKeyMap();
            accelerator = KeyUtil.getBestAccelerator(ksm, nCmdID);
            if (accelerator == null && (localKeyMaps = kso.getLocalKeyMaps()) != null) {
                KeyStrokeMap localKeyMap;
                ArrayList keys = new ArrayList(localKeyMaps.values());
                Iterator iterator = keys.iterator();
                while (iterator.hasNext() && (accelerator = KeyUtil.getBestAccelerator(localKeyMap = (KeyStrokeMap)iterator.next(), nCmdID)) == null) {
                }
            }
        }
        if ((ksOld = menuItem.getAccelerator()) == null) {
            if (accelerator != null) {
                menuItem.setAccelerator(accelerator);
            }
        } else if (!ksOld.equals(accelerator)) {
            menuItem.setAccelerator(null);
            if (accelerator != null) {
                menuItem.setAccelerator(accelerator);
            }
        }
    }

    private void adjustSeparators(Container menu) {
        if (menu.getComponentCount() < 2) {
            return;
        }
        boolean validateContainer = false;
        boolean foundSeparator = false;
        Component[] menuItems = menu.getComponents();
        for (int i = menuItems.length - 1; i >= 0; --i) {
            boolean sep = menuItems[i] instanceof JSeparator;
            if (foundSeparator && sep) {
                menu.remove(menuItems[i]);
                validateContainer = true;
            }
            foundSeparator = sep;
        }
        if (validateContainer) {
            menu.validate();
        }
    }

    private void addToMenubar(JMenuBar menubar, Component child) {
        if (menubar.getComponentCount() == 0) {
            menubar.add(child);
            menubar.validate();
            return;
        }
        JComponent item = (JComponent)child;
        Float weight = (Float)item.getClientProperty("menu-weight");
        if (weight == null) {
            weight = new Float(Float.MAX_VALUE);
        }
        Component[] children = menubar.getComponents();
        for (int i = 0; i < children.length; ++i) {
            int weightCompare;
            if (children[i] == child) {
                return;
            }
            JComponent nextItem = (JComponent)children[i];
            Float nextItemWeight = (Float)nextItem.getClientProperty("menu-weight");
            int n = weightCompare = nextItemWeight != null ? weight.compareTo(nextItemWeight) : 1;
            if (weightCompare >= 0) continue;
            menubar.add(child, i);
            menubar.validate();
            return;
        }
        menubar.add(child);
        menubar.validate();
    }

    public void sortContainer(Container container) {
        if (container == null) {
            return;
        }
        Component[] children = container instanceof JMenu ? ((JMenu)container).getMenuComponents() : container.getComponents();
        HashMap data = new HashMap();
        for (Component child : children) {
            ArrayList<JComponent> list;
            if (child instanceof JSeparator || !(child instanceof JComponent)) continue;
            JComponent item = (JComponent)child;
            Float f = (Float)item.getClientProperty("menu-section-id");
            if (f == null) {
                f = new Float(Float.MAX_VALUE);
            }
            if ((list = (ArrayList<JComponent>)data.get(f)) == null) {
                list = new ArrayList<JComponent>();
                data.put(f, list);
            }
            if (list.contains(item)) continue;
            list.add(item);
        }
        container.removeAll();
        ArrayList sectionIds = new ArrayList(data.keySet());
        if (sectionIds.size() > 1) {
            Collections.sort(sectionIds);
        }
        HashSet alphaSortSections = container instanceof JComponent ? (HashSet)((JComponent)container).getClientProperty(ALPHA_SORT_SECTION_KEY) : null;
        MenuWeightComparator comparator = new MenuWeightComparator(alphaSortSections);
        int counter = 0;
        int size = sectionIds.size();
        Component last = null;
        for (Float id : sectionIds) {
            List itemList = (List)data.get(id);
            if (itemList.size() > 1) {
                Collections.sort(itemList, comparator);
            }
            for (Component comp : itemList) {
                if (comp == null || comp instanceof JSeparator) continue;
                container.add(comp);
                last = comp;
                if (!IdeAction.DEBUG) continue;
                this.printDebugInfo(container, comp);
            }
            boolean useSeparators = !(container instanceof JMenuBar);
            if (!useSeparators || ++counter == size || last == null) continue;
            container.add(new JPopupMenu.Separator());
        }
        container.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDebugInfo(Component ... components) {
        StringBuilder b = new StringBuilder();
        try {
            String delim = "ide.IdeAction.debug info: ";
            for (Component c : components) {
                if (!(c instanceof JMenuItem)) continue;
                b.append(delim);
                delim = " > ";
                b.append(((JMenuItem)c).getText()).append(" [id=").append(this.getId(c)).append("]");
            }
        }
        catch (Exception exception) {
        }
        finally {
            System.out.println(b.toString());
        }
    }

    protected final void addMenuManagerAsListener(Component component) {
        if (component instanceof JMenu) {
            JMenu menu = (JMenu)component;
            EventListener[] listeners = menu.getListeners(MenuListener.class);
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i] != this._listener) continue;
                return;
            }
            menu.addMenuListener(this._listener);
            menu.getPopupMenu().addContainerListener(this._listener);
        }
    }

    protected final void removeMenuManagerAsListener(Component component) {
        if (component instanceof JMenu) {
            JMenu menu = (JMenu)component;
            menu.removeMenuListener(this._listener);
            menu.getPopupMenu().removeContainerListener(this._listener);
        }
    }

    public final String getId(Component menuComponent) {
        JMenuItem menuItem;
        Action action;
        if (menuComponent == null) {
            throw new NullPointerException("menuComponent is null");
        }
        if (menuComponent instanceof JMenu) {
            return MenuManager.getMenuId((JMenu)menuComponent);
        }
        if (menuComponent instanceof JMenuItem && (action = (menuItem = (JMenuItem)menuComponent).getAction()) instanceof IdeAction) {
            IdeAction ideAction = (IdeAction)action;
            int intId = ideAction.getCommandId();
            return Ide.findCmdName(intId);
        }
        return "";
    }

    private static void ensureAccessibleParentSet(Object child, Object parent) {
        AccessibleContext aContext;
        if (!AccessibleUtils.isAssistiveTechnologySet()) {
            return;
        }
        if (parent != null && child != null && parent instanceof JMenu && child instanceof JMenu && (aContext = ((Accessible)child).getAccessibleContext()) != null) {
            aContext.setAccessibleParent((Accessible)parent);
        }
    }

    protected static class CustomMenu
    extends JMenu {
        public static void updateMnemonic(JMenu menu, Integer mnemonic) {
            int vk;
            String newText;
            String text = menu.getText();
            int keyCode = StringUtils.getMnemonicKeyCode((String)text);
            if (mnemonic == null || keyCode != 0) {
                mnemonic = keyCode;
            }
            if (text != null && mnemonic != null && !(newText = StringUtil.addMnemonicToLabelIfNotPresentAlready((String)text, (Integer)mnemonic)).equals(text)) {
                menu.setText(newText);
            }
            if ((vk = CustomMenu.getKeyboardMnemonic(mnemonic)) != 0) {
                menu.setMnemonic(vk);
            }
        }

        private void setMnemonic(Integer mnemonic) {
            CustomMenu.updateMnemonic(this, mnemonic);
        }

        private static int getKeyboardMnemonic(Integer mnemonic) {
            if (mnemonic != null) {
                int keyCode = mnemonic;
                if (keyCode >= 97 && keyCode <= 122) {
                    keyCode -= 32;
                }
                return keyCode;
            }
            return 0;
        }

        @Override
        public JMenuItem add(JMenuItem menuItem) {
            JMenuItem returnItem = super.add(menuItem);
            if (!(returnItem instanceof MenuItem) && !(returnItem instanceof ToggleMenuItem) && !(returnItem instanceof RadioMenuItem) && returnItem.getIcon() == null && PlatformUtils.isMac()) {
                returnItem.setIcon((Icon)new NullIcon());
            }
            return returnItem;
        }
    }

    private class L
    implements ContainerListener,
    MenuListener {
        private L() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (!Boolean.TRUE.equals(menu.getClientProperty(MenuManager.SORT_MENU_KEY))) {
                MenuManager.this.sortContainer(menu);
                menu.putClientProperty(MenuManager.SORT_MENU_KEY, Boolean.TRUE);
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            this.ensureSortOnShow(e);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            this.ensureSortOnShow(e);
        }

        private void ensureSortOnShow(ContainerEvent e) {
            JPopupMenu popupMenu = (JPopupMenu)e.getSource();
            JMenu menu = (JMenu)popupMenu.getInvoker();
            menu.putClientProperty(MenuManager.SORT_MENU_KEY, null);
        }
    }

    private final class PrivateContainerListener
    implements ContainerListener {
        private PrivateContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component child = e.getChild();
            if (child instanceof JMenu) {
                this.addListenersToTree(((JMenu)child).getPopupMenu());
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component child = e.getChild();
            if (child instanceof JMenu) {
                this.removeListenersFromTree(((JMenu)child).getPopupMenu());
            }
        }

        private void addListenersToTree(JPopupMenu root) {
            JMenu menu = (JMenu)root.getInvoker();
            if (menu != null) {
                menu.addMenuListener(MenuManager.this._menuListener);
                root.addContainerListener(this);
            }
            Component[] components = root.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof JMenu)) continue;
                this.addListenersToTree(((JMenu)components[i]).getPopupMenu());
            }
        }

        private void removeListenersFromTree(JPopupMenu root) {
            JMenu menu = (JMenu)root.getInvoker();
            if (menu != null) {
                menu.removeMenuListener(MenuManager.this._menuListener);
                root.removeContainerListener(this);
            }
            Component[] components = root.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof JMenu)) continue;
                this.removeListenersFromTree(((JMenu)components[i]).getPopupMenu());
            }
        }
    }

    private final class PrivateMenuListener
    implements MenuListener {
        private ActiveViewListener activeViewListener;

        private PrivateMenuListener() {
        }

        @Override
        public final void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            View activeView = Ide.getMainWindow().getLastActiveView();
            if (DockStationImpl.isComponentFloated(activeView.getGUI())) {
                DockStationImpl.getInstance().setIgnoreNextViewUpdate(true);
            }
            this.addActiveViewListener(e);
            MenuManager.updateMenuItems(menu, e);
            MenuManager.resolveMnemonics(menu);
        }

        @Override
        public final void menuDeselected(MenuEvent e) {
            this.removeActiveViewListener();
        }

        @Override
        public final void menuCanceled(MenuEvent e) {
            this.removeActiveViewListener();
        }

        private IdeMainWindow getIdeMainWindow() {
            if (IdeUtil.getMainWindow() instanceof IdeMainWindow) {
                return (IdeMainWindow)((Object)IdeUtil.getMainWindow());
            }
            return null;
        }

        private void addActiveViewListener(final MenuEvent menuEvent) {
            IdeMainWindow mainWindow = this.getIdeMainWindow();
            if (mainWindow == null) {
                return;
            }
            this.removeActiveViewListener();
            final JMenu menu = (JMenu)menuEvent.getSource();
            this.activeViewListener = new ActiveViewListener(){

                @Override
                public void activeViewChanged(ActiveViewEvent activeViewEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            MenuManager.updateMenuItems(menu, menuEvent);
                            MenuManager.resolveMnemonics(menu);
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            };
            mainWindow.addActiveViewListener(this.activeViewListener);
        }

        private void removeActiveViewListener() {
            IdeMainWindow mainWindow = this.getIdeMainWindow();
            if (mainWindow != null && this.activeViewListener != null) {
                mainWindow.removeActiveViewListener(this.activeViewListener);
            }
            this.activeViewListener = null;
        }
    }

    private static final class InnerChangeAdaptor
    extends ChangeAdaptor {
        public InnerChangeAdaptor(AbstractButton adaptee, ChangeEventSource action) {
            super(adaptee, action);
        }

        @Override
        protected void _stateChanged(ChangeEvent e) {
            final JMenuItem menuItem = (JMenuItem)this.getAdaptee();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuManager.refreshMenuItem(menuItem);
                }
            });
        }
    }
}

