/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.macros.MacroHandler;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.macros.MacroHook;
import oracle.ideimpl.macros.MacrosArb;

public class MacroUtils {
    private static final String MACRO_PATTERN = "\\$\\{.+\\}";
    private static Logger LOG = Logger.getLogger("MacroUtils");

    public static List<String> getMacroNames(Context context) {
        ArrayList<String> results = new ArrayList<String>();
        Workspace workspace = context == null ? null : context.getWorkspace();
        Project project = context == null ? null : context.getProject();
        for (MacroHandler handler : MacroHook.getMacroHandlers(workspace, project).values()) {
            for (String macro : handler.getNames(context)) {
                results.add(handler.getQualifier() + ":" + macro);
            }
        }
        return results;
    }

    public static List<String> getMacroExpressions(Context context) {
        ArrayList<String> results = new ArrayList<String>();
        Workspace workspace = context == null ? null : context.getWorkspace();
        Project project = context == null ? null : context.getProject();
        for (MacroHandler handler : MacroHook.getMacroHandlers(workspace, project).values()) {
            for (String macro : handler.getNames(context)) {
                results.add("${" + handler.getQualifier() + ":" + macro + "}");
            }
        }
        return results;
    }

    public static List<MacroHandler> getMacroHandlers(Context context) {
        Workspace workspace = context == null ? null : context.getWorkspace();
        Project project = context == null ? null : context.getProject();
        return new ArrayList<MacroHandler>(MacroHook.getMacroHandlers(workspace, project).values());
    }

    public static String getQualifier(String macro) {
        String qualifiedKey = macro.replaceAll("\\$\\{", "").replaceAll("\\}", "");
        int separatorLocation = qualifiedKey.indexOf(58);
        if (separatorLocation == -1) {
            return null;
        }
        String qualifier = qualifiedKey.substring(0, separatorLocation);
        return qualifier;
    }

    public static String getKey(String macro) {
        String qualifiedKey = macro.replaceAll("\\$\\{", "").replaceAll("\\}", "");
        int separatorLocation = qualifiedKey.indexOf(58);
        if (separatorLocation == -1) {
            return null;
        }
        String key = qualifiedKey.substring(separatorLocation + 1);
        return key;
    }

    public static MacroHandler getHandler(Context context, String qualifier) {
        Workspace workspace = context == null ? null : context.getWorkspace();
        Project project = context == null ? null : context.getProject();
        return MacroHook.getMacroHandlers(workspace, project).get(qualifier);
    }

    public static String getDescription(Context context, String macro) {
        String qualifier = MacroUtils.getQualifier(macro);
        if (qualifier == null) {
            return MacrosArb.get("NO_DESCRIPTION_AVAILABLE");
        }
        String key = MacroUtils.getKey(macro);
        MacroHandler handler = MacroUtils.getHandler(context, qualifier);
        if (handler == null) {
            return MacrosArb.get("NO_DESCRIPTION_AVAILABLE");
        }
        return handler.getDescription(context, key);
    }

    public static String getValue(Context context, String macro) {
        String qualifier = MacroUtils.getQualifier(macro);
        if (qualifier == null) {
            return macro;
        }
        String key = MacroUtils.getKey(macro);
        MacroHandler handler = MacroUtils.getHandler(context, qualifier);
        if (handler == null) {
            return macro;
        }
        String value = handler.getValue(context, key);
        if (value == null) {
            return macro;
        }
        if (MacroUtils.isMacroExpression(value)) {
            String original = value;
            value = MacroUtils.expand(context, original);
        }
        return value;
    }

    public static URL getValueAsURL(Context context, String macro) {
        return MacroUtils.getValueAsURL(context, macro, false);
    }

    public static URL getValueAsURL(Context context, String macro, boolean mustBeDirectory) {
        String value = MacroUtils.getValue(context, macro);
        if (mustBeDirectory && !value.endsWith(File.separator)) {
            value = value + File.separator;
        }
        URL fileURL = !value.contains(":/") ? URLFactory.newFileURL((String)value) : URLFactory.newURL((String)value);
        return fileURL;
    }

    public static boolean isMacroExpression(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        return MacroUtils.getFirstMacroInExpression(expression) != null;
    }

    public static String getFirstMacroInExpression(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Pattern p = Pattern.compile(MACRO_PATTERN);
        Matcher m = p.matcher(expression);
        if (m.find()) {
            return m.group();
        }
        return null;
    }

    public static String expand(Context context, String expression) {
        if (expression == null) {
            return null;
        }
        Pattern p = Pattern.compile(MACRO_PATTERN);
        Matcher m = p.matcher(expression);
        StringBuffer result = new StringBuffer();
        String slash = "\\";
        String dollar = "$";
        String expansion = null;
        while (m.find()) {
            String macro = m.group();
            String qualifier = MacroUtils.getQualifier(macro);
            MacroHandler handler = MacroUtils.getHandler(context, qualifier);
            String key = MacroUtils.getKey(macro);
            if (handler != null && key != null) {
                expansion = handler.getValue(context, key);
            }
            if (expansion == null) {
                expansion = macro;
            }
            if (expansion != null) {
                m.appendReplacement(result, Matcher.quoteReplacement(expansion));
                continue;
            }
            String escapedMacro = macro.replace(dollar, slash + dollar);
            m.appendReplacement(result, escapedMacro);
        }
        m.appendTail(result);
        String resultString = result.toString();
        resultString = resultString.replace(slash + dollar, dollar);
        return resultString;
    }

    public static URL expandAndMakeURL(Context context, String expression) {
        String expanded = MacroUtils.expand(context, expression);
        URL url = MacroUtils.makeURLFromString(expanded);
        return url;
    }

    public static URL expand(Context context, URL url) {
        String initialUrlAsString = url.toExternalForm();
        String resultUrlAsString = MacroUtils.expand(context, initialUrlAsString);
        URL result = MacroUtils.makeURLFromString(resultUrlAsString);
        if (result == null) {
            return url;
        }
        return result;
    }

    private static URL makeURLFromString(String expression) {
        URL url;
        if (expression == null) {
            return null;
        }
        String pathExpression = expression = expression.replaceAll("macro:", "");
        String protocol = "file";
        if (expression.indexOf(":/") != -1) {
            protocol = expression.substring(0, expression.indexOf(":/"));
            pathExpression = expression.substring(expression.indexOf(":/") + 1);
        }
        if (protocol.equals("file")) {
            if (pathExpression.contains(".jar")) {
                url = URLFactory.newFileURL((String)pathExpression.replaceAll(".jar!/", ".jar"));
                url = URLFactory.newJarURL((URL)url, null);
            } else {
                url = URLFactory.newFileURL((String)pathExpression);
            }
        } else if (protocol.equals("jar:file")) {
            url = URLFactory.newFileURL((String)pathExpression.replaceAll(".jar!/", ".jar"));
            url = URLFactory.newJarURL((URL)url, null);
        } else {
            url = URLFactory.newURL((String)protocol, (String)pathExpression);
        }
        return url;
    }

    public static URL getMacroExpressionFormOfExpandedURL(URL url, String activeMacroExpression, String activeMacroExpandedValue) {
        String path;
        if (activeMacroExpandedValue == null) {
            return url;
        }
        activeMacroExpandedValue = activeMacroExpandedValue.replaceFirst("file:", "");
        if (File.separatorChar == '\\') {
            activeMacroExpression = activeMacroExpression.replace('\\', '/');
            activeMacroExpandedValue = activeMacroExpandedValue.replace('\\', '/');
        }
        if ((path = url.getPath()).contains(activeMacroExpandedValue)) {
            url = URLFactory.replacePathPart((URL)url, (String)path.replace(activeMacroExpandedValue, activeMacroExpression));
        }
        return url;
    }

    public static class URLWrapper
    extends DefaultElement
    implements Locatable {
        private URL urlWithMacroName;

        public URLWrapper(URL url) {
            this.urlWithMacroName = url;
        }

        public URL getURL() {
            return this.urlWithMacroName;
        }

        public void setURL(URL url) {
            this.urlWithMacroName = url;
        }
    }
}

