/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.ide.util.MetaClass;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.help.Cell;
import oracle.jdeveloper.help.Parameter;
import oracle.jdevimpl.help.ColorUtils;
import oracle.jdevimpl.help.Link;
import oracle.jdevimpl.help.StartPageExtArb;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class RSSFeed
extends JPanel {
    private String url;
    private boolean showProxyButton = true;
    private RequestProcessor.Task reloadTimer;
    private long lastReload = 0L;
    static final int TIME_CONVERSION = 60000;
    private static final int RSS_ITEM_HEIGHT = 50;
    private int PANEL_WIDTH;
    private int MAX_ENTRIES;
    private final Insets TITLE_INSETS = new Insets(0, 0, 1, 0);
    private final Insets DATE_INSETS = new Insets(0, 14, 1, 0);
    private final Insets DESCRIPTION_INSETS = new Insets(0, 0, 10, 0);
    private List<DateFormat> parsingDateFormats = new ArrayList<DateFormat>(7);
    private DateFormat displayDateFormat = DateFormat.getDateInstance(3);
    private String[] formatStrings = new String[]{"EEE, dd MMM yyyy HH:mm:ss Z", "EEE, dd MMM yyyy", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd"};
    private static int TITLE_LEN = 0;
    private static int DESCRIPTION_LEN = 1;
    private static int TITLE_MULTIPLIER = 1;
    private static int DESCRIPTION_MULTIPLIER = 2;
    private boolean isCached = false;
    private final Logger LOGGER = Logger.getLogger(RSSFeed.class.getName());
    private int maxTitleChars = -1;
    private int maxDescriptionChars = -1;
    private static final RequestProcessor RP = new RequestProcessor("StartPage");
    private int RSS_FEED_TIMER_RELOAD_MILLIS;
    private ChangeListener _proxyOptionsChangeListener;
    private Font _fontForMetrics;
    private Font _fontForMetricsTitle;
    private static Pattern COMMENT_PATTERN = Pattern.compile("(?s)<!--.*?-->");
    private static Pattern TAG_PATTERN = Pattern.compile("<.*?>");
    private static Pattern NBSP_WHITESPACE_PATTERN = Pattern.compile("(&nbsp;|\\s)+");
    private static final long serialVersionUID = 1L;

    private static File initCacheStore(String path) throws IOException {
        File cacheStore;
        String userDir = System.getProperty("InstalledFileLocator/Places");
        if (userDir != null) {
            cacheStore = new File(new File(new File(userDir, "var"), "cache"), "welcome");
        } else {
            File cachedir = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            cacheStore = new File(cachedir, "welcome");
        }
        cacheStore = new File(cacheStore, path);
        cacheStore.getParentFile().mkdirs();
        cacheStore.createNewFile();
        return cacheStore;
    }

    public RSSFeed() {
        super(new GridBagLayout());
        this.setOpaque(false);
        JLabel label = new JLabel();
        Font f = label.getFont();
        this._fontForMetrics = f.deriveFont(0, 11.0f);
        this._fontForMetricsTitle = f.deriveFont(1, 11.0f);
    }

    public void initialize(String url, boolean showProxyButton, int refreshTime, Locale dateLocale, int maxEntries, int panelWidth) {
        this.url = url;
        this.showProxyButton = showProxyButton;
        this.RSS_FEED_TIMER_RELOAD_MILLIS = refreshTime * 60000;
        this.MAX_ENTRIES = maxEntries;
        this.PANEL_WIDTH = panelWidth;
        this.setBorder(null);
        try {
            for (String formatString : this.formatStrings) {
                this.parsingDateFormats.add(new SimpleDateFormat(formatString, dateLocale));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.add((Component)this.buildContentLoadingLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.PANEL_WIDTH, 50 * this.getMaxItemCount());
    }

    public void setContent(Component content) {
        this.removeAll();
        this.add(content, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.revalidate();
        this.invalidate();
        this.repaint();
    }

    public Component getContent() {
        return this;
    }

    public void reload() {
        new Reload().start();
    }

    protected int getMaxItemCount() {
        return this.MAX_ENTRIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FeedItem> buildItemList() throws SAXException, ParserConfigurationException, IOException {
        XMLReader reader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
        FeedHandler handler = new FeedHandler(this.getMaxItemCount());
        reader.setContentHandler(handler);
        reader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
        reader.setErrorHandler(new ErrorCatcher());
        InputSource is = null;
        try {
            is = this.findInputSource(new URL(this.url));
            reader.parse(is);
        }
        catch (SAXParseException sAXParseException) {
        }
        finally {
            if (is != null && is.getByteStream() != null) {
                try {
                    is.getByteStream().close();
                }
                catch (Exception exception) {}
            }
        }
        return handler.getItemList();
    }

    protected final String url2path(URL u) {
        StringBuilder pathSB = new StringBuilder(u.getHost());
        if (u.getPort() != -1) {
            pathSB.append(u.getPort());
        }
        pathSB.append(u.getPath());
        if (null != u.getQuery()) {
            pathSB.append(u.getQuery());
        }
        return pathSB.toString();
    }

    protected InputSource findInputSource(URL u) throws IOException {
        HttpURLConnection httpCon = (HttpURLConnection)u.openConnection();
        httpCon.setUseCaches(true);
        httpCon.setRequestProperty("Accept-Encoding", "gzip, deflate");
        java.util.prefs.Preferences prefs = NbPreferences.forModule(RSSFeed.class);
        String path = this.url2path(u);
        String lastModified = prefs.get(path, null);
        if (lastModified != null) {
            httpCon.addRequestProperty("If-Modified-Since", lastModified);
        }
        httpCon.connect();
        if (httpCon.getResponseCode() == 304) {
            File cacheFile = RSSFeed.initCacheStore(path);
            this.LOGGER.log(Level.FINE, "Reading content of {0} from {1}", new Object[]{u.toString(), cacheFile.getAbsolutePath()});
            this.isCached = true;
            return new InputSource(new BufferedInputStream(new FileInputStream(cacheFile)));
        }
        String encoding = httpCon.getContentEncoding();
        this.LOGGER.log(Level.FINER, "Connection encoding: {0}", encoding);
        this.LOGGER.log(Level.FINER, "ETag: {0}", httpCon.getHeaderField("ETag"));
        InputStream is = null;
        is = "gzip".equalsIgnoreCase(encoding) ? new GZIPInputStream(httpCon.getInputStream()) : ("deflate".equalsIgnoreCase(encoding) ? new InflaterInputStream(httpCon.getInputStream(), new Inflater(true)) : httpCon.getInputStream());
        this.LOGGER.log(Level.FINE, "Reading {0} from original source and caching", this.url);
        return new InputSource(new CachingInputStream(is, path, httpCon.getHeaderField("Last-Modified")));
    }

    protected void clearCache() {
        try {
            NbPreferences.forModule(RSSFeed.class).remove(this.url2path(new URL(this.url)));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected Component createFeedItemComponent(FeedItem item) {
        JLabel label;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        String itemTitle = this.trimHtml(item.title, TITLE_LEN);
        Link linkButton = new Link(item.title);
        linkButton.setCell(new RSSCellInfo(item, itemTitle));
        linkButton.setFont(linkButton.getFont().deriveFont(1, 11.0f));
        linkButton.setForeground(ColorUtils.rssTextColor);
        GridBagConstraints constr = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, this.TITLE_INSETS, 0, 0);
        panel.add((Component)((Object)linkButton), constr);
        if (item.dateTime != null) {
            label = new JLabel();
            label.setFont(label.getFont().deriveFont(1, 10.0f));
            label.setForeground(ColorUtils.rssDateColor);
            label.setText(this.formatDateTime(item.dateTime));
            ++constr.gridx;
            constr.weightx = 0.0;
            constr.insets = this.DATE_INSETS;
            constr.fill = 2;
            panel.add((Component)label, constr);
        }
        if (item.description != null) {
            label = new JWrappedLabel();
            label.setBorder(BorderFactory.createEmptyBorder());
            label.setFocusable(true);
            label.setText(this.trimHtml(item.description, DESCRIPTION_LEN));
            label.setFont(label.getFont().deriveFont(0, 11.0f));
            label.setForeground(ColorUtils.rssTextColor);
            label.setOpaque(false);
            constr.gridx = 0;
            constr.gridwidth = 2;
            constr.insets = this.DESCRIPTION_INSETS;
            constr.weightx = 1.0;
            constr.fill = 2;
            ++constr.gridy;
            panel.add((Component)label, constr);
        }
        return panel;
    }

    protected static String getTextContent(Node node) {
        Node child = node.getFirstChild();
        if (null == child) {
            return null;
        }
        return child.getNodeValue();
    }

    protected String formatDateTime(String strDateTime) {
        Date returnDate = null;
        for (DateFormat dateFormat : this.parsingDateFormats) {
            try {
                returnDate = dateFormat.parse(strDateTime);
                break;
            }
            catch (ParseException ex) {
            }
        }
        if (returnDate != null) {
            return this.displayDateFormat.format(returnDate);
        }
        return strDateTime;
    }

    @Override
    public void removeNotify() {
        this.stopReloading();
        if (this._proxyOptionsChangeListener != null) {
            ProxyOptions options = ProxyOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            options.removeChangeListener(this._proxyOptionsChangeListener);
            this._proxyOptionsChangeListener = null;
        }
        this.maxTitleChars = -1;
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getMaxStringLength(TITLE_LEN);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RSSFeed.this.startReloading();
            }
        };
        SwingUtilities.invokeLater(runnable);
        this._proxyOptionsChangeListener = new ProxyOptionsChangeListener();
        ProxyOptions options = ProxyOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        options.addChangeListener(this._proxyOptionsChangeListener);
    }

    protected void startReloading() {
        if (null == this.reloadTimer && !Boolean.getBoolean("netbeans.full.hack")) {
            if (System.currentTimeMillis() - this.lastReload >= (long)this.RSS_FEED_TIMER_RELOAD_MILLIS) {
                this.reload();
            } else {
                this.reloadTimer = RP.post((Runnable)new Reload(), Math.max(1, (int)((long)this.RSS_FEED_TIMER_RELOAD_MILLIS - (System.currentTimeMillis() - this.lastReload))));
            }
        }
    }

    protected void stopReloading() {
        if (null != this.reloadTimer) {
            this.reloadTimer.cancel();
            this.reloadTimer = null;
        }
    }

    private String trimHtml(String htmlSnippet, int type) {
        String res = this.stripHtml(htmlSnippet);
        int maxLen = this.getMaxStringLength(type);
        if (maxLen > 0 && res.length() > maxLen) {
            res = res.substring(0, maxLen - 3) + "...";
        }
        return res;
    }

    private String stripHtml(String htmlSnippet) {
        Matcher m = COMMENT_PATTERN.matcher(htmlSnippet);
        StringBuffer result = new StringBuffer(htmlSnippet.length());
        while (m.find()) {
            m.appendReplacement(result, "");
        }
        m.appendTail(result);
        m = TAG_PATTERN.matcher(result);
        result = new StringBuffer(result.length());
        while (m.find()) {
            m.appendReplacement(result, "");
        }
        m.appendTail(result);
        m = NBSP_WHITESPACE_PATTERN.matcher(result);
        result = new StringBuffer(result.length());
        while (m.find()) {
            m.appendReplacement(result, " ");
        }
        m.appendTail(result);
        return result.toString().trim();
    }

    protected int getMaxStringLength(int type) {
        int maxChars;
        int n = maxChars = type == TITLE_LEN ? this.maxTitleChars : this.maxDescriptionChars;
        if (maxChars < 0 && this.getWidth() > 0) {
            try {
                int multiplier;
                FontMetrics fm;
                Graphics2D g = (Graphics2D)this.getGraphics();
                if (type == TITLE_LEN) {
                    fm = g.getFontMetrics(this._fontForMetricsTitle);
                    multiplier = TITLE_MULTIPLIER;
                } else {
                    fm = g.getFontMetrics(this._fontForMetrics);
                    multiplier = DESCRIPTION_MULTIPLIER;
                }
                double charWidth = fm.getStringBounds("Ab c", g).getWidth() / 4.0;
                double feedWidth = this.getWidth();
                maxChars = multiplier * (int)(feedWidth / charWidth);
                this.setMaxChars(type, maxChars);
            }
            catch (Throwable e) {
                maxChars = 30;
                this.setMaxChars(type, maxChars);
            }
        }
        return maxChars;
    }

    private void setMaxChars(int type, int length) {
        if (type == TITLE_LEN) {
            this.maxTitleChars = length;
        } else {
            this.maxDescriptionChars = length;
        }
    }

    private JComponent buildProxyPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints constr = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0);
        panel.add((Component)new JLabel(StartPageExtArb.get("CANNOT_CONNECT_LABEL")), constr);
        if (this.showProxyButton) {
            JButton button = new JButton();
            ResourceUtils.resButton((AbstractButton)button, (String)StartPageExtArb.get("PROXY_CONFIG_BUTTON"));
            button.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    JEWTDialog dlg = new JEWTDialog((Frame)Ide.getMainWindow(), StartPageExtArb.get("PROXY_SETTINGS_DIALOG_TITLE"));
                    dlg.setButtonMask(3);
                    ProxyOptions options = ProxyOptions.getProxyOptions();
                    ProxySettingsPanel psp = new ProxySettingsPanel();
                    psp.setProxyOptions(options);
                    dlg.setContent((Component)psp);
                    try {
                        if (dlg.runDialog()) {
                            ProxyOptions.setProxyOptions((ProxyOptions)psp.getProxyOptions());
                        }
                    }
                    finally {
                        dlg.dispose();
                    }
                }
            });
            ++constr.gridy;
            panel.add((Component)button, constr);
        }
        return panel;
    }

    private JComponent buildContentLoadingLabel() {
        JLabel label = new JLabel(StartPageExtArb.get("CONTENT_LOADING_LABEL"));
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setOpaque(false);
        label.setBorder(BorderFactory.createEmptyBorder(40, 0, 40, 0));
        return label;
    }

    private JComponent buildErrorLabel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints constr = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0);
        panel.add((Component)new JLabel(StartPageExtArb.get("ERROR_LOADING_FEED")), constr);
        JButton button = new JButton();
        ResourceUtils.resButton((AbstractButton)button, (String)StartPageExtArb.get("RELOAD_BUTTON"));
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RSSFeed.this.lastReload = 0L;
                RSSFeed.this.reload();
            }
        });
        ++constr.gridy;
        panel.add((Component)button, constr);
        return panel;
    }

    public boolean isContentCached() {
        return this.isCached;
    }

    private static class RSSCellInfo
    implements Cell {
        FeedItem _feedItem;
        String _itemTitle;

        public RSSCellInfo(FeedItem feedItem, String itemTitle) {
            this._feedItem = feedItem;
            this._itemTitle = itemTitle;
        }

        @Override
        public String getCompId() {
            return null;
        }

        @Override
        public String getTabRef() {
            return null;
        }

        @Override
        public String getColumnRef() {
            return null;
        }

        @Override
        public String getName() {
            return this._itemTitle;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public float getWeight() {
            return 0.0f;
        }

        @Override
        public List<Parameter> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public Parameter getParameter(String parameterName) {
            return null;
        }

        @Override
        public void setParameter(String parameterName, String value) {
        }

        @Override
        public String getParameterValue(String parameterName) {
            if (parameterName.equals("buttonType")) {
                return "url";
            }
            if (parameterName.equals("url")) {
                return this._feedItem.link;
            }
            return null;
        }

        @Override
        public MetaClass getMetaClass(String parameterName) {
            return null;
        }

        @Override
        public Icon getIcon(String parameterName) {
            return null;
        }
    }

    private class ProxyOptionsChangeListener
    implements ChangeListener {
        private ProxyOptionsChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RSSFeed.this.stopReloading();
            RSSFeed.this.removeAll();
            RSSFeed.this.add((Component)RSSFeed.this.buildContentLoadingLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            RSSFeed.this.lastReload = 0L;
            RSSFeed.this.reload();
        }
    }

    static class CachingInputStream
    extends FilterInputStream {
        private OutputStream os;
        private String modTime;
        private String path;

        CachingInputStream(InputStream is, String path, String time) throws IOException {
            super(is);
            File storage = RSSFeed.initCacheStore(path);
            this.os = new BufferedOutputStream(new FileOutputStream(storage));
            this.modTime = time;
            this.path = path;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.modTime != null) {
                NbPreferences.forModule(RSSFeed.class).put(this.path, this.modTime);
            }
            this.os.close();
        }

        @Override
        public int read() throws IOException {
            int val = super.read();
            this.os.write(val);
            return val;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int res = super.read(b, off, len);
            if (res != -1) {
                this.os.write(b, off, res);
            }
            return res;
        }
    }

    protected static class FeedItem {
        private String title;
        private String link;
        private String description;
        private String dateTime;
        private String enclosureUrl;

        protected FeedItem() {
        }

        public boolean isValid() {
            return null != this.title && null != this.link;
        }
    }

    static class FeedHandler
    implements ContentHandler {
        private FeedItem currentItem;
        private StringBuffer textBuffer;
        private int maxItemCount;
        private ArrayList<FeedItem> itemList;

        public FeedHandler(int maxItemCount) {
            this.maxItemCount = maxItemCount;
            this.itemList = new ArrayList(maxItemCount);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.itemList.size() < this.maxItemCount) {
                if ("item".equals(localName) || "entry".equals(localName)) {
                    this.currentItem = new FeedItem();
                } else if ("link".equals(localName) || "pubDate".equals(localName) || "date".equals(localName) || "published".equals(localName) || "description".equals(localName) || "content".equals(localName) || "title".equals(localName)) {
                    this.textBuffer = new StringBuffer(110);
                    if ("link".equals(localName) && null != this.currentItem && null != atts.getValue("href")) {
                        this.currentItem.link = this.fixFeedItemUrl(atts.getValue("href"));
                    }
                } else if ("enclosure".equals(localName) && null != this.currentItem) {
                    this.currentItem.enclosureUrl = atts.getValue("url");
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.itemList.size() < this.maxItemCount) {
                if ("item".equals(localName) || "entry".equals(localName)) {
                    if (null != this.currentItem && this.currentItem.isValid()) {
                        this.itemList.add(this.currentItem);
                    }
                    this.currentItem = null;
                } else if (null != this.currentItem && null != this.textBuffer) {
                    String text = this.textBuffer.toString().trim();
                    this.textBuffer = null;
                    if (0 == text.length()) {
                        text = null;
                    }
                    if ("link".equals(localName) && null == this.currentItem.link) {
                        this.currentItem.link = this.fixFeedItemUrl(text);
                    } else if ("pubDate".equals(localName) || "published".equals(localName) || "date".equals(localName)) {
                        if (this.currentItem.dateTime == null || this.currentItem.dateTime.length() == 0) {
                            this.currentItem.dateTime = text;
                        }
                    } else if ("title".equals(localName) && (this.currentItem.title == null || this.currentItem.title.length() == 0)) {
                        this.currentItem.title = text;
                    } else if ("description".equals(localName) || "content".equals(localName)) {
                        this.currentItem.description = text;
                    }
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (null != this.textBuffer) {
                this.textBuffer.append(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        public ArrayList<FeedItem> getItemList() {
            return this.itemList;
        }

        protected String fixFeedItemUrl(String url) {
            if (null != url && (url.contains(".netbeans.org") || url.contains("/netbeans.org"))) {
                url = url.contains("?") ? url + "&" : url + "?";
                url = url + "utm_source=netbeans&utm_campaign=welcomepage";
            }
            return url;
        }
    }

    private class Reload
    extends Thread {
        private Reload() {
        }

        @Override
        public void run() {
            try {
                RSSFeed.this.lastReload = System.currentTimeMillis();
                List<FeedItem> itemList = RSSFeed.this.buildItemList();
                final JPanel contentPanel = new JPanel(new GridBagLayout());
                contentPanel.setOpaque(false);
                GridBagConstraints constr = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
                for (int i = 0; i < Math.min(itemList.size(), RSSFeed.this.getMaxItemCount()); ++i) {
                    FeedItem item = itemList.get(i);
                    if (null == item.title || null == item.link) continue;
                    Component comp = RSSFeed.this.createFeedItemComponent(item);
                    contentPanel.add(comp, constr);
                    ++constr.gridy;
                }
                contentPanel.add((Component)new JLabel(), new GridBagConstraints(0, constr.gridy, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.setContent(contentPanel);
                    }
                });
                if (RSSFeed.this.RSS_FEED_TIMER_RELOAD_MILLIS > 0) {
                    RSSFeed.this.reloadTimer = RP.post((Runnable)this, RSSFeed.this.RSS_FEED_TIMER_RELOAD_MILLIS);
                } else {
                    RSSFeed.this.stopReloading();
                }
            }
            catch (UnknownHostException uhE) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildProxyPanel());
                    }
                });
            }
            catch (SocketException sE) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildProxyPanel());
                    }
                });
            }
            catch (IOException ioE) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildProxyPanel());
                    }
                });
            }
            catch (Exception e) {
                if (RSSFeed.this.isContentCached()) {
                    RSSFeed.this.isCached = false;
                    RSSFeed.this.clearCache();
                    RSSFeed.this.reload();
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildErrorLabel());
                    }
                });
                RSSFeed.this.LOGGER.log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    static class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(Level level, SAXParseException e) {
            Logger l = Logger.getLogger(RSSFeed.class.getName());
            l.log(level, "Line number:" + e.getLineNumber());
            l.log(level, "Column number:" + e.getColumnNumber());
            l.log(level, "Public ID:" + e.getPublicId());
            l.log(level, "System ID:" + e.getSystemId());
            l.log(level, "Error message:" + e.getMessage());
        }

        @Override
        public void error(SAXParseException e) {
            this.message(Level.SEVERE, e);
        }

        @Override
        public void warning(SAXParseException e) {
            this.message(Level.WARNING, e);
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.message(Level.SEVERE, e);
        }
    }
}

