/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Properties;
import oracle.dbtools.raptor.proxy.MethodTracker;
import oracle.dbtools.raptor.proxy.ProxyContext;
import oracle.dbtools.util.GCReapHandler;
import oracle.dbtools.util.GCTracker;

public abstract class AbstractProxy {
    private boolean initialized = false;
    private ProxyContext proxyContext;

    public AbstractProxy(ProxyContext proxyContext) {
        this.proxyContext = proxyContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(Properties properties) {
        if (!this.initialized) {
            AbstractProxy abstractProxy = this;
            synchronized (abstractProxy) {
                if (!this.initialized) {
                    try {
                        this.proxyContext.initialize(this, properties);
                    }
                    finally {
                        this.initialized = true;
                    }
                    GCTracker.getInstance().track((Object)this, (GCReapHandler)this.proxyContext);
                }
            }
        }
    }

    protected void initialize() {
        this.initialize(null);
    }

    protected MethodTracker.CallMetrics methodCalled(Method method, Object object, Object[] objectArray) {
        MethodTracker.CallMetrics callMetrics = MethodTracker.getInstance().methodCalled(method, object, objectArray);
        callMetrics.setStackTrace(Thread.currentThread().getStackTrace());
        callMetrics.setStartTime(new Date().getTime());
        return callMetrics;
    }

    protected MethodTracker.CallMetrics methodReturned(Method method) {
        long l = new Date().getTime();
        return this.methodCompleted(method, l, null, null);
    }

    protected MethodTracker.CallMetrics methodReturned(Method method, Object object) {
        long l = new Date().getTime();
        return this.methodCompleted(method, l, object, null);
    }

    protected MethodTracker.CallMetrics methodException(Method method, Throwable throwable) {
        long l = new Date().getTime();
        return this.methodCompleted(method, l, null, throwable);
    }

    private MethodTracker.CallMetrics methodCompleted(Method method, long l, Object object, Throwable throwable) {
        return MethodTracker.getInstance().methodReturned(method, object, throwable, l);
    }

    protected ProxyContext getProxyContext() {
        this.initialize();
        return this.proxyContext;
    }

    protected ProxyContext getSuperProxyContext() {
        Object object = this.getCreator();
        if (object instanceof AbstractProxy) {
            return ((AbstractProxy)object).getProxyContext();
        }
        return null;
    }

    protected void preForAll(Method method, Object object, Object ... objectArray) {
    }

    protected Object postForAll(Method method, Object object) {
        return object;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected abstract Object getDelegate();

    protected abstract void setDelegate(Object var1);

    protected abstract Object getCreator();

    protected DelegateCloser getDelegateCloser() {
        return null;
    }

    public static interface DelegateCloser {
        public void close(ProxyContext var1, Object var2);
    }
}

