/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.comp;

import java.util.Stack;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.NodeSource;
import oracle.xquery.exec.VarExpr;
import oracle.xquery.exec.Variable;

class CompStack {
    private Stack nodes = new Stack();
    private Stack marks = new Stack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;
    private static final boolean debug = false;

    public boolean empty() {
        return this.nodes.empty();
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    Object rootNode() {
        return this.nodes.elementAt(0);
    }

    void pushNode(Object object) {
        this.nodes.push(object);
        ++this.sp;
    }

    Object popNode() {
        if (--this.sp < this.mk) {
            this.mk = (Integer)this.marks.pop();
        }
        return this.nodes.pop();
    }

    Object peekNode() {
        return this.nodes.peek();
    }

    int nodeArity() {
        return this.sp - this.mk;
    }

    Object[] closeNodeScope() {
        Object[] objectArray = this.popNodes(this.nodeArity());
        this.mk = (Integer)this.marks.pop();
        return objectArray;
    }

    void openNodeScope() {
        this.marks.push(new Integer(this.mk));
        this.mk = this.sp;
    }

    Object[] popNodes(int n) {
        if (n <= 0) {
            return null;
        }
        Object[] objectArray = new Object[n];
        while (n-- > 0) {
            objectArray[n] = this.popNode();
        }
        return objectArray;
    }

    Expr[] closeExprNodeScope() {
        Expr[] exprArray = this.popExprNodes(this.nodeArity());
        this.mk = (Integer)this.marks.pop();
        return exprArray;
    }

    Expr[] popExprNodes(int n) {
        if (n <= 0) {
            return null;
        }
        Expr[] exprArray = new Expr[n];
        while (n-- > 0) {
            exprArray[n] = (Expr)this.popNode();
        }
        return exprArray;
    }

    Variable[] closeVariableNodeScope() {
        Variable[] variableArray = this.popVariableNodes(this.nodeArity());
        this.mk = (Integer)this.marks.pop();
        return variableArray;
    }

    private Variable[] popVariableNodes(int n) {
        if (n <= 0) {
            return null;
        }
        Variable[] variableArray = new Variable[n];
        while (n-- > 0) {
            variableArray[n] = ((VarExpr)this.popNode()).getVariable();
        }
        return variableArray;
    }

    String[] closeStrNodeScope() {
        String[] stringArray = this.popStrNodes(this.nodeArity());
        this.mk = (Integer)this.marks.pop();
        return stringArray;
    }

    String[] popStrNodes(int n) {
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        while (n-- > 0) {
            stringArray[n] = (String)this.popNode();
        }
        return stringArray;
    }

    NodeSource[] closeSrcNodeScope() {
        NodeSource[] nodeSourceArray = this.popSrcNodes(this.nodeArity());
        this.mk = (Integer)this.marks.pop();
        return nodeSourceArray;
    }

    NodeSource[] popSrcNodes(int n) {
        if (n <= 0) {
            return null;
        }
        NodeSource[] nodeSourceArray = new NodeSource[n];
        while (n-- > 0) {
            nodeSourceArray[n] = (NodeSource)this.popNode();
        }
        return nodeSourceArray;
    }
}

