/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.tables.SpatialListReorderableTableWithTitleBar;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.style.StyleColor;
import oracle.spatial.geometry.JGeometry;

public class SpatialShowGeometry
extends GridContextMenuItem {
    private static SpatialShowGeometry _instance;
    public static final String SPATIAL_SHOW_GEOMETRY_TITLE = "SpatialShowGeometry";
    public static final int SPATIAL_SHOW_GEOMETRY_ID;
    protected static IdeAction SPATIAL_SHOW_GEOMETRY;
    public static final String IDENTIFY_GEOMETRY_TITLE_IN_MAP = "IdentifyGeometryInMap";
    public static final int IDENTIFY_GEOMETRY_ID_IN_MAP;
    protected static IdeAction IDENTIFY_GEOMETRY_IN_MAP;
    JGeometry geom = null;
    ImageIcon img = null;
    private ArrayList<Struct> selectedGeometries;
    JEWTDialog dlg = null;

    private SpatialShowGeometry() {
        this.initAction();
    }

    private void initAction() {
        this.selectedGeometries = new ArrayList();
        if (SPATIAL_SHOW_GEOMETRY == null) {
            SPATIAL_SHOW_GEOMETRY = this.createAction(SPATIAL_SHOW_GEOMETRY_ID, StringUtils.stripMnemonic((String)SpatialArb.getString("ShowGeometry")), null);
        }
        if (IDENTIFY_GEOMETRY_IN_MAP == null) {
            IDENTIFY_GEOMETRY_IN_MAP = this.createAction(IDENTIFY_GEOMETRY_ID_IN_MAP, StringUtils.stripMnemonic((String)SpatialArb.getString("IdentifyGeometry")), null);
        }
    }

    public static SpatialShowGeometry getInstance() {
        if (_instance == null) {
            _instance = new SpatialShowGeometry();
        }
        return _instance;
    }

    protected boolean canShow(ContextMenu contextMenu) {
        this.selectedGeometries.clear();
        if (contextMenu.getContext().getEvent().getSource() instanceof ResultSetTable) {
            int n = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            int n2 = this._table.columnAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            n = this._table.convertRowIndexToModel(n);
            n2 = this._table.convertColumnIndexToModel(n2);
            Object object = this._table.getModel().getValueAt(n, n2);
            int[] nArray = this._table.getSelectedRows();
            int[] nArray2 = this._table.getSelectedColumns();
            Object[] objectArray = new Object[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    int n3 = nArray[i];
                    int n4 = nArray2[j];
                    Object object2 = this._table.getModel().getValueAt(this._table.convertRowIndexToModel(n3), this._table.convertColumnIndexToModel(n4));
                    if (!(object2 instanceof Struct)) continue;
                    try {
                        String string = ((Struct)object2).getSQLTypeName();
                        if (!string.equals("MDSYS.SDO_GEOMETRY")) continue;
                        this.selectedGeometries.add((Struct)object2);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                }
            }
            return this.selectedGeometries.size() > 0;
        }
        return false;
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        SpatialListReorderableTableWithTitleBar<?> spatialListReorderableTableWithTitleBar;
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)SPATIAL_SHOW_GEOMETRY);
        jMenuItem.setText(SpatialArb.getString("ShowGeometryShape"));
        contextMenu.add((Component)jMenuItem);
        JMenuItem jMenuItem2 = contextMenu.createMenuItem((ToggleAction)IDENTIFY_GEOMETRY_IN_MAP);
        jMenuItem2.setText(SpatialArb.getString("IdentifyShapeInMap"));
        contextMenu.add((Component)jMenuItem2);
        if (this.selectedGeometries.size() != 1) {
            jMenuItem.setEnabled(false);
        }
        if ((spatialListReorderableTableWithTitleBar = SpatialUtil.getPanel().getSelectedTabPage()) == null) {
            jMenuItem2.setEnabled(false);
        }
    }

    private ImageIcon generateGeometryIcon(JGeometry jGeometry) {
        StyleColor styleColor = new StyleColor(Color.red, Color.black);
        int n = 100;
        int n2 = 100;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        XFViewPort xFViewPort = new XFViewPort();
        xFViewPort.setDeviceView((Rectangle2D)new Rectangle2D.Double(2.0, 2.0, (double)n - 4.0, (double)n2 - 4.0));
        double[] dArray = jGeometry.getMBR();
        double d = dArray[2] - dArray[0];
        double d2 = dArray[3] - dArray[1];
        xFViewPort.setDataView((Rectangle2D)new Rectangle2D.Double(dArray[0], dArray[1], d, d2));
        AffineTransform affineTransform = xFViewPort.getAffineTransform();
        Shape shape = jGeometry.createShape(affineTransform, true);
        try {
            styleColor.apply(null, graphics2D, shape, jGeometry.getType(), null);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private void warnGeomShapeNotDisplayed(String string) {
        PropertyPanel propertyPanel = new PropertyPanel();
        String string2 = SpatialArb.getString("GenerateImageError");
        JLabel jLabel = new JLabel(string, 0);
        propertyPanel.addSingleComp((JComponent)jLabel);
        propertyPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string2, (int)1);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpatialShowGeometry.this.dlg.dispose();
            }
        });
        Dimension dimension = propertyPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this.dlg.setSize(n2, n);
        this.dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    private void showGeomShape() {
        PropertyPanel propertyPanel = new PropertyPanel();
        String string = SpatialArb.getString("GenerateImage");
        if (this.img == null) {
            this.warnGeomShapeNotDisplayed(SpatialArb.getString("Only2DShapes"));
            return;
        }
        JLabel jLabel = new JLabel(this.img, 0);
        propertyPanel.addSingleComp((JComponent)jLabel);
        propertyPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string, (int)1);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpatialShowGeometry.this.dlg.dispose();
            }
        });
        Dimension dimension = propertyPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this.dlg.setSize(n2, n);
        this.dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        this.geom = null;
        if (ideAction.getCommandId() == SPATIAL_SHOW_GEOMETRY_ID) {
            RaptorTask<Object> raptorTask = new RaptorTask<Object>("", false, IRaptorTaskRunMode.IDE_STATUSBAR){

                protected Object doWork() throws TaskException {
                    try {
                        int n;
                        SpatialShowGeometry.this.geom = JGeometry.loadJS((Struct)((Struct)SpatialShowGeometry.this.selectedGeometries.get(0)));
                        if (SpatialShowGeometry.this.geom.getDimensions() == 2 && ((n = SpatialShowGeometry.this.geom.getType()) == 3 || n == 7)) {
                            SpatialShowGeometry.this.img = SpatialShowGeometry.this.generateGeometryIcon(SpatialShowGeometry.this.geom);
                        }
                    }
                    catch (Throwable throwable) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                    }
                    return null;
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                }

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (SpatialShowGeometry.this.geom.getDimensions() == 2) {
                                    int n = SpatialShowGeometry.this.geom.getType();
                                    if (n == 3 || n == 7) {
                                        SpatialShowGeometry.this.showGeomShape();
                                    } else {
                                        SpatialShowGeometry.this.warnGeomShapeNotDisplayed(SpatialArb.getString("Only2DShapes"));
                                    }
                                } else {
                                    SpatialShowGeometry.this.warnGeomShapeNotDisplayed(SpatialArb.getString("Only2DShapes"));
                                }
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                        }
                    });
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
            return true;
        }
        if (ideAction.getCommandId() == IDENTIFY_GEOMETRY_ID_IN_MAP) {
            try {
                Struct[] structArray = new Struct[this.selectedGeometries.size()];
                structArray = this.selectedGeometries.toArray(structArray);
                this.highLightExternalGeometryInMap(structArray);
            }
            catch (Throwable throwable) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    private void highLightExternalGeometryInMap(Struct[] structArray) {
        try {
            SpatialUtil.getSelectedMapViewer().getMapViewerContoller().highLiteGeometries(structArray, true);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    static {
        SPATIAL_SHOW_GEOMETRY_ID = Ide.findOrCreateCmdID((String)SPATIAL_SHOW_GEOMETRY_TITLE);
        SPATIAL_SHOW_GEOMETRY = null;
        IDENTIFY_GEOMETRY_ID_IN_MAP = Ide.findOrCreateCmdID((String)IDENTIFY_GEOMETRY_TITLE_IN_MAP);
        IDENTIFY_GEOMETRY_IN_MAP = null;
    }
}

