/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.config;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.raptor.config.ConfigTraversable;
import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.raptor.ssh.config.SshConfiguration;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class SshConfigurationPanel
extends ConfigTraversable {
    private JCheckBox mChkHosts = new JCheckBox();
    private URLFileChooser.URLFileChooserPanel mPnlHosts = SshConfigurationPanel.createChooserPanel();

    private static URLFileChooser.URLFileChooserPanel createChooserPanel() {
        URLFileChooser.URLFileChooserPanel uRLFileChooserPanel = URLFileChooser.createURLFileChooserPanel((int)0, null, (String)SshSupportResources.getString("CONFIG_TITLE_KNOWN_HOSTS"), (boolean)false, (boolean)true);
        uRLFileChooserPanel.setPathContext(SshConfigurationPanel.class.getName() + ".mPnlHosts");
        uRLFileChooserPanel.clearChooseableURLFilters();
        return uRLFileChooserPanel;
    }

    protected JPanel createContentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.mChkHosts.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SshConfigurationPanel.this.toggleKnownHostsState(itemEvent.getStateChange() == 1);
            }
        });
        ResourceUtils.resButton((AbstractButton)this.mChkHosts, (String)SshSupportResources.getString("CONFIG_OPTION_KNOWN_HOSTS"));
        jPanel2.add((Component)this.mChkHosts, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mPnlHosts, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.PAGE_START));
        return jPanel;
    }

    public void onEntry(TraversableContext traversableContext) {
        SshConfiguration sshConfiguration = SshConfiguration.createSettings(traversableContext);
        URL uRL = sshConfiguration.getKnownHostsFile();
        if (uRL != null) {
            this.mChkHosts.setSelected(true);
            this.mPnlHosts.setSelectedURL(uRL);
        } else {
            this.mChkHosts.setSelected(false);
            this.toggleKnownHostsState(false);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        SshConfiguration sshConfiguration = SshConfiguration.createSettings(traversableContext);
        boolean bl = this.mChkHosts.isSelected();
        if (bl) {
            URL uRL = this.mPnlHosts.getSelectedURL();
            if (uRL == null) {
                throw new TraversalException(SshSupportResources.getString("CONFIG_ERROR_MISSING_FILE"));
            }
            sshConfiguration.setKnownHostsFile(uRL);
        } else {
            sshConfiguration.setKnownHostsFile(null);
        }
    }

    private void toggleKnownHostsState(boolean bl) {
        this.mPnlHosts.setEnabled(bl);
    }

    public String getHelpID() {
        return "f1_idedidesetssh_html";
    }
}

