/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.io.IOException;
import java.util.StringTokenizer;
import oracle.dss.util.BASE64Decoder;
import oracle.dss.util.BASE64Encoder;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import org.w3c.dom.Node;

public class MIMENode
extends ObjectNode {
    private static final long serialVersionUID = 1L;
    private String m_primaryType;
    private String m_subtype;
    private boolean m_compress;
    private byte[] m_bytes;
    private String m_txt;
    private static final String ENCODE_SCHEME = "Base64";

    MIMENode(ObjectScope scope, Node node) {
        super(scope, node);
        try {
            this.m_compress = this.getPropertyValueAsBoolean("Compressed");
            String _type = this.getPropertyValueAsString("Content-Type");
            StringTokenizer _tokenizer = new StringTokenizer(_type, "/");
            if (_tokenizer.hasMoreTokens()) {
                this.m_primaryType = _tokenizer.nextToken();
            }
            if (_tokenizer.hasMoreTokens()) {
                this.m_subtype = _tokenizer.nextToken();
            }
            String _encodedStr = this.getPropertyValueAsString("Content");
            if (this.m_primaryType.equals("text")) {
                this.m_txt = _encodedStr;
            } else {
                BASE64Decoder _decoder = new BASE64Decoder();
                this.m_bytes = _decoder.decode(_encodedStr);
            }
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MIMENode(ObjectNode node) {
        this(node.getScope(), node.getDOMElement());
    }

    public MIMENode(String name, String content, String primaryType, String subtype, boolean compress) {
        super(name);
        this.init(content, primaryType, subtype, compress);
    }

    public MIMENode(String name, byte[] binary, String primaryType, String subtype, boolean compress) {
        super(name);
        this.m_bytes = binary;
        String _content = null;
        BASE64Encoder _encoder = new BASE64Encoder();
        try {
            _content = _encoder.encode(binary);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.init(_content, primaryType, subtype, compress);
    }

    private void init(String content, String primaryType, String subtype, boolean compress) {
        this.m_primaryType = primaryType;
        this.m_subtype = subtype;
        this.m_compress = compress;
        this.addProperty("Content-Type", primaryType + "/" + subtype);
        this.addProperty("Content-Transfer-Encoding", ENCODE_SCHEME);
        this.addProperty("Compressed", compress);
        this.addProperty("Content", content, false);
    }

    public void useCompression(boolean compress) {
        this.m_compress = compress;
    }

    public void setPrimaryType(String primaryType) {
        this.m_primaryType = primaryType;
    }

    public String getPrimaryType() {
        return this.m_primaryType;
    }

    public void setSubtype(String subtype) {
        this.m_subtype = subtype;
    }

    public String getSubtype() {
        return this.m_subtype;
    }

    public byte[] getBinary() {
        return this.m_bytes;
    }

    public String getText() {
        return this.m_txt;
    }
}

