/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.HashMap;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.QDRLite;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.TreeCollection;
import oracle.dss.util.transform.TreeMapper;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.TreeProjection;

@Deprecated
public class TreeRecord
extends HashMap {
    private static final long serialVersionUID = 1L;
    protected TreeNode m_node = null;
    protected TreeProjection m_proj = null;
    protected Object m_nullValue = null;
    protected QDRLite m_qdr = null;
    protected TreeMapper m_mapper = null;

    public TreeRecord(TreeNode node, TreeProjection proj, Object nullValue, TreeMapper mapper) {
        this.m_node = node;
        this.m_proj = proj;
        this.m_nullValue = nullValue;
        this.m_mapper = mapper;
    }

    @Override
    public Object get(Object key) {
        String attr = (String)key;
        try {
            if (this.m_mapper != null) {
                Class mapClass = this.m_mapper.getMapClass(attr);
                String mapType = this.m_mapper.getMapType(attr);
                if (mapClass != null && mapClass.equals(LayerMetadataMap.class) && mapType != null) {
                    return this.getLayer().getMetadata(TransformUtils.convertLayerMetadataMap(mapType));
                }
                if (mapClass != null && mapClass.equals(MetadataMap.class) && mapType != null) {
                    String mm = TransformUtils.convertMetadataMap(mapType);
                    return this.getMember().getMetadata(mm);
                }
            }
            if (attr.startsWith("layerInterface")) {
                return this.getLayer();
            }
            if (attr.startsWith("memberInterface")) {
                return this.getMember();
            }
            if (attr.toUpperCase().equals("ID")) {
                String id = this.getMember().getValue();
                if (id == null) {
                    return this.m_nullValue;
                }
                return id;
            }
            if (attr.toUpperCase().equals("LABEL")) {
                return this.getMember().getMetadata("label");
            }
            if (attr.equals("dataValue")) {
                DataCellInterface dci = this.getDataValue(this.getQDR());
                if (dci != null) {
                    return dci.getData("dataValue");
                }
                return null;
            }
            TreeCollection coll = this.getCollection();
            return coll;
        }
        catch (TransformException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private QDRLite getQDR() throws TransformException {
        if (this.m_qdr == null) {
            this.m_qdr = TransformUtils.getQDRFromTreeNode(this.m_node);
        }
        return this.m_qdr;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof TreeRecord) {
            TreeRecord rec = (TreeRecord)o;
            return this.m_node.equals(rec.m_node);
        }
        return false;
    }

    @Override
    public int hashCode() {
        TreeCollection tc = this.getCollection();
        return this.m_node.hashCode() + (tc != null ? tc.hashCode() : 0);
    }

    public TreeNode getTreeNode() {
        return this.m_node;
    }

    public TreeCollection getCollection() {
        TreeNode node = this.m_node.getFirstChild();
        if (node != null) {
            return new TreeCollection(node, this.m_proj, this.m_nullValue, this.m_mapper);
        }
        return null;
    }

    public LayerInterface getLayer() throws TransformException {
        if (this.m_mapper != null) {
            return this.m_mapper.getLayer(this.m_node);
        }
        return this.m_node.getLayer();
    }

    public MemberInterface getMember() throws TransformException {
        if (this.m_mapper != null) {
            return this.m_mapper.getMember(this.m_node);
        }
        return this.m_node.getMember();
    }

    public DataCellInterface getDataValue(QDRLite qdr) {
        return this.m_proj.getData(qdr);
    }
}

