/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules.discriminator;

import java.util.Date;
import java.util.List;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.discriminator.DiscriminatorState;
import oracle.dss.rules.discriminator.ValueDiscriminator;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class DateValueDiscriminator
extends ValueDiscriminator
implements DiscriminatorState {
    private static final long serialVersionUID = 1L;
    private java.sql.Date m_date = new java.sql.Date(0L);
    protected static final String S_NAME_DATE_VAL_DISC = "DD";
    protected static final String s_date = "d";
    protected static final String a_date = "date";
    public static final String NAME_DATE_VAL_DISC = "DateValDisc";
    private static final boolean PERSIST_DATE_IN_LONG = true;

    public DateValueDiscriminator() {
    }

    public DateValueDiscriminator(java.sql.Date date, int relationalOperator) {
        super(relationalOperator);
        this.m_date = date;
    }

    @Override
    public Object clone() {
        return new DateValueDiscriminator(this.m_date, this.m_relOperator);
    }

    public void setDate(java.sql.Date date) {
        if (date == null) {
            return;
        }
        this.m_date = date;
    }

    public java.sql.Date getDate() {
        return this.m_date;
    }

    @Override
    public boolean applies(RuleContext context) {
        java.sql.Date contextDate = null;
        Object obj = context.get("DATE_VALUE");
        if (obj instanceof java.sql.Date) {
            contextDate = (java.sql.Date)obj;
        } else if (obj instanceof Date) {
            Date javaDate = (Date)obj;
            contextDate = new java.sql.Date(javaDate.getTime());
        } else {
            contextDate = obj instanceof String ? java.sql.Date.valueOf((String)obj) : new java.sql.Date(0L);
        }
        if (contextDate == null) {
            return false;
        }
        int compare = contextDate.compareTo(this.m_date);
        switch (this.m_relOperator) {
            default: {
                return compare == 0;
            }
            case 1: {
                return compare < 0;
            }
            case 2: {
                return compare <= 0;
            }
            case 3: {
                return compare > 0;
            }
            case 4: {
                return compare >= 0;
            }
            case 5: 
        }
        return compare != 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateValueDiscriminator)) {
            return false;
        }
        DateValueDiscriminator nvd = (DateValueDiscriminator)o;
        return this.getDate() != null && this.getDate().equals(nvd.getDate()) && this.getRelOperator() == nvd.getRelOperator();
    }

    @Override
    public boolean setXML(ObjectNode node, ComponentTypeConverter converter, String version, int reset) {
        PropertyNode pNode = node.getProperty("relOp");
        if (pNode != null) {
            String tmp = pNode.getValueAsString();
            this.setRelOperator(this.convertRelOperatorToInt(tmp));
        }
        if ((pNode = node.getProperty(a_date)) != null) {
            this.setDate(new java.sql.Date(pNode.getValueAsLong()));
        }
        return true;
    }

    @Override
    public ObjectNode getXML(boolean allProperties, ComponentTypeConverter converter, boolean emptyElement) {
        ObjectNode node = new ObjectNode(NAME_DATE_VAL_DISC);
        node.addProperty("relOp", this.convertRelOperatorToString(this.getRelOperator()));
        if (this.getDate() != null) {
            node.addProperty(a_date, this.getDate().getTime());
        }
        return node;
    }

    @Override
    public void setStateAsObjectNode(List context, ObjectNode node, DiscriminatorState baseState) {
        DateValueDiscriminator baseDisc;
        PropertyNode pNode = node.getProperty("r");
        DateValueDiscriminator dateValueDiscriminator = baseDisc = baseState instanceof DateValueDiscriminator ? (DateValueDiscriminator)baseState : null;
        if (pNode != null) {
            this.setRelOperator(pNode.getValueAsInteger());
        } else if (baseDisc != null) {
            this.setRelOperator(baseDisc.getRelOperator());
        } else {
            this.setRelOperator(0);
        }
        pNode = node.getProperty(s_date);
        if (pNode != null) {
            this.setDate(new java.sql.Date(pNode.getValueAsLong()));
        } else if (baseDisc != null) {
            this.setDate(baseDisc.getDate());
        } else {
            this.setDate(new java.sql.Date(0L));
        }
    }

    @Override
    public ObjectNode getStateAsObjectNode(List memberContext, DiscriminatorState baseState) {
        DateValueDiscriminator baseDisc;
        ObjectNode node = new ObjectNode(S_NAME_DATE_VAL_DISC);
        boolean nodeExists = false;
        DateValueDiscriminator dateValueDiscriminator = baseDisc = baseState instanceof DateValueDiscriminator ? (DateValueDiscriminator)baseState : new DateValueDiscriminator();
        if (baseDisc.getRelOperator() != this.getRelOperator()) {
            node.addProperty("r", this.getRelOperator());
            nodeExists = true;
        }
        if (baseDisc.getDate() != this.getDate()) {
            node.addProperty(s_date, this.getDate().getTime());
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }
}

