/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform.total;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adf.model.dvt.util.transform.total.AggType;
import oracle.adfinternal.model.dvt.util.transform.Filter;
import oracle.adfinternal.model.dvt.util.transform.ProjectionInfo;
import oracle.adfinternal.model.dvt.util.transform.total.AggColumn;
import oracle.adfinternal.model.dvt.util.transform.total.AggMethod;
import oracle.adfinternal.model.dvt.util.transform.total.AggOptions;
import oracle.adfinternal.model.dvt.util.transform.total.AggPosition;
import oracle.adfinternal.model.dvt.util.transform.total.AggWhat;

public class AggSpec {
    protected AggWhat[] m_columns = null;
    protected AggOptions m_options = new AggOptions();
    protected AggMethod[] m_aggMethods = null;
    protected MemberInterface m_totalMember = null;
    protected String[] m_allLayers = null;
    private List<String> m_groupingCols = null;

    public AggSpec(String columnToAggregate, MemberInterface totalMember, Filter[] filters, AggOptions options, AggMethod[] aggRules) {
        this(new AggWhat[]{new AggColumn(columnToAggregate, totalMember, filters)}, options, aggRules);
    }

    public AggSpec(String columnToAggregate, MemberInterface totalMember, AggOptions options, AggMethod[] aggRules) {
        this(new AggWhat[]{new AggColumn(columnToAggregate, totalMember)}, options, aggRules);
    }

    public AggSpec(int edge, int layer, MemberInterface totalMember, AggOptions options, AggMethod[] aggRules) {
        this(new AggWhat[]{new AggPosition(edge, layer, totalMember)}, options, aggRules);
    }

    public AggSpec(AggWhat[] columns, AggOptions options, AggMethod[] aggRules) {
        AggWhat[] newCols = new AggWhat[columns.length];
        for (int i = 0; i < newCols.length; ++i) {
            newCols[i] = columns[i] instanceof AggColumn ? new AggColumn(((AggColumn)columns[i]).getColumn(), columns[i].getMemberInterface(), ((AggColumn)columns[i]).getShowAggComponentFilters()) : new AggPosition(((AggPosition)columns[i]).getEdge(), ((AggPosition)columns[i]).getLayer(), columns[i].getMemberInterface());
        }
        this.m_columns = newCols;
        this.m_options = options;
        this.m_aggMethods = aggRules;
    }

    public void release() {
        this.m_columns = null;
        this.m_options = null;
        this.m_aggMethods = null;
        this.m_totalMember = null;
        this.m_groupingCols = null;
    }

    public AggOptions getOptions() {
        return this.m_options;
    }

    public AggWhat[] getColumnsToAggregate() {
        return this.m_columns;
    }

    public AggMethod[] getAggMethods() {
        return this.m_aggMethods;
    }

    public String[] getAllDataLayers() {
        if (this.m_allLayers == null) {
            ArrayList<String> allLayers = new ArrayList<String>();
            if (this.m_aggMethods != null) {
                for (int i = 0; i < this.m_aggMethods.length; ++i) {
                    Map<String, AggType> map = this.m_aggMethods[i].getAggTypeMap();
                    if (map == null) continue;
                    Set<String> keySet = map.keySet();
                    Iterator<String> keyIter = keySet.iterator();
                    String key = null;
                    while (keyIter.hasNext()) {
                        key = keyIter.next();
                        if (allLayers.indexOf(key) != -1) continue;
                        allLayers.add(key);
                    }
                }
            }
            this.m_allLayers = allLayers.toArray(new String[0]);
        }
        return this.m_allLayers;
    }

    public boolean hasAggTypeForColumn(String column, AggType type) {
        if (this.m_aggMethods != null) {
            for (int i = 0; i < this.m_aggMethods.length; ++i) {
                if (!this.m_aggMethods[i].getAggType(column).equals((Object)type)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<String> getGroupingColumns(ProjectionInfo projInfo) throws TransformException {
        if (this.m_groupingCols == null) {
            this.m_groupingCols = new ArrayList<String>();
            String[][] layout = projInfo.getLayout();
            for (int e = 0; e < layout.length; ++e) {
                if (layout[e] == null) continue;
                for (int l = 0; l < layout[e].length; ++l) {
                    if (this.isGroupingColumn(layout[e][l]) || this.isDataItem(layout[e][l], projInfo)) continue;
                    this.m_groupingCols.add(layout[e][l]);
                }
            }
        }
        return this.m_groupingCols;
    }

    private boolean isGroupingColumn(String col) {
        AggWhat[] cols = this.getColumnsToAggregate();
        for (int c = 0; c < cols.length; ++c) {
            if (!(cols[c] instanceof AggColumn) || !((AggColumn)cols[c]).getColumn().equals(col)) continue;
            return true;
        }
        return false;
    }

    private boolean isDataItem(String col, ProjectionInfo projInfo) throws TransformException {
        MemberInterface[] dataItems = projInfo.getDataItems();
        for (int i = 0; i < (dataItems == null ? 0 : dataItems.length); ++i) {
            if (!col.equals(dataItems[i].getValue())) continue;
            return true;
        }
        return false;
    }
}

