/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.Collection;
import java.util.Iterator;
import oracle.adf.model.dvt.util.transform.TreeNode;
import oracle.adf.model.dvt.util.transform.TreeProjection;
import oracle.adfinternal.model.dvt.util.transform.TreeMapper;
import oracle.adfinternal.model.dvt.util.transform.TreeRecord;

public class TreeCollection
implements Collection<TreeRecord> {
    private final TreeNode m_node;
    private final TreeProjection m_proj;
    private final Object m_nullValue;
    protected int m_size = -1;
    protected TreeMapper m_mapper = null;

    public TreeCollection(TreeNode node, TreeProjection proj) {
        this(node, proj, null);
    }

    public TreeCollection(TreeNode node, TreeProjection proj, Object nullValue, TreeMapper mapper) {
        this(node, proj, nullValue);
        this.setTreeMapper(mapper);
    }

    public TreeCollection(TreeNode node, TreeProjection proj, Object nullValue) {
        this.m_node = node;
        this.m_proj = proj;
        this.m_nullValue = nullValue;
    }

    public void setTreeMapper(TreeMapper mapper) {
        this.m_mapper = mapper;
    }

    public TreeNode getTreeNode() {
        return this.m_node;
    }

    private int _size(TreeNode node) {
        if (node == null) {
            return 0;
        }
        int size = 0;
        while (node != null) {
            ++size;
            size += this._size(node.getFirstChild());
            node = node.getNextSibling();
        }
        return size;
    }

    @Override
    public int size() {
        if (this.m_size == -1) {
            TreeNode node = this.m_node;
            this.m_size = this._size(node.getFirstChild());
        }
        return this.m_size;
    }

    @Override
    public boolean contains(Object o) {
        for (TreeRecord record : this) {
            if (!record.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        for (TreeRecord record : c) {
            if (this.contains(record)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TreeCollection)) {
            return false;
        }
        TreeCollection coll = (TreeCollection)o;
        if (this.size() == coll.size()) {
            return this.containsAll(coll);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (TreeRecord record : this) {
            hash += record.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean add(TreeRecord o) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends TreeRecord> c) {
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] recs = new TreeRecord[this.size()];
        int count = 0;
        for (TreeRecord record : this) {
            recs[count++] = record;
        }
        return recs;
    }

    public TreeRecord[] toArray(Object[] obj) {
        return (TreeRecord[])this.toArray();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public Iterator<TreeRecord> iterator() {
        return new TreeIterator(this);
    }

    public class TreeIterator
    implements Iterator<TreeRecord> {
        protected TreeCollection m_coll = null;
        protected TreeNode m_currNode = null;

        public TreeIterator(TreeCollection c) {
            this.m_coll = c;
            this.m_currNode = c.getTreeNode();
        }

        @Override
        public boolean hasNext() {
            return this.m_currNode != null;
        }

        @Override
        public void remove() {
        }

        @Override
        public TreeRecord next() {
            if (this.m_currNode == null) {
                return null;
            }
            TreeRecord rec = new TreeRecord(this.m_currNode, TreeCollection.this.m_proj, TreeCollection.this.m_nullValue, TreeCollection.this.m_mapper);
            this.m_currNode = this.m_currNode.getNextSibling();
            return rec;
        }
    }
}

