/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.dvt.util.transform.BaseProjection;
import oracle.adf.model.dvt.util.transform.DataCellInterface;
import oracle.adf.model.dvt.util.transform.EdgeTree;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adf.model.dvt.util.transform.TreeNode;
import oracle.adf.model.dvt.util.transform.total.AggType;
import oracle.adfinternal.model.dvt.util.transform.BaseNode;
import oracle.adfinternal.model.dvt.util.transform.CubeImpl;
import oracle.adfinternal.model.dvt.util.transform.DeleteChanges;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeBasedCubicDataAccess;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeNodeImpl;
import oracle.adfinternal.model.dvt.util.transform.GetSlice;
import oracle.adfinternal.model.dvt.util.transform.InsertInfo;
import oracle.adfinternal.model.dvt.util.transform.LayerAndMember;
import oracle.adfinternal.model.dvt.util.transform.QDRLite;
import oracle.adfinternal.model.dvt.util.transform.ResultTable;
import oracle.adfinternal.model.dvt.util.transform.Row;
import oracle.adfinternal.model.dvt.util.transform.RowInfo;
import oracle.adfinternal.model.dvt.util.transform.SliceInsertInfo;
import oracle.adfinternal.model.dvt.util.transform.TransformUtils;
import oracle.adfinternal.model.dvt.util.transform.total.TotalMember;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.LayerSortInfo;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.QDRMember;
import oracle.dss.util.SliceOutOfRangeException;

abstract class EdgeTreeImpl
implements Cloneable,
EdgeTree {
    private BaseNode[] m_layers = null;
    private EdgeTreeNodeImpl m_root = null;
    private boolean m_locked = false;
    private int m_edge = -1;
    private boolean m_noCollapseLeaves = false;
    private String[][] m_layout = null;
    private boolean m_isOutline = false;
    private EdgeTreeBasedCubicDataAccess m_da = null;
    private BaseProjection m_projection = null;
    private String m_measDim = null;
    private String[] m_measList = null;
    private List<MemberInterface> m_nullList = new ArrayList<MemberInterface>();
    private List<String> m_sliceValues = new ArrayList<String>();
    private List<MemberInterface> m_sliceMemberVals = new ArrayList<MemberInterface>();
    private List<String> m_sliceMemberLayers = new ArrayList<String>();

    public EdgeTreeImpl(BaseNode[] nodes, int edge, BaseProjection projection, String measDim, String[] measList, boolean noCollapseLeaves, EdgeTreeBasedCubicDataAccess da, long extent) {
        this.m_projection = projection;
        this.m_da = da;
        this.m_layers = nodes;
        this.m_edge = edge;
        this.m_layout = projection.getLayout();
        this.m_noCollapseLeaves = noCollapseLeaves;
        this.m_root = this.getRootEdgeTreeNode(extent);
        this.m_measDim = measDim;
        this.m_measList = measList;
    }

    public EdgeTreeBasedCubicDataAccess getDataAccess() {
        return this.m_da;
    }

    protected EdgeTreeNodeImpl getRootEdgeTreeNode(long extent) {
        return new EdgeTreeNodeImpl(this);
    }

    public Object clone(boolean caching) throws CloneNotSupportedException {
        EdgeTreeImpl et = (EdgeTreeImpl)super.clone();
        if (this.m_layers != null) {
            et.m_layers = new BaseNode[this.m_layers.length];
            for (int i = 0; i < this.m_layers.length; ++i) {
                if (this.m_layers[i] == null) continue;
                et.m_layers[i] = (BaseNode)this.m_layers[i].clone();
            }
        }
        et.m_root = (EdgeTreeNodeImpl)this.m_root.clone(et, null, caching);
        if (this.m_layout != null) {
            et.m_layout = (String[][])this.m_layout.clone();
        }
        et.m_da = this.m_da;
        et.m_measDim = this.m_measDim;
        et.m_measList = this.m_measList;
        return et;
    }

    protected void setProjection(BaseProjection proj) {
        this.m_projection = proj;
    }

    protected void setMeasList(String[] measList) {
        this.m_measList = measList;
    }

    protected void clearNodes() throws TransformException {
        if (this.m_root != null) {
            this.m_root.release();
        }
        this.m_root = this.getRootEdgeTreeNode(0L);
        this.unlock();
    }

    public void release() {
        this.m_layers = null;
        if (this.m_root != null) {
            this.m_root.release();
        }
        this.m_root = null;
        this.m_layout = null;
    }

    protected boolean isNoCollapseLeaves() {
        return this.m_noCollapseLeaves;
    }

    protected void setOutline(boolean outline) {
        this.m_isOutline = outline;
    }

    protected boolean isOutline() {
        return this.m_isOutline;
    }

    private MemberInterface _getMember(String layer, String[] layers, Map<String, MemberInterface> sliceToInsert) {
        for (int i = 0; i < layers.length; ++i) {
            if (!layer.equals(layers[i])) continue;
            return sliceToInsert.get(layers[i]);
        }
        return null;
    }

    private Map<String, MemberInterface> _getQDRToInsert(Map<String, MemberInterface> sliceToInsert, String[] layers) throws TransformException {
        HashMap<String, MemberInterface> qdrToInsert = new HashMap<String, MemberInterface>();
        for (int i = 0; i < layers.length; ++i) {
            qdrToInsert.put(layers[i], sliceToInsert.get(layers[i]));
        }
        return qdrToInsert;
    }

    private boolean _hasMeasure(Set<QDRInterface> qdrs, String dataLayer, String meas) {
        QDRMember currMeas = null;
        for (QDRInterface qdr : qdrs) {
            currMeas = qdr.getDimMember(dataLayer);
            if (currMeas == null || !meas.equals(currMeas.getData())) continue;
            return true;
        }
        return false;
    }

    private MemberInterface _getDataMemberInterface(MemberInterface[] dataMemberInterfaces, String value) throws TransformException {
        if (dataMemberInterfaces != null) {
            for (int i = 0; i < dataMemberInterfaces.length; ++i) {
                if (!value.equals(dataMemberInterfaces[i].getValue())) continue;
                return dataMemberInterfaces[i];
            }
        }
        return null;
    }

    public CubeImpl.QDRAndPosition insert(SliceInsertInfo sliceInsertInfo, String dataLayer, MemberInterface[] dataMemberInterfaces, MetadataMap map) throws TransformException {
        Map<String, MemberInterface> sliceToInsert = sliceInsertInfo.getSliceToInsert();
        String[] layers = TransformUtils.getLayersFromSliceToInsert(sliceToInsert);
        boolean bhaveMeas = false;
        for (int i = 0; i < layers.length; ++i) {
            if (bhaveMeas || !layers[i].equals(dataLayer)) continue;
            bhaveMeas = true;
        }
        ArrayList<Map<String, MemberInterface>> sliceInsertArray = null;
        if (!bhaveMeas) {
            Map<QDRInterface, DataCellInterface> dataMap = sliceInsertInfo.getData();
            if (dataMap != null) {
                Set<QDRInterface> keySet = dataMap.keySet();
                if (dataMemberInterfaces == null) {
                    sliceInsertArray = new ArrayList();
                    QDRInterface[] qdrs = keySet.toArray(new QDRInterface[0]);
                    for (int i = 0; i < keySet.size(); ++i) {
                        sliceInsertArray.add(new HashMap<String, MemberInterface>(sliceToInsert));
                        QDRMember qdrMem = qdrs[i].getDimMember(dataLayer);
                        String val = (String)(qdrMem != null ? qdrMem.getData() : null);
                        MemberInterface dmi = this._getDataMemberInterface(dataMemberInterfaces, val);
                        if (dmi == null) continue;
                        ((Map)sliceInsertArray.get(i)).put(dataLayer, dmi);
                    }
                } else {
                    ArrayList<HashMap<String, MemberInterface>> sliceInsertList = new ArrayList<HashMap<String, MemberInterface>>();
                    boolean before = sliceInsertInfo.isBefore();
                    for (int i = 0; i < dataMemberInterfaces.length; ++i) {
                        if (!this._hasMeasure(keySet, dataLayer, dataMemberInterfaces[i].getValue())) continue;
                        HashMap<String, MemberInterface> newQDR = new HashMap<String, MemberInterface>(sliceToInsert);
                        if (before) {
                            sliceInsertList.add(newQDR);
                        } else {
                            sliceInsertList.add(0, newQDR);
                        }
                        if (dataMemberInterfaces[i] == null) continue;
                        newQDR.put(dataLayer, dataMemberInterfaces[i]);
                    }
                    sliceInsertArray = new ArrayList();
                    sliceInsertArray.addAll(sliceInsertList);
                    if (sliceInsertArray.size() > 0) {
                        layers = TransformUtils.getLayersFromSliceToInsert((Map)sliceInsertArray.get(0));
                    }
                }
            }
        } else {
            sliceInsertArray = new ArrayList<Map<String, MemberInterface>>();
            sliceInsertArray.add(sliceToInsert);
        }
        CubeImpl.QDRAndPosition qdrsAdded = new CubeImpl.QDRAndPosition();
        boolean bAdded = false;
        int layerAdded = -1;
        EdgeTreeNodeImpl nodeAdded = null;
        for (int i = 0; i < sliceInsertArray.size(); ++i) {
            Map<String, MemberInterface> qdrToInsert = this._getQDRToInsert((Map)sliceInsertArray.get(i), layers);
            EdgeTreeNodeImpl currNode = this.m_root;
            MemberInterface member = null;
            EdgeTreeNodeImpl prevNode = currNode;
            for (int layer = 0; layer < this.m_layers.length; ++layer) {
                member = qdrToInsert.get(this.m_layers[layer].getName());
                if (member == null) {
                    if (layer <= 0) break;
                    nodeAdded = this._insert(prevNode, layer - 1, layers, sliceInsertInfo, (Map)sliceInsertArray.get(i), false);
                    layerAdded = layer - 1;
                    bAdded = true;
                    break;
                }
                Object data = member != null ? member.getMetadata("value") : null;
                prevNode = currNode;
                if ((currNode = currNode.findNonAggregateChild(data != null ? data.toString() : null)) != null) continue;
                nodeAdded = currNode = this._insert(prevNode, layer, layers, sliceInsertInfo, (Map)sliceInsertArray.get(i), false);
                layerAdded = layer;
                bAdded = true;
            }
            if (!bAdded) continue;
            qdrsAdded.add(this._convertToMapOfTypes(qdrToInsert, map), new DeleteChanges.Positions(this.m_edge, layerAdded, nodeAdded.getStart(GetSlice.GET_ALL_SLICES, -1L)));
        }
        return qdrsAdded;
    }

    private Map<String, Map<String, Object>> _convertToMapOfTypes(Map<String, MemberInterface> qdr, MetadataMap map) throws TransformException {
        HashMap<String, Map<String, Object>> retVal = new HashMap<String, Map<String, Object>>();
        Set<String> dims = qdr.keySet();
        for (String dim : dims) {
            MemberInterface mi = qdr.get(dim);
            retVal.put(dim, this._getMapFromMemberInterface(mi, map));
        }
        return retVal;
    }

    private Map<String, Object> _getMapFromMemberInterface(MemberInterface mi, MetadataMap map) throws TransformException {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        Enumeration types = map.types();
        String type = null;
        while (types.hasMoreElements()) {
            type = TransformUtils.convertMetadataMap((String)types.nextElement());
            retVal.put(type, mi.getMetadata(type));
        }
        return retVal;
    }

    private EdgeTreeNodeImpl _insert(EdgeTreeNodeImpl prevNode, int layer, String[] layers, SliceInsertInfo sliceInsertInfo, Map<String, MemberInterface> sliceToInsert, boolean alwaysAdd) throws TransformException {
        QDRMember insertMember;
        String layerName = this.m_layers[layer].getName();
        QDRMember qDRMember = insertMember = sliceInsertInfo.getInsertLocation() != null ? sliceInsertInfo.getInsertLocation().getDimMember(layerName) : null;
        String insertLocation = insertMember != null ? (insertMember.getData() != null ? insertMember.getData().toString() : null) : null;
        boolean before = sliceInsertInfo.isBefore();
        if (insertLocation == null) {
            if (!before) {
                EdgeTreeNodeImpl firstNode = prevNode.getFirstChild();
                insertLocation = firstNode != null ? firstNode.getMember().getValue() : null;
                before = true;
            } else {
                EdgeTreeNodeImpl lastNode = prevNode.getLastChild();
                insertLocation = lastNode != null ? lastNode.getMember().getValue() : null;
                before = false;
            }
        }
        EdgeTreeNodeImpl newNode = this.getEdgeTreeNode(false, prevNode, this._getMember(layerName, layers, sliceToInsert), null, layerName);
        prevNode.addChild(newNode, null, insertLocation, before, alwaysAdd, false, true, null);
        prevNode.clearSpan();
        newNode.clearStarts();
        prevNode.clearStarts();
        return newNode;
    }

    protected abstract EdgeTreeNodeImpl getEdgeTreeNode(boolean var1, EdgeTreeNodeImpl var2, MemberInterface var3, TreeNode var4, String var5) throws TransformException;

    public DeleteChanges delete(QDRLite qdr) throws TransformException {
        DeleteChanges delChanges = new DeleteChanges();
        EdgeTreeNodeImpl currNode = null;
        String member = null;
        for (int layer = 0; layer < this.m_layers.length && (member = (String)qdr.getDimMember(this.m_layers[layer].getName())) != null; ++layer) {
            if ((currNode = (currNode == null ? this.m_root : currNode).findNonAggregateChild(member)) != null) continue;
            return delChanges;
        }
        if (currNode != null) {
            List<EdgeTreeNodeImpl> leaves = currNode.getAllLeaves(null);
            currNode.delete();
            if (leaves != null) {
                for (EdgeTreeNodeImpl node : leaves) {
                    delChanges.addDeletion((Map<String, Object>)node.getQDR(), new DeleteChanges.Positions(this.m_edge, this.m_layers.length - 1, node.getStart(GetSlice.GET_ALL_SLICES, -1L)));
                }
            }
        }
        return delChanges;
    }

    public void invalidate(QDRLite qdr) throws TransformException {
        EdgeTreeNodeImpl currNode = this.m_root;
        String member = null;
        for (int layer = 0; layer < this.m_layers.length; ++layer) {
            member = (String)qdr.getDimMember(this.m_layers[layer].getName());
            if (member == null) {
                if (this.invalidate(currNode)) {
                    currNode.clearSpan();
                    currNode.clearStarts();
                }
                return;
            }
            if ((currNode = currNode.findNonAggregateChild(member)) != null) continue;
            return;
        }
    }

    private boolean invalidate(EdgeTreeNodeImpl node) throws TransformException {
        if (node.isRoot()) {
            return false;
        }
        node.invalidate();
        return true;
    }

    public boolean containsColumn(String col) {
        if (this.m_layers == null) {
            return false;
        }
        if (col == null) {
            return true;
        }
        return this.getLayer(col) != -1;
    }

    protected int getLayer(String layerName) {
        if (this.m_layers == null) {
            return -1;
        }
        for (int i = 0; i < this.m_layers.length; ++i) {
            if (!this.m_layers[i].getName().equals(layerName)) continue;
            return i;
        }
        return -1;
    }

    public void unlock() throws TransformException {
        this.m_locked = false;
        if (this.m_root != null) {
            this.m_root.unlock();
        }
    }

    public int getEdge() {
        return this.m_edge;
    }

    public int getLayerCount() {
        return this.m_layers == null ? 0 : this.m_layers.length;
    }

    protected String[][] getLayout() {
        return this.m_layout;
    }

    protected void checkLayerRange(int layer) throws LayerOutOfRangeException {
        if (layer < 0 || layer >= this.getLayerCount()) {
            throw new LayerOutOfRangeException(layer, this.getLayerCount());
        }
    }

    public boolean unlock(String insertCol) throws TransformException {
        if (insertCol == null) {
            this.unlock();
            return true;
        }
        if (this.containsColumn(insertCol)) {
            this.unlock();
            return true;
        }
        return false;
    }

    protected BaseNode[] getLayerList() {
        return this.m_layers;
    }

    public void lock() {
        this.m_locked = true;
    }

    public boolean isLocked() {
        return this.m_locked;
    }

    public boolean isAsymmetric() throws TransformException {
        return this.m_root.isAsymmetric();
    }

    public long getExtent() throws TransformException {
        return this.m_root.getSpan();
    }

    public EdgeTreeNodeImpl getRoot() {
        return this.m_root;
    }

    public EdgeTreeNodeImpl[] findNode(String[] values, boolean treatNullAsAll) throws TransformException {
        EdgeTreeNodeImpl currNode = this.m_root;
        ArrayList<EdgeTreeNodeImpl> retNodes = new ArrayList<EdgeTreeNodeImpl>();
        this._findNode(currNode, values, 0, treatNullAsAll, retNodes);
        return retNodes.toArray(new EdgeTreeNodeImpl[0]);
    }

    private EdgeTreeNodeImpl _findNode(EdgeTreeNodeImpl currNode, String[] values, int layer, boolean treatNullAsAll, List<EdgeTreeNodeImpl> retNodes) throws TransformException {
        if (values.length <= layer) {
            retNodes.add(currNode);
            return currNode;
        }
        EdgeTreeNodeImpl[] nodes = currNode.findAllChildren(values[layer], treatNullAsAll);
        if (nodes == null) {
            return null;
        }
        EdgeTreeNodeImpl currChild = null;
        for (int i = 0; i < nodes.length; ++i) {
            if (layer + 1 < values.length) {
                currChild = this._findNode(nodes[i], values, layer + 1, treatNullAsAll, retNodes);
                if (currChild != null) {
                    return currChild;
                }
                if (treatNullAsAll || i != nodes.length - 1 || nodes[i] == null) continue;
                retNodes.add(nodes[i]);
                continue;
            }
            retNodes.add(nodes[i]);
        }
        return null;
    }

    public String[] getHPosValues(long[] hPos) throws TransformException {
        if (hPos == null) {
            return new String[0];
        }
        String[] retVal = new String[hPos.length];
        EdgeTreeNodeImpl currNode = this.m_root;
        for (int i = 0; i < hPos.length && (currNode = currNode.getChild(hPos[i])) != null; ++i) {
            retVal[i] = currNode.getMember() != null ? currNode.getMember().getValue() : null;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSliceValues(long slice) throws TransformException {
        String[] retVal = null;
        List<String> list = this.m_sliceValues;
        synchronized (list) {
            this.m_sliceValues.clear();
            EdgeTreeNodeImpl currNode = this.m_root;
            while (currNode != null) {
                if ((currNode = currNode.findChild(slice, GetSlice.GET_ALL_SLICES)) == null) continue;
                this.m_sliceValues.add(currNode.getMember().getValue());
            }
            retVal = this.m_sliceValues.toArray(new String[0]);
        }
        return retVal;
    }

    public boolean hasSlice(EdgeTreeNodeImpl node, long slice) throws TransformException {
        if (node == null) {
            return this.m_root.findChild(slice, GetSlice.GET_NO_SLICES) != null;
        }
        return node.findChild(slice, GetSlice.GET_NO_SLICES) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayerAndMember getHPosMembers(long[] hPos) throws TransformException {
        if (hPos == null) {
            return null;
        }
        LayerAndMember retVal = null;
        List<MemberInterface> list = this.m_sliceMemberVals;
        synchronized (list) {
            this.m_sliceMemberVals.clear();
            this.m_sliceMemberLayers.clear();
            EdgeTreeNodeImpl currNode = this.m_root;
            for (int i = 0; i < hPos.length; ++i) {
                if (hPos[i] <= -1L) continue;
                if ((currNode = currNode.getChild(hPos[i])) == null) break;
                this.m_sliceMemberVals.add(currNode.getMember());
                this.m_sliceMemberLayers.add(currNode.getLayerName());
            }
            retVal = new LayerAndMember(this.m_sliceMemberLayers.toArray(new String[0]), this._getMemberArray(this.m_sliceMemberVals));
        }
        return retVal;
    }

    public MemberInterface[] getMembers(long slice) throws SliceOutOfRangeException, TransformException {
        int layerCount = this.getLayerCount();
        MemberInterface[] retVal = new MemberInterface[layerCount];
        EdgeTreeNodeImpl currNode = null;
        EdgeTreeNodeImpl prevNode = null;
        for (int l = 0; l < layerCount; ++l) {
            currNode = this.getNode(l, slice, GetSlice.GET_TO_SLICE);
            if (currNode == prevNode) {
                return retVal;
            }
            retVal[l] = currNode.getMember();
            prevNode = currNode;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayerAndMember getSliceMembers(long slice) throws SliceOutOfRangeException, TransformException {
        LayerAndMember retVal = null;
        List<MemberInterface> list = this.m_sliceMemberVals;
        synchronized (list) {
            this.m_sliceMemberVals.clear();
            this.m_sliceMemberLayers.clear();
            int layerCount = this.getLayerCount();
            EdgeTreeNodeImpl currNode = null;
            EdgeTreeNodeImpl prevNode = null;
            for (int l = 0; l < layerCount; ++l) {
                currNode = this.getNode(l, slice, GetSlice.GET_TO_SLICE);
                if (currNode != prevNode) {
                    this.m_sliceMemberLayers.add(currNode.getLayerName());
                    this.m_sliceMemberVals.add(currNode.getMember());
                }
                prevNode = currNode;
            }
            retVal = new LayerAndMember(this.m_sliceMemberLayers.toArray(new String[0]), this._getMemberArray(this.m_sliceMemberVals));
        }
        return retVal;
    }

    private MemberInterface[] _getMemberArray(List<MemberInterface> members) {
        int size = members.size();
        MemberInterface[] retVal = new MemberInterface[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = members.get(i);
        }
        return retVal;
    }

    public int getDepth(int layer, long slice) throws TransformException {
        EdgeTreeNodeImpl node = this.m_root;
        int depth = 0;
        for (int physLayer = 0; node != null && (layer == -1 || layer != -1 && physLayer < layer); ++physLayer) {
            if ((node = node.findChild(slice, GetSlice.GET_ALL_SLICES)) == null || node.getMember() == null) continue;
            ++depth;
        }
        return depth;
    }

    public long getSpan(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNodeImpl node = this.getNode(layer, slice, GetSlice.GET_TO_SLICE);
        if (node != null) {
            return node.getSpan();
        }
        return 0L;
    }

    public long getStart(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNodeImpl node = this.getNode(layer, slice, GetSlice.GET_ALL_SLICES);
        if (node != null) {
            return node.getStart(GetSlice.GET_ALL_SLICES, -1L);
        }
        return slice;
    }

    public EdgeTreeNodeImpl getNode(long[] hPos, int memberLayer, long hIndex) throws TransformException {
        EdgeTreeNodeImpl currNode = this.m_root;
        EdgeTreeNodeImpl temp = null;
        for (int i = 0; i <= memberLayer; ++i) {
            temp = currNode.getChild(i == memberLayer || hPos == null ? hIndex : hPos[i]);
            if (temp == null) {
                return currNode;
            }
            currNode = temp;
        }
        return currNode;
    }

    public EdgeTreeNodeImpl getNode(int layer, long slice, GetSlice get) throws TransformException, SliceOutOfRangeException {
        if (slice < 0L || slice >= this.getExtent()) {
            throw new SliceOutOfRangeException((int)slice, (int)this.getExtent());
        }
        EdgeTreeNodeImpl node = this.m_root;
        EdgeTreeNodeImpl lastNonNullNode = this.m_root;
        int l = 0;
        while (l <= layer && node != null) {
            lastNonNullNode = node;
            node = node.findChild(slice, get);
            if (l == layer) {
                ++l;
                continue;
            }
            l += this._getNodeSize(node);
        }
        if (node == null) {
            return lastNonNullNode.isRoot() ? null : lastNonNullNode;
        }
        while (node != null && node != this.m_root && node.getMember() == null) {
            node = node.getParentInternal();
        }
        return node;
    }

    public int getLowestLayer(long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNodeImpl node = this.getNode(this.getLayerCount() - 1, slice, GetSlice.GET_ALL_SLICES);
        return this.getLayer(node.getLayerName());
    }

    public EdgeTreeNodeImpl getFirstLeafNode() throws TransformException {
        EdgeTreeNodeImpl node = this.m_root;
        while (!node.isLeaf()) {
            node = node.getFirstChild();
        }
        return node;
    }

    public EdgeTreeNodeImpl getLastLeafNode() throws TransformException {
        EdgeTreeNodeImpl node = this.m_root;
        while (!node.isLeaf()) {
            node = node.getLastChild();
        }
        return node;
    }

    public EdgeTreeNodeImpl getPreviousLeafNode(long[] hPos) throws TransformException {
        EdgeTreeNodeImpl thisNode = this.getNode(hPos, hPos.length - 1, hPos[hPos.length - 1]);
        do {
            if (thisNode.getPosition() <= 0L || thisNode.getParent() == null) continue;
            return thisNode.getParentInternal().getChild(thisNode.getPosition() - 1L).getLastLeaf();
        } while ((thisNode = (EdgeTreeNodeImpl)thisNode.getParent()) != null);
        return null;
    }

    public EdgeTreeNodeImpl getNextLeafNode(long[] hPos) throws TransformException {
        EdgeTreeNodeImpl thisNode = this.getNode(hPos, hPos.length - 1, hPos[hPos.length - 1]);
        do {
            if (thisNode.getParent() == null || thisNode.getPosition() >= thisNode.getParentInternal().getChildCount() - 1L) continue;
            EdgeTreeNodeImpl child = thisNode.getParentInternal().getChild(thisNode.getPosition() + 1L);
            return child != null ? child.getFirstLeaf() : null;
        } while ((thisNode = thisNode.getParentInternal()) != null);
        return null;
    }

    public int getStartLayer(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNodeImpl node = this.getNode(layer, slice, GetSlice.GET_TO_SLICE);
        return this.getLayer(node.getLayerName());
    }

    public int getNodeSize(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNodeImpl thisNode = this.getNode(layer, slice, GetSlice.GET_ALL_SLICES);
        return this._getNodeSize(thisNode);
    }

    private int _getNodeSize(EdgeTreeNodeImpl thisNode) throws TransformException {
        int layerNum = this.getLayer(thisNode.getLayerName());
        EdgeTreeNodeImpl firstChild = thisNode.getFirstChild();
        if (firstChild == null) {
            return this.getLayerCount() - layerNum;
        }
        int nextLayer = this.getLayer(firstChild.getLayerName());
        return nextLayer - layerNum;
    }

    protected RowInfo[] addRow(Row rowData, String[] actualTableNodes, InsertInfo insertInfo, boolean alwaysAdd, boolean keepNulls, boolean placeTotals, LayerSortInfo[] sortInfo, ResultTable rt) throws TransformException {
        EdgeTreeNodeImpl currNode = this.m_root;
        EdgeTreeNodeImpl temp = null;
        String layerName = null;
        if (this.m_layers == null) {
            return new RowInfo[0];
        }
        boolean inserting = false;
        if (actualTableNodes == null) {
            return new RowInfo[0];
        }
        MemberInterface[] newNodeValues = new MemberInterface[actualTableNodes.length];
        String dimName = null;
        boolean isInsertingTotalMember = false;
        MemberInterface member = null;
        for (int layer = 0; layer < actualTableNodes.length; ++layer) {
            member = null;
            layerName = actualTableNodes[layer];
            dimName = this.m_layers[layer].getName();
            if (layerName.equals(this.m_measDim) && !alwaysAdd) {
                int measCount = this.m_measList != null ? this.m_measList.length : 0;
                RowInfo[] retRowInfo = new RowInfo[measCount];
                MemberInterface[][] measMembers = new MemberInterface[measCount][];
                EdgeTreeNodeImpl subCurrent = null;
                for (int m = 0; m < measCount; ++m) {
                    isInsertingTotalMember = false;
                    member = null;
                    measMembers[m] = new MemberInterface[newNodeValues.length];
                    System.arraycopy(newNodeValues, 0, measMembers[m], 0, newNodeValues.length);
                    inserting = false;
                    AddNodeStruct anstr = this._findAndAddNode(rowData, this.m_measList[m], dimName, currNode, true, inserting, insertInfo, alwaysAdd, layer == 0, keepNulls, placeTotals, this.m_measList[m], sortInfo, rt);
                    subCurrent = anstr.m_node;
                    if (subCurrent == null) {
                        if (insertInfo == null && anstr.m_continue) continue;
                        return new RowInfo[0];
                    }
                    measMembers[m][layer] = subCurrent.getMember();
                    for (int l = layer + 1; l < actualTableNodes.length; ++l) {
                        member = null;
                        layerName = actualTableNodes[l];
                        if (!isInsertingTotalMember) {
                            isInsertingTotalMember = this._isTotal(rowData.getMember(layerName)) ? !((TotalMember)rowData.getMember(layerName)).isReplacement() : false;
                            inserting = false;
                            anstr = this._findAndAddNode(rowData, layerName, this.m_layers[l].getName(), subCurrent, false, inserting, insertInfo, alwaysAdd, layer == 0, keepNulls, placeTotals, this.m_measList[m], sortInfo, rt);
                            temp = anstr.m_node;
                            if (temp == null) {
                                if (insertInfo == null && anstr.m_continue) continue;
                                return new RowInfo[0];
                            }
                            subCurrent = temp;
                            member = subCurrent.getMember();
                        } else if (!this._isTotal(rowData.getMember(layerName))) {
                            member = rowData.getMember(layerName);
                        }
                        if (member == null) continue;
                        measMembers[m][l] = member;
                    }
                    retRowInfo[m] = new RowInfo(this._removeNulls(measMembers[m]), measMembers[m], this.m_measList[m]);
                }
                return retRowInfo;
            }
            if (!isInsertingTotalMember) {
                isInsertingTotalMember = rowData != null && this._isTotal(rowData.getMember(layerName)) ? !((TotalMember)rowData.getMember(layerName)).isReplacement() : false;
                inserting = false;
                AddNodeStruct anstr = this._findAndAddNode(rowData, layerName, dimName, currNode, false, inserting, insertInfo, alwaysAdd, layer == 0, keepNulls, placeTotals, null, sortInfo, rt);
                temp = anstr.m_node;
                if (temp == null) {
                    if (insertInfo == null && anstr.m_continue) continue;
                    return new RowInfo[0];
                }
                currNode = temp;
                member = currNode.getMember();
            } else if (!this._isTotal(rowData.getMember(layerName))) {
                member = rowData.getMember(layerName);
            }
            if (member == null) continue;
            newNodeValues[layer] = member;
        }
        if (this.m_layers.length == 0) {
            return new RowInfo[0];
        }
        return new RowInfo[]{new RowInfo(this._removeNulls(newNodeValues), newNodeValues, null)};
    }

    private MemberInterface[] _removeNulls(MemberInterface[] newNodeValues) {
        if (newNodeValues != null && newNodeValues.length > 0) {
            this.m_nullList.clear();
            for (int i = 0; i < newNodeValues.length; ++i) {
                if (newNodeValues[i] == null) continue;
                this.m_nullList.add(newNodeValues[i]);
            }
            int size = this.m_nullList.size();
            if (newNodeValues.length != size) {
                newNodeValues = new MemberInterface[size];
                for (int i = 0; i < newNodeValues.length; ++i) {
                    newNodeValues[i] = this.m_nullList.get(i);
                }
            }
        }
        return newNodeValues;
    }

    private AddNodeStruct _findAndAddNode(Row rowData, String colName, String dimName, EdgeTreeNodeImpl currNode, boolean isMeasure, boolean inserting, InsertInfo insertInfo, boolean alwaysAdd, boolean outerLayer, boolean keepNulls, boolean placeTotals, Object currMeas, LayerSortInfo[] sortInfo, ResultTable rt) throws TransformException {
        QDRMember qdrmember;
        QDRInterface qdr;
        Object actualColumn = null;
        String insertLocationValue = null;
        boolean above = false;
        if (inserting) {
            colName = actualColumn;
        }
        MemberInterface member = null;
        if (isMeasure) {
            MemberInterface[] dataItems = this.m_projection.getDataItems();
            for (int i = 0; i < dataItems.length; ++i) {
                if (!colName.equals(dataItems[i].getValue())) continue;
                member = dataItems[i];
                break;
            }
        } else {
            MemberInterface memberInterface = member = rowData != null ? rowData.getMember(colName) : null;
        }
        if (member == null) {
            return new AddNodeStruct(null, false);
        }
        EdgeTreeNodeImpl childNode = null;
        if (inserting) {
            childNode = currNode.findChild(insertLocationValue);
        } else {
            String currValue = member.getValue();
            if (currValue == null && (outerLayer && !keepNulls || rt.hasAggTypeForColumn(colName, AggType.CUSTOM))) {
                return new AddNodeStruct(null, false);
            }
            if (!alwaysAdd) {
                childNode = currNode.findChild(currValue);
            }
        }
        if (!inserting && insertInfo != null && (qdr = insertInfo.getQDR()) != null && (qdrmember = qdr.getDimMember(dimName)) != null && qdrmember.getData() != null && !qdrmember.getData().equals(childNode != null ? childNode.getMember().getValue() : null)) {
            return new AddNodeStruct(null, false);
        }
        if (childNode == null || inserting) {
            boolean replace = false;
            if (rowData != null && !(replace = rowData.replace(member, inserting, colName, currMeas, this.m_measDim)) && this._isTotal(member)) {
                above = rowData.above();
            }
            childNode = currNode.addChild(this.getEdgeTreeNode(false, currNode, member, null, dimName), null, inserting ? insertLocationValue : null, above, alwaysAdd, replace, placeTotals, this.getSortInfo(sortInfo, dimName));
        } else {
            member.setEdgeTreeNode(childNode);
        }
        return new AddNodeStruct(childNode, true);
    }

    private boolean _isTotal(MemberInterface member) throws TransformException {
        if (member == null) {
            return false;
        }
        Object obj = member.getMetadata("isTotal");
        Boolean val = obj instanceof Boolean ? (Boolean)member.getMetadata("isTotal") : null;
        return val != null ? val : false;
    }

    private LayerSortInfo getSortInfo(LayerSortInfo[] sortInfo, String dimName) {
        if (sortInfo == null || dimName == null || this.m_layout == null) {
            return null;
        }
        for (int i = 0; i < sortInfo.length; ++i) {
            int edge = sortInfo[i].getEdge();
            int layer = sortInfo[i].getLayer();
            if (edge < 0 || layer < 0 || edge >= this.m_layout.length || this.m_layout[edge] == null || this.m_layout[edge].length <= layer || !dimName.equals(this.m_layout[edge][layer])) continue;
            return sortInfo[i];
        }
        return null;
    }

    protected class AddNodeStruct {
        protected EdgeTreeNodeImpl m_node = null;
        protected boolean m_continue = true;

        public AddNodeStruct(EdgeTreeNodeImpl node, boolean bContinue) {
            this.m_node = node;
            this.m_continue = bContinue;
        }
    }
}

