/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.NullMetadataProvider;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AggregateMetadataProvider
implements MetadataProvider {
    private static final Logger _LOGGER = Logger.getLogger(AggregateMetadataProvider.class.getName());
    private final MetadataProvider[] _metadataProviders;

    public static MetadataProvider create(Collection<MetadataProvider> providers) {
        if (providers == null || providers.isEmpty()) {
            return NullMetadataProvider.getInstance();
        }
        return new AggregateMetadataProvider(providers);
    }

    private AggregateMetadataProvider(Collection<MetadataProvider> providers) {
        this._metadataProviders = providers.toArray(new MetadataProvider[0]);
    }

    @Override
    public final Map getMetadata(Object key) {
        HashMap combinedMetadata = new HashMap();
        for (int i = this._metadataProviders.length - 1; i >= 0; --i) {
            try {
                Map metadataMap = this._metadataProviders[i].getMetadata(key);
                combinedMetadata.putAll(metadataMap);
                continue;
            }
            catch (Exception e) {
                if (!_LOGGER.isLoggable(Level.WARNING)) continue;
                LogRecord lr = new LogRecord(Level.WARNING, "Error retriving metadata for item {0} from provider {1}");
                lr.setParameters(new Object[]{key, this._metadataProviders[i]});
                lr.setThrown(e);
                _LOGGER.log(lr);
            }
        }
        return combinedMetadata;
    }

    @Override
    public final Object getMetadataItem(Object key, Object itemKey) {
        for (int i = 0; i < this._metadataProviders.length; ++i) {
            try {
                Object metadataItem = this._metadataProviders[i].getMetadataItem(key, itemKey);
                if (metadataItem == null) continue;
                return metadataItem;
            }
            catch (Exception e) {
                if (!_LOGGER.isLoggable(Level.WARNING)) continue;
                LogRecord lr = new LogRecord(Level.WARNING, "Error retriving metadata item {0} for item {1} from provider {2}");
                lr.setParameters(new Object[]{key, itemKey, this._metadataProviders[i]});
                lr.setThrown(e);
                _LOGGER.log(lr);
            }
        }
        return null;
    }

    @Override
    public Object getFunction(String prefix, String name) {
        for (int i = 0; i < this._metadataProviders.length; ++i) {
            try {
                Object function = this._metadataProviders[i].getFunction(prefix, name);
                if (function == null) continue;
                return function;
            }
            catch (Exception e) {
                if (!_LOGGER.isLoggable(Level.WARNING)) continue;
                LogRecord lr = new LogRecord(Level.WARNING, "Error retriving function for item {0} from provider {1}");
                lr.setParameters(new Object[]{name, this._metadataProviders[i]});
                lr.setThrown(e);
                _LOGGER.log(lr);
            }
        }
        return null;
    }

    @Override
    public Collection getPseudoXmlKeys(Object baseKey) {
        LinkedList combinedKeys = new LinkedList();
        for (int i = 0; i < this._metadataProviders.length; ++i) {
            try {
                Collection pseudoKeys = this._metadataProviders[i].getPseudoXmlKeys(baseKey);
                if (pseudoKeys == null || pseudoKeys.isEmpty()) continue;
                combinedKeys.addAll(pseudoKeys);
                continue;
            }
            catch (Exception e) {
                if (!_LOGGER.isLoggable(Level.WARNING)) continue;
                LogRecord lr = new LogRecord(Level.WARNING, "Error retriving pseudoXmlKeys for item {0} from provider {1}");
                lr.setParameters(new Object[]{baseKey, this._metadataProviders[i]});
                lr.setThrown(e);
                _LOGGER.log(lr);
            }
        }
        return Collections.unmodifiableCollection(combinedKeys);
    }

    @Override
    public final List<StructuredMetadataBean> getGlobalMetadata(QualifiedName globalItemName) {
        ArrayList<StructuredMetadataBean> combinedList = new ArrayList<StructuredMetadataBean>();
        for (int i = 0; i < this._metadataProviders.length; ++i) {
            try {
                List<StructuredMetadataBean> globalMetadataList = this._metadataProviders[i].getGlobalMetadata(globalItemName);
                if (globalMetadataList == null || globalMetadataList.isEmpty()) continue;
                combinedList.addAll(globalMetadataList);
                continue;
            }
            catch (Exception e) {
                if (!_LOGGER.isLoggable(Level.WARNING)) continue;
                LogRecord lr = new LogRecord(Level.WARNING, "Error retriving global Metadata item {0} from provider {1}");
                lr.setParameters(new Object[]{globalItemName, this._metadataProviders[i]});
                lr.setThrown(e);
                _LOGGER.log(lr);
            }
        }
        return combinedList;
    }
}

