/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.kvlite;

import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.ServiceUtils;

public class KVLiteAdmin {
    private static final LoginManager NULL_LOGIN_MGR = null;
    private final String kvstore;
    private final BootstrapParams bp;
    private final ParameterMap policyMap;
    private final int numPartitions;

    public KVLiteAdmin(String kvstore, BootstrapParams bp, ParameterMap policyMap, int numPartitions) {
        this.kvstore = kvstore;
        this.bp = bp;
        this.policyMap = policyMap;
        this.numPartitions = numPartitions;
    }

    public void run() throws Exception {
        this.deployStore();
    }

    private void deployStore() throws Exception {
        String host = this.bp.getHostname();
        int port = this.bp.getRegistryPort();
        CommandServiceAPI admin = ServiceUtils.waitForAdmin(host, port, NULL_LOGIN_MGR, 5L, ConfigurableService.ServiceStatus.RUNNING);
        admin.configure(this.kvstore);
        int planId = admin.createDeployDatacenterPlan("Deploy KVLite", "KVLite", 1, DatacenterType.PRIMARY);
        admin.approvePlan(planId);
        admin.executePlan(planId, false);
        admin.awaitPlan(planId, 0, null);
        admin.assertSuccess(planId);
        if (this.policyMap != null) {
            admin.setPolicies(this.policyMap);
        }
        planId = admin.createDeploySNPlan("Deploy Storage Node", new DatacenterId(1), host, port, null);
        admin.approvePlan(planId);
        admin.executePlan(planId, false);
        admin.awaitPlan(planId, 0, null);
        admin.assertSuccess(planId);
        planId = admin.createDeployAdminPlan("Deploy Admin Service", new StorageNodeId(1), this.bp.getAdminHttpPort());
        admin.approvePlan(planId);
        admin.executePlan(planId, false);
        admin.awaitPlan(planId, 0, null);
        admin.assertSuccess(planId);
        admin.addStorageNodePool("KVLitePool");
        admin.addStorageNodeToPool("KVLitePool", new StorageNodeId(1));
        admin.createTopology("KVLite", "KVLitePool", this.numPartitions);
        planId = admin.createDeployTopologyPlan("Deploy KVStore", "KVLite");
        admin.approvePlan(planId);
        admin.executePlan(planId, false);
        admin.awaitPlan(planId, 0, null);
        admin.assertSuccess(planId);
    }
}

