/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializationUtil {
    public static <T> T getObject(byte[] bytes, Class<T> oclass) {
        if (bytes == null) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = ois.readObject();
            return (T)object;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Exception deserializing object: " + oclass.getName(), ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Exception deserializing object: " + oclass.getName(), cnfe);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("Exception closing deserializing stream", ioe);
                }
            }
        }
    }

    public static byte[] getBytes(Object object) {
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Exception serializing object: " + object.getClass().getName(), ioe);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("Exception closing serializing stream", ioe);
                }
            }
        }
    }
}

