/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.File;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

public class FileNames {
    public static final String SNA_CONFIG_FILE = "config.xml";
    public static final String SECURITY_CONFIG_DIR = "security";
    public static final String SECURITY_CONFIG_FILE = "security.xml";
    public static final String JAVA_SECURITY_POLICY_FILE = "security.policy";
    public static final String BOOTSTRAP_SNA_LOG = "snaboot";
    public static final String BOOTSTRAP_ADMIN_LOG = "adminboot";
    public static final String ENV_DIR = "env";
    public static final String SNAPSHOT_DIR = "snapshots";
    public static final String RECOVERY_DIR = "recovery";
    private static final String LOGGING_DIR = "log";
    public static final String WALLET_DIR = "store.wallet";
    public static final String PASSWD_FILE = "store.passwd";
    public static final String KEYSTORE_FILE = "store.keys";
    public static final String TRUSTSTORE_FILE = "store.trust";
    public static final String CLIENT_SECURITY_FILE = "client.security";
    public static final String CLIENT_TRUSTSTORE_FILE = "client.trust";
    public static final String DETAIL_CSV = "_detail.csv";
    public static final String SUMMARY_CSV = "_summary.csv";
    public static final String LOG_FILE_SUFFIX = "log";
    public static final String PERF_FILE_SUFFIX = "perf";
    public static final String STAT_FILE_SUFFIX = "stat";
    private final File kvDir;

    public FileNames(Topology topology, File rootDir) {
        this.kvDir = new File(rootDir, topology.getKVStoreName());
    }

    public File getKvDir() {
        return this.kvDir;
    }

    public static File getKvDir(String rootDirPath, String kvStoreName) {
        return new File(rootDirPath, kvStoreName);
    }

    public static File getSecurityPolicyFile(File kvDir) {
        return new File(kvDir, JAVA_SECURITY_POLICY_FILE);
    }

    public static File getLoggingDir(File rootDir, String kvStoreName) {
        return new File(new File(rootDir, kvStoreName), "log");
    }

    public static void makeLoggingDir(File rootDir, String kvStoreName) {
        File loggingDir = FileNames.getLoggingDir(rootDir, kvStoreName);
        FileNames.makeDir(loggingDir);
    }

    public static File getSNAConfigFile(String rootDirPath, String kvstoreName, StorageNodeId storageNodeId) {
        return new File(FileNames.getStorageNodeDir(rootDirPath, kvstoreName, storageNodeId), SNA_CONFIG_FILE);
    }

    public static File getServiceDir(String rootDirPath, String kvstoreName, File serviceDir, StorageNodeId storageNodeId, ResourceId resourceId) {
        if (serviceDir != null) {
            return new File(serviceDir, resourceId.getFullName());
        }
        File kvDir1 = new File(rootDirPath, kvstoreName);
        return new File(FileNames.getStorageNodeDir(kvDir1, storageNodeId), resourceId.getFullName());
    }

    public static File getEnvDir(String rootDirPath, String kvstoreName, File serviceDir, StorageNodeId storageNodeId, ResourceId resourceId) {
        return new File(FileNames.getServiceDir(rootDirPath, kvstoreName, serviceDir, storageNodeId, resourceId), ENV_DIR);
    }

    public static File getSnapshotDir(String rootDirPath, String kvstoreName, File serviceDir, StorageNodeId storageNodeId, ResourceId resourceId) {
        return new File(FileNames.getServiceDir(rootDirPath, kvstoreName, serviceDir, storageNodeId, resourceId), SNAPSHOT_DIR);
    }

    public static File getRecoveryDir(String rootDirPath, String kvstoreName, File serviceDir, StorageNodeId storageNodeId, ResourceId resourceId) {
        return new File(FileNames.getServiceDir(rootDirPath, kvstoreName, serviceDir, storageNodeId, resourceId), RECOVERY_DIR);
    }

    public static boolean makeDir(File dir) {
        boolean created = false;
        if (!dir.exists() && !(created = dir.mkdirs())) {
            throw new IllegalStateException("Directory: " + dir + " creation failed.");
        }
        return created;
    }

    public File getStorageNodeDir(StorageNodeId storageNodeId) {
        return new File(this.kvDir, storageNodeId.getFullName());
    }

    public static File getStorageNodeDir(File kvDir1, StorageNodeId storageNodeId) {
        return new File(kvDir1, storageNodeId.getFullName());
    }

    public static File getStorageNodeDir(String rootDirPath, String kvstoreName, StorageNodeId storageNodeId) {
        File kvDir = new File(rootDirPath, kvstoreName);
        return FileNames.getStorageNodeDir(kvDir, storageNodeId);
    }
}

