/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.util.Arrays;
import java.util.EnumSet;

public abstract class CommandParser {
    public static final String ROOT_FLAG = "-root";
    public static final String HOST_FLAG = "-host";
    public static final String STORE_FLAG = "-store";
    public static final String PORT_FLAG = "-port";
    public static final String ADMIN_HOST_FLAG = "-admin-host";
    public static final String ADMIN_PORT_FLAG = "-admin-port";
    public static final String ADMIN_FLAG = "-admin";
    public static final String USAGE_FLAG = "-usage";
    public static final String VERBOSE_FLAG = "-verbose";
    public static final String USER_FLAG = "-username";
    public static final String SECURITY_FLAG = "-security";
    public static final String ADMIN_USER_FLAG = "-admin-username";
    public static final String ADMIN_SECURITY_FLAG = "-admin-security";
    public static final String KVSTORE_USAGE_PREFIX = "Usage: java -jar KVHOME/lib/kvstore.jar ";
    public static final String KVCLI_USAGE_PREFIX = "Usage: java -jar KVHOME/lib/kvcli.jar ";
    protected String rootDir;
    protected String hostname;
    protected String storeName;
    protected String userName;
    protected String securityFile;
    protected String adminUserName;
    protected String adminSecurityFilePath;
    protected int registryPort;
    protected int adminPort;
    protected boolean verbose;
    private final boolean dontParse;
    private String[] argArray;
    private int argc;

    public CommandParser(String[] args) {
        this(args, false);
    }

    public CommandParser(String[] args, boolean dontParse) {
        this.dontParse = dontParse;
        if (args == null) {
            throw new IllegalArgumentException();
        }
        this.argArray = args;
        this.argc = 0;
    }

    public void setDefaults(String rootDir, String storeName, String hostname, int registryPort, int adminPort) {
        this.rootDir = rootDir;
        this.storeName = storeName;
        this.hostname = hostname;
        this.registryPort = registryPort;
        this.adminPort = adminPort;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSecurityFile() {
        return this.securityFile;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminSecurityFile() {
        return this.adminSecurityFilePath;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void verbose(String msg) {
        if (this.verbose) {
            System.err.println(msg);
        }
    }

    public String nextArg(String arg) {
        if (this.argc >= this.argArray.length) {
            this.usage("Flag " + arg + " requires an argument");
        }
        return this.argArray[this.argc++];
    }

    public int nextIntArg(String arg) {
        String next = this.nextArg(arg);
        try {
            return Integer.parseInt(next);
        }
        catch (NumberFormatException e) {
            this.usage("Flag " + arg + " requires an integer argument");
            return 0;
        }
    }

    public long nextLongArg(String arg) {
        String next = this.nextArg(arg);
        try {
            return Long.parseLong(next);
        }
        catch (NumberFormatException e) {
            this.usage("Flag " + arg + " requires a long argument");
            return 0L;
        }
    }

    public <E extends Enum<E>> E nextEnumArg(String arg, Class<E> enumClass) {
        String next = this.nextArg(arg);
        try {
            return Enum.valueOf(enumClass, next.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.usage("Flag " + arg + " requires a constant of enum type " + enumClass.getName() + ", one of: " + Arrays.toString(enumClass.getEnumConstants()));
            return null;
        }
    }

    public <E extends Enum<E>> EnumSet<E> nextEnumSetArg(String arg, Class<E> enumClass) {
        EnumSet<E> set = EnumSet.noneOf(enumClass);
        for (String value : this.nextArg(arg).split(",")) {
            try {
                set.add(Enum.valueOf(enumClass, value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                this.usage("Flag " + arg + " requires one or more constants of enum type " + enumClass.getName() + ": " + Arrays.toString(enumClass.getEnumConstants()));
            }
        }
        return set;
    }

    protected int getNRemainingArgs() {
        return this.argArray.length - this.argc;
    }

    protected void missingArg(String arg) {
        this.usage("Flag " + arg + " is required");
    }

    private void unknownArg(String arg) {
        this.usage("Unknown argument: " + arg);
    }

    public void parseArgs() {
        int nArgs = this.argArray.length;
        while (this.argc < nArgs) {
            String thisArg = this.argArray[this.argc++];
            if (this.dontParse) {
                if (this.checkArg(thisArg)) continue;
                this.unknownArg(thisArg);
                continue;
            }
            if (thisArg.equals(ROOT_FLAG)) {
                this.rootDir = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(USAGE_FLAG)) {
                this.usage(null);
                continue;
            }
            if (thisArg.equals(VERBOSE_FLAG)) {
                this.verbose = true;
                continue;
            }
            if (thisArg.equals(HOST_FLAG)) {
                this.hostname = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(PORT_FLAG)) {
                this.registryPort = Integer.parseInt(this.nextArg(thisArg));
                continue;
            }
            if (thisArg.equals(ADMIN_FLAG)) {
                this.adminPort = Integer.parseInt(this.nextArg(thisArg));
                continue;
            }
            if (thisArg.equals(STORE_FLAG)) {
                this.storeName = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(USER_FLAG)) {
                this.userName = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(SECURITY_FLAG)) {
                this.securityFile = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(ADMIN_USER_FLAG)) {
                this.adminUserName = this.nextArg(thisArg);
                continue;
            }
            if (thisArg.equals(ADMIN_SECURITY_FLAG)) {
                this.adminSecurityFilePath = this.nextArg(thisArg);
                continue;
            }
            if (this.checkArg(thisArg)) continue;
            this.unknownArg(thisArg);
        }
        this.verifyArgs();
    }

    public static String optional(String msg) {
        return "[" + msg + "]";
    }

    public static String getUsage() {
        return CommandParser.optional(USAGE_FLAG);
    }

    public static String getRootUsage() {
        return "-root <rootDirectory>";
    }

    public static String getHostUsage() {
        return "-host <hostname>";
    }

    public static String getStoreUsage() {
        return "-store <storeName>";
    }

    public static String getPortUsage() {
        return "-port <port>";
    }

    public static String getAdminUsage() {
        return "-admin <adminPort>";
    }

    public static String getAdminHostUsage() {
        return "-admin-host <adminHost>";
    }

    public static String getUserUsage() {
        return "-username <user>";
    }

    public static String getAdminPortUsage() {
        return "-admin-port <adminPort>";
    }

    public static String getSecurityUsage() {
        return "-security <security-file-path>";
    }

    public static String getAdminUserUsage() {
        return "-admin-username <adminUser>";
    }

    public static String getAdminSecurityUsage() {
        return "-admin-security <admin-security-file-path>";
    }

    protected abstract boolean checkArg(String var1);

    protected abstract void verifyArgs();

    public abstract void usage(String var1);
}

