/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo.split;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.kv.Consistency;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

public class TopoSplit {
    private final int id;
    private final List<Set<Integer>> partitionSets;

    TopoSplit(int id) {
        this.id = id;
        this.partitionSets = new ArrayList<Set<Integer>>();
    }

    TopoSplit(int id, Set<Integer> partitionSet) {
        this(id);
        this.partitionSets.add(partitionSet);
    }

    public boolean isEmpty() {
        return this.partitionSets.isEmpty();
    }

    int getId() {
        return this.id;
    }

    void add(Set<Integer> set) {
        this.partitionSets.add(set);
    }

    void addAll(List<Set<Integer>> pSets) {
        this.partitionSets.addAll(pSets);
    }

    int size() {
        return this.partitionSets.size();
    }

    public List<Set<Integer>> getPartitionSets() {
        return this.partitionSets;
    }

    Set<Integer> getPartitionSet(int slot) {
        return slot >= this.partitionSets.size() ? null : this.partitionSets.get(slot);
    }

    public Set<StorageNode> getSns(Consistency consistency, Topology topology, RegistryUtils regUtils) {
        HashSet<StorageNode> sns = new HashSet<StorageNode>();
        for (Set<Integer> set : this.partitionSets) {
            for (Integer i : set) {
                PartitionId partId = new PartitionId(i);
                RepGroupId repGroupId = topology.getRepGroupId(partId);
                RepGroup repGroup = topology.get(repGroupId);
                Collection<RepNode> repNodes = repGroup.getRepNodes();
                for (RepNode rn : repNodes) {
                    ReplicatedEnvironment.State state;
                    RepNodeStatus rnStatus = null;
                    try {
                        RepNodeAdminAPI rna = regUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                        rnStatus = rna.ping();
                    }
                    catch (RemoteException re) {
                        System.err.println("Ping failed for " + rn.getResourceId() + ": " + re.getMessage());
                    }
                    catch (NotBoundException e) {
                        System.err.println("No RMI service for RN: " + rn.getResourceId() + " message: " + e.getMessage());
                    }
                    if (rnStatus == null || !(state = rnStatus.getReplicationState()).isActive() || consistency == Consistency.NONE_REQUIRED_NO_MASTER && state.isMaster() || consistency == Consistency.ABSOLUTE && !state.isMaster()) continue;
                    StorageNodeId snid = rn.getStorageNodeId();
                    StorageNode sn = topology.get(snid);
                    sns.add(sn);
                }
            }
        }
        return sns;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TopoSplit[");
        sb.append(this.id);
        sb.append(", ");
        for (Set<Integer> set : this.partitionSets) {
            sb.append("\n\t");
            sb.append(set);
        }
        sb.append("]");
        return sb.toString();
    }
}

