/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna.masterBalance;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.io.Serializable;
import java.rmi.RemoteException;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.sna.masterBalance.LeaseManager;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;

public interface MasterBalancingInterface {
    public void noteState(StateInfo var1, AuthContext var2, short var3) throws RemoteException;

    public void noteState(StateInfo var1, short var2) throws RemoteException;

    public MDInfo getMDInfo(AuthContext var1, short var2) throws RemoteException;

    public MDInfo getMDInfo(short var1) throws RemoteException;

    public boolean getMasterLease(MasterLeaseInfo var1, AuthContext var2, short var3) throws RemoteException;

    public boolean getMasterLease(MasterLeaseInfo var1, short var2) throws RemoteException;

    public boolean cancelMasterLease(StorageNode var1, RepNode var2, AuthContext var3, short var4) throws RemoteException;

    public boolean cancelMasterLease(StorageNode var1, RepNode var2, short var3) throws RemoteException;

    public void overloadedNeighbor(StorageNodeId var1, AuthContext var2, short var3) throws RemoteException;

    public void overloadedNeighbor(StorageNodeId var1, short var2) throws RemoteException;

    public static class MDInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final int masterCount;
        final int masterLeaseCount;
        final int rnCount;
        final int balancedMD;

        MDInfo(int masterCount, int masterLeaseCount, int rnCount, int balancedMD) {
            this.masterCount = masterCount;
            this.masterLeaseCount = masterLeaseCount;
            this.rnCount = rnCount;
            this.balancedMD = balancedMD;
        }

        int getPTMD() {
            return this.adjustedMD(this.masterLeaseCount + this.masterCount + 1);
        }

        int getMD() {
            return this.adjustedMD(this.masterLeaseCount + this.masterCount);
        }

        int getRawMD() {
            return this.adjustedMD(this.masterCount);
        }

        private int adjustedMD(int masters) {
            int md = masters * 100 / this.rnCount;
            if (masters == 1 && md > this.balancedMD) {
                return this.balancedMD;
            }
            return md;
        }

        public int getMasterCount() {
            return this.masterCount;
        }

        public int getRNCount() {
            return this.rnCount;
        }
    }

    public static class StateInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final RepNodeId rnId;
        final ReplicatedEnvironment.State state;
        final int topoSequenceNumber;

        public StateInfo(RepNodeId rnId, ReplicatedEnvironment.State state, int topoSequenceNumber) {
            this.rnId = rnId;
            this.state = state;
            this.topoSequenceNumber = topoSequenceNumber;
        }

        public RepNodeId getRnId() {
            return this.rnId;
        }

        public ReplicatedEnvironment.State getState() {
            return this.state;
        }

        public int getTopoSequenceNumber() {
            return this.topoSequenceNumber;
        }

        public String toString() {
            return "State RN:" + this.rnId + " state: " + (Object)((Object)this.state) + " top seq num: " + this.topoSequenceNumber;
        }
    }

    public static class MasterLeaseInfo
    implements Serializable,
    LeaseManager.Lease {
        private static final long serialVersionUID = 1L;
        final StorageNode lesseeSN;
        final RepNode rn;
        final int limitPTMD;
        final int durationMs;

        MasterLeaseInfo(StorageNode lesseeSN, RepNode rn, int limitPTMD, int durationMs) {
            this.lesseeSN = lesseeSN;
            this.rn = rn;
            this.limitPTMD = limitPTMD;
            this.durationMs = durationMs;
        }

        public String toString() {
            return String.format("Master lease:%s Lessee SN:%s LimitPTMD:%d duration:%d ms,", this.rn, this.lesseeSN, this.limitPTMD, this.durationMs);
        }

        @Override
        public RepNodeId getRepNodeId() {
            return (RepNodeId)this.rn.getResourceId();
        }

        @Override
        public int getLeaseDuration() {
            return this.durationMs;
        }
    }
}

