/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.sna.ManagedService;
import oracle.kv.impl.sna.StorageNodeAgent;

public abstract class ServiceManager {
    protected final ManagedService service;
    protected Logger logger;
    protected List<Listener> listeners = new ArrayList<Listener>();

    public ServiceManager(StorageNodeAgent sna, ManagedService service) {
        this.service = service;
        this.logger = sna.getLogger();
    }

    public ManagedService getService() {
        return this.service;
    }

    public abstract void start() throws Exception;

    public abstract void stop();

    public abstract void waitFor(int var1);

    public abstract void dontRestart();

    public abstract boolean isRunning();

    public void reset() {
    }

    public void resetLogger(Logger logger1) {
        this.logger = logger1;
    }

    public boolean forceOK(boolean force) {
        return false;
    }

    public void registered(StorageNodeAgent sna) {
    }

    String[] createArgs() {
        return this.service.createArgs();
    }

    private void addListener(Listener lst) {
        this.listeners.add(lst);
    }

    private void removeListener(Listener lst) {
        this.listeners.remove(lst);
    }

    public void notifyStarted() {
        for (Listener lst : this.listeners) {
            lst.startupCallback();
        }
    }

    public abstract class Listener {
        public Listener() {
            ServiceManager.this.addListener(this);
        }

        public void removeSelf() {
            ServiceManager.this.removeListener(this);
        }

        public abstract void startupCallback();
    }
}

