/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMDChange;
import oracle.kv.impl.security.metadata.SecurityMDListener;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class UserRoleUpdater {
    private final Set<SecurityMDListener> listeners = Collections.synchronizedSet(new HashSet());

    public void addListener(SecurityMDListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SecurityMDListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(SecurityMetadata oldMd, List<SecurityMDChange> mdChanges) {
        ArrayList<SecurityMDListener> listenerCopy;
        if (oldMd == null) {
            return;
        }
        Set<SecurityMDListener> set = this.listeners;
        synchronized (set) {
            listenerCopy = new ArrayList<SecurityMDListener>(this.listeners);
        }
        for (SecurityMDListener listener : listenerCopy) {
            for (SecurityMDChange change : this.getRoleChanges(oldMd, mdChanges)) {
                listener.notifyMetadataChange(change);
            }
        }
    }

    private List<SecurityMDChange> getRoleChanges(SecurityMetadata oldMd, List<SecurityMDChange> mdChanges) {
        ArrayList<SecurityMDChange> changes = new ArrayList<SecurityMDChange>();
        for (SecurityMDChange change : mdChanges) {
            SecurityMDChange.SecurityMDChangeType changeType = change.getChangeType();
            SecurityMetadata.SecurityElementType elementType = change.getElementType();
            if (changeType == SecurityMDChange.SecurityMDChangeType.UPDATE && elementType == SecurityMetadata.SecurityElementType.KVSTOREUSER) {
                KVStoreUser newUser = (KVStoreUser)change.getElement();
                KVStoreUser oldUser = oldMd.getUser(newUser.getName());
                if (newUser.getGrantedRoles().equals(oldUser.getGrantedRoles())) continue;
                changes.add(change);
                continue;
            }
            if (elementType != SecurityMetadata.SecurityElementType.KVSTOREROLE) continue;
            changes.add(change);
        }
        return changes;
    }
}

