/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.metadata;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.kv.impl.security.metadata.SecurityMDChange;
import oracle.kv.impl.security.metadata.SecurityMDListener;

public class SecurityMDTracker {
    private final Set<SecurityMDListener> listeners = Collections.synchronizedSet(new HashSet());

    public void addListener(SecurityMDListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SecurityMDListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners(SecurityMDChange mdChange) {
        this.notify(mdChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(SecurityMDChange mdChange) {
        Set<SecurityMDListener> set = this.listeners;
        synchronized (set) {
            for (SecurityMDListener listener : this.listeners) {
                listener.notifyMetadataChange(mdChange);
            }
        }
    }
}

