/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.metadata;

import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import oracle.kv.impl.security.PasswordHash;

public final class PasswordHashDigest
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final byte[] saltValue;
    private final String hashAlgorithm;
    private final int hashIterations;
    private final byte[] hashedPassword;
    private final int hashBytes;
    private long createdTimeInMillis = System.currentTimeMillis();
    private long lifetime = 0L;

    private PasswordHashDigest(String hashAlgo, byte[] saltValue, int hashIters, byte[] hashedPasswd) {
        this.hashAlgorithm = hashAlgo;
        this.saltValue = saltValue;
        this.hashIterations = hashIters;
        this.hashBytes = hashedPasswd.length;
        this.hashedPassword = hashedPasswd;
    }

    public boolean verifyPassword(char[] plainPassword) {
        byte[] newHashedPassword = PasswordHashDigest.getHashDigest((String)this.hashAlgorithm, (int)this.hashIterations, (int)this.hashBytes, (byte[])this.saltValue, (char[])plainPassword).hashedPassword;
        return Arrays.equals(this.hashedPassword, newHashedPassword);
    }

    public static PasswordHashDigest getHashDigest(String hashAlgorithm, int hashIterations, int hashBytes, byte[] saltValue, char[] plainPassword) {
        if (hashAlgorithm == null || hashAlgorithm.isEmpty()) {
            throw new IllegalArgumentException("Hash algorithm must not be null or empty.");
        }
        if (hashIterations <= 0) {
            throw new IllegalArgumentException("Hash iterations must be a non-negative integer: " + hashIterations);
        }
        if (hashBytes <= 0) {
            throw new IllegalArgumentException("Hash bytes must be a non-negative integer: " + hashBytes);
        }
        if (saltValue == null || saltValue.length == 0) {
            throw new IllegalArgumentException("Salt value must not be null or empty.");
        }
        if (plainPassword == null || plainPassword.length == 0) {
            throw new IllegalArgumentException("Plain password must not be null or empty.");
        }
        GeneralSecurityException hashException = null;
        try {
            byte[] hashedPasswd = PasswordHash.pbeHash(plainPassword, hashAlgorithm, saltValue, hashIterations, hashBytes);
            return new PasswordHashDigest(hashAlgorithm, saltValue, hashIterations, hashedPasswd);
        }
        catch (NoSuchAlgorithmException e) {
            hashException = e;
        }
        catch (InvalidKeySpecException e) {
            hashException = e;
        }
        throw new IllegalStateException("Failed to get hashed password.", hashException);
    }

    public boolean isExpired() {
        if (this.lifetime == 0L) {
            return false;
        }
        return this.lifetime < 0L ? true : System.currentTimeMillis() >= this.createdTimeInMillis + this.lifetime;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long newLifetime) {
        this.lifetime = newLifetime;
    }

    public void refreshCreateTime() {
        this.createdTimeInMillis = System.currentTimeMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result = 527 + this.hashIterations;
        result = result * 31 + this.hashAlgorithm.hashCode();
        result = result * 31 + Arrays.hashCode(this.saltValue);
        result = result * 31 + Arrays.hashCode(this.hashedPassword);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PasswordHashDigest)) {
            return false;
        }
        PasswordHashDigest other = (PasswordHashDigest)obj;
        return Arrays.equals(this.hashedPassword, other.hashedPassword) && Arrays.equals(this.saltValue, other.saltValue) && this.hashAlgorithm.equals(other.hashAlgorithm) && this.hashIterations == other.hashIterations && this.hashBytes == other.hashBytes;
    }

    public PasswordHashDigest clone() {
        PasswordHashDigest result = new PasswordHashDigest(this.hashAlgorithm, (byte[])this.saltValue.clone(), this.hashIterations, (byte[])this.hashedPassword.clone());
        result.createdTimeInMillis = this.createdTimeInMillis;
        result.lifetime = this.lifetime;
        return result;
    }
}

