/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.KVSecurityException;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginResult;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.LoginUpdater;
import oracle.kv.impl.security.login.TrustedLogin;
import oracle.kv.impl.security.login.TrustedLoginHandler;
import oracle.kv.impl.util.registry.VersionedRemoteImpl;

public class TrustedLoginImpl
extends VersionedRemoteImpl
implements TrustedLogin,
LoginUpdater.ServiceParamsUpdater,
LoginUpdater.GlobalParamsUpdater {
    private final TrustedLoginHandler trustedHandler;
    private final ProcessFaultHandler faultHandler;
    private final Logger logger;

    public TrustedLoginImpl(ProcessFaultHandler faultHandler, TrustedLoginHandler trustedHandler, Logger logger) {
        this.faultHandler = faultHandler;
        this.trustedHandler = trustedHandler;
        this.logger = logger;
    }

    @Override
    public LoginResult loginInternal(short serialVersion) {
        LoginResult result = this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<LoginResult>(){

            @Override
            public LoginResult execute() {
                return TrustedLoginImpl.this.trustedHandler.loginInternal(TrustedLoginImpl.this.getClientHost());
            }
        });
        return result;
    }

    @Override
    public Subject validateLoginToken(final LoginToken loginToken, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Subject>(){

            @Override
            public Subject execute() {
                return TrustedLoginImpl.this.trustedHandler.validateLoginToken(loginToken);
            }
        });
    }

    @Override
    public void logout(final LoginToken loginToken, short serialVersion) throws AuthenticationRequiredException, SessionAccessException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                try {
                    TrustedLoginImpl.this.trustedHandler.logout(loginToken);
                }
                catch (KVSecurityException kvse) {
                    throw new ClientAccessException(kvse);
                }
            }
        });
    }

    private String getClientHost() {
        try {
            return RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException snae) {
            this.logger.log(Level.SEVERE, "RemoteServer.getClientHost failed: ({0})", snae.getMessage());
            return null;
        }
    }

    @Override
    public void newServiceParameters(ParameterMap map) {
        if (this.trustedHandler == null) {
            return;
        }
        int newLimit = map.getOrDefault("sessionLimit").asInt();
        if (this.trustedHandler.updateSessionLimit(newLimit)) {
            this.logger.log(Level.INFO, "SessionLimit for TrustedLoginHandler has been updated: {0}", newLimit);
        }
    }

    @Override
    public void newGlobalParameters(ParameterMap map) {
        if (this.trustedHandler == null) {
            return;
        }
        GlobalParams gp = new GlobalParams(map);
        long newLifetime = gp.getSessionTimeoutUnit().toMillis(gp.getSessionTimeout());
        if (this.trustedHandler.updateSessionLifetime(newLifetime)) {
            this.logger.log(Level.INFO, "SessionLifetime for TrustedLoginHandler has been updated: {0} ms", newLifetime);
        }
    }
}

