/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import oracle.kv.impl.security.login.LoginSession;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.FastExternalizable;

public final class SessionId
implements Serializable,
FastExternalizable {
    public static final int SESSION_ID_MAX_SIZE = 127;
    private static final long serialVersionUID = 1L;
    private static final int HAS_ALLOCATOR = 1;
    private IdScope idValueScope;
    private byte[] idValue;
    private ResourceId allocator;

    private static IdScope getScope(int ordinal) {
        try {
            return IdScope.values()[ordinal];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("invalid scope: " + ordinal);
        }
    }

    public SessionId(byte[] idValue) {
        if (idValue.length > 127) {
            throw new IllegalArgumentException("sessionId length exceeds limit");
        }
        this.idValueScope = IdScope.PERSISTENT;
        this.idValue = Arrays.copyOf(idValue, idValue.length);
    }

    public SessionId(byte[] idValue, IdScope idValueScope, ResourceId allocator) {
        if (idValueScope == IdScope.PERSISTENT) {
            throw new IllegalArgumentException("invalid scope");
        }
        if (idValue.length > 127) {
            throw new IllegalArgumentException("sessionId length exceeds limit");
        }
        this.idValueScope = idValueScope;
        this.idValue = Arrays.copyOf(idValue, idValue.length);
        this.allocator = allocator;
    }

    public SessionId(ObjectInput in, short serialVersion) throws IOException {
        byte flagByte = in.readByte();
        this.idValueScope = SessionId.getScope(in.readByte());
        byte valueLen = in.readByte();
        this.idValue = new byte[valueLen];
        in.read(this.idValue, 0, valueLen);
        if ((flagByte & 1) != 0) {
            this.allocator = ResourceId.readFastExternal(in, serialVersion);
        }
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        int flagByte = 0;
        if (this.allocator != null) {
            flagByte |= 1;
        }
        out.writeByte(flagByte);
        out.writeByte(this.idValueScope.ordinal());
        out.writeByte(this.idValue.length);
        out.write(this.idValue, 0, this.idValue.length);
        if (this.allocator != null) {
            this.allocator.writeFastExternal(out, serialVersion);
        }
    }

    public byte[] getIdValue() {
        return this.idValue;
    }

    public IdScope getIdValueScope() {
        return this.idValueScope;
    }

    public ResourceId getAllocator() {
        return this.allocator;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != SessionId.class) {
            return false;
        }
        SessionId otherToken = (SessionId)other;
        return this.idValueScope == otherToken.idValueScope && Arrays.equals(this.idValue, otherToken.idValue) && (this.allocator == null && otherToken.allocator == null || this.allocator != null && this.allocator.equals(otherToken.allocator));
    }

    public int hashCode() {
        return Arrays.hashCode(this.idValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionId: scope=");
        sb.append((Object)this.idValueScope);
        sb.append(", hashId()=");
        sb.append(this.hashId());
        sb.append(", allocator=");
        sb.append(this.allocator);
        return sb.toString();
    }

    public int hashId() {
        return LoginSession.Id.hashId(this.idValue);
    }

    public static enum IdScope {
        PERSISTENT,
        LOCAL,
        STORE;

    }
}

