/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.LoginCredentials;
import oracle.kv.PasswordCredentials;
import oracle.kv.impl.security.login.LoginResult;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.UserLoginAPI;
import oracle.kv.impl.security.login.UserLoginManager;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.HostPort;
import oracle.kv.impl.util.registry.RegistryUtils;

public class AdminLoginManager
extends UserLoginManager {
    public AdminLoginManager(String username, boolean autoRenew) {
        super(username, autoRenew);
    }

    public void initialize(LoginToken token, String registryHost, int registryPort) {
        this.init(new AdminLoginHandle(token, registryHost, registryPort));
    }

    public boolean bootstrap(String registryHost, int registryPort, LoginCredentials loginCreds) throws AuthenticationFailureException {
        return this.bootstrap(new String[]{registryHost + ":" + registryPort}, loginCreds);
    }

    public boolean bootstrap(String[] registryHostPorts, LoginCredentials loginCreds) throws AuthenticationFailureException {
        HostPort[] hostPorts;
        for (HostPort hostPort : hostPorts = HostPort.parse(registryHostPorts)) {
            String registryHost = hostPort.hostname();
            int registryPort = hostPort.port();
            try {
                UserLoginAPI loginAPI = RegistryUtils.getAdminLogin(registryHost, registryPort, null);
                LoginResult login = loginAPI.login(loginCreds);
                if (login.getLoginToken() == null) continue;
                AdminLoginHandle loginHandle = new AdminLoginHandle(login.getLoginToken(), registryHost, registryPort);
                this.init(loginHandle);
                return true;
            }
            catch (NotBoundException nbe) {
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean renewPassword(String registryHost, int registryPort, PasswordCredentials oldCreds, char[] newPassword) throws AuthenticationFailureException {
        try {
            UserLoginAPI loginAPI = RegistryUtils.getAdminLogin(registryHost, registryPort, null);
            LoginResult login = loginAPI.renewPasswordLogin(oldCreds, newPassword);
            if (login.getLoginToken() != null) {
                AdminLoginHandle loginHandle = new AdminLoginHandle(login.getLoginToken(), registryHost, registryPort);
                this.init(loginHandle);
                return true;
            }
        }
        catch (NotBoundException nbe) {
            return false;
        }
        catch (RemoteException re) {
            return false;
        }
        return false;
    }

    private static final class AdminLoginHandle
    extends UserLoginManager.AbstractUserLoginHandle {
        private final String hostname;
        private final int registryPort;

        private AdminLoginHandle(LoginToken loginToken, String hostname, int registryPort) {
            super(loginToken);
            this.hostname = hostname;
            this.registryPort = registryPort;
        }

        @Override
        protected UserLoginAPI getLoginAPI() throws RemoteException {
            try {
                return RegistryUtils.getAdminLogin(this.hostname, this.registryPort, null);
            }
            catch (NotBoundException nbe) {
                throw new RemoteException("login interface not bound", nbe);
            }
        }

        @Override
        public boolean isUsable(ResourceId.ResourceType rtype) {
            return rtype.equals((Object)ResourceId.ResourceType.ADMIN);
        }
    }
}

