/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.KVStoreRole;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class RoleInstance
extends SecurityMetadata.SecurityElement {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Set<KVStorePrivilege> grantedPrivileges;
    private final boolean assignable;
    private final boolean readonly;
    private final Set<String> grantedRoles;
    public static final String READONLY_NAME = "readonly";
    public static final String WRITEONLY_NAME = "writeonly";
    public static final String READWRITE_NAME = "readwrite";
    public static final String DBADMIN_NAME = "dbadmin";
    public static final String SYSADMIN_NAME = "sysadmin";
    public static final String PUBLIC_NAME = "public";
    public static final RoleInstance READONLY = new RoleInstance("readonly", new KVStorePrivilege[]{SystemPrivilege.READ_ANY}, true, new String[0]);
    public static final RoleInstance WRITEONLY = new RoleInstance("writeonly", new KVStorePrivilege[]{SystemPrivilege.WRITE_ANY}, true, new String[0]);
    public static final RoleInstance READWRITE = new RoleInstance("readwrite", new KVStorePrivilege[]{SystemPrivilege.WRITE_ANY, SystemPrivilege.READ_ANY}, true, new String[0]);
    public static final RoleInstance DBADMIN = new RoleInstance("dbadmin", new KVStorePrivilege[]{SystemPrivilege.SYSDBA, SystemPrivilege.DBVIEW}, true, new String[0]);
    public static final RoleInstance SYSADMIN = new RoleInstance("sysadmin", new KVStorePrivilege[]{SystemPrivilege.SYSDBA, SystemPrivilege.SYSOPER, SystemPrivilege.SYSVIEW}, true, new String[0]);
    public static final RoleInstance PUBLIC = new RoleInstance("public", new KVStorePrivilege[]{SystemPrivilege.USRVIEW, SystemPrivilege.DBVIEW}, false, new String[0]);
    public static final RoleInstance INTERNAL = new RoleInstance(KVStoreRole.INTERNAL.toString(), new KVStorePrivilege[]{SystemPrivilege.INTLOPER}, false, new String[]{PUBLIC.name(), SYSADMIN.name(), READWRITE.name()});
    public static final RoleInstance ADMIN = new RoleInstance(KVStoreRole.ADMIN.toString(), new KVStorePrivilege[0], false, new String[]{PUBLIC.name(), SYSADMIN.name(), READWRITE.name()});
    public static final RoleInstance AUTHENTICATED = new RoleInstance(KVStoreRole.AUTHENTICATED.toString(), new KVStorePrivilege[0], false, new String[]{PUBLIC.name(), READWRITE.name()});
    private static final Set<String> r3CompatRoleNames = new HashSet<String>(Arrays.asList(ADMIN.name(), INTERNAL.name(), AUTHENTICATED.name()));

    private RoleInstance(String roleName, KVStorePrivilege[] privileges, boolean assignable, String[] roles) {
        this(roleName, privileges, roles, assignable, true);
    }

    public RoleInstance(String roleName, KVStorePrivilege[] privileges, String[] roles, boolean assignable, boolean readonly) {
        this.name = RoleInstance.getNormalizedName(roleName);
        this.assignable = assignable;
        this.readonly = readonly;
        this.grantedPrivileges = new HashSet<KVStorePrivilege>();
        this.grantedRoles = new HashSet<String>();
        Collections.addAll(this.grantedPrivileges, privileges);
        Collections.addAll(this.grantedRoles, roles);
    }

    public RoleInstance(String roleName) {
        this(roleName, new KVStorePrivilege[0], new String[0], true, false);
    }

    protected RoleInstance(RoleInstance other) {
        super(other);
        this.name = other.name;
        this.assignable = other.assignable;
        this.readonly = other.readonly;
        this.grantedPrivileges = new HashSet<KVStorePrivilege>(other.grantedPrivileges);
        this.grantedRoles = new HashSet<String>(other.grantedRoles);
    }

    public String name() {
        return this.name;
    }

    public RoleInstance grantPrivileges(Collection<KVStorePrivilege> privileges) {
        this.grantedPrivileges.addAll(privileges);
        return this;
    }

    public RoleInstance grantRoles(Collection<String> roles) {
        for (String role : roles) {
            this.grantedRoles.add(RoleInstance.getNormalizedName(role));
        }
        return this;
    }

    public RoleInstance revokePrivileges(Collection<KVStorePrivilege> privileges) {
        this.grantedPrivileges.removeAll(privileges);
        return this;
    }

    public RoleInstance revokeRoles(Collection<String> roles) {
        for (String role : roles) {
            this.grantedRoles.remove(RoleInstance.getNormalizedName(role));
        }
        return this;
    }

    public Set<String> getGrantedRoles() {
        return Collections.unmodifiableSet(this.grantedRoles);
    }

    String grantedRolesAsJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (String role : this.grantedRoles) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("\"");
            sb.append(role);
            sb.append("\"");
        }
        sb.append("]");
        return sb.toString();
    }

    public Set<KVStorePrivilege> getPrivileges() {
        return Collections.unmodifiableSet(this.grantedPrivileges);
    }

    String grantedPrivilegesAsJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (KVStorePrivilege priv : this.grantedPrivileges) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("\"");
            sb.append(priv);
            sb.append("\"");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean assignable() {
        return this.assignable;
    }

    public boolean readonly() {
        return this.readonly;
    }

    public String toBriefString() {
        return String.format("name=%s", this.name);
    }

    public RoleDescription getDescription() {
        String briefAsJSON = String.format("{\"name\":\"%s\"}", this.name);
        String detailsAsJSON = String.format("{\"name\":\"%s\", \"assignable\":\"%b\", \"readonly\":\"%s\", \"granted-privileges\":\"%s\", \"granted-roles\":%s}", this.name, this.assignable, this.readonly, this.grantedPrivilegesAsJSON(), this.grantedRolesAsJSON());
        return new RoleDescription(this.toBriefString(), briefAsJSON, this.toString(), detailsAsJSON);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RoleInstance other = (RoleInstance)obj;
        return this.name.equalsIgnoreCase(other.name);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public RoleInstance clone() {
        return new RoleInstance(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" name=");
        sb.append(this.name);
        sb.append(" assignable=" + this.assignable);
        sb.append(" readonly=" + this.readonly);
        if (this.grantedRoles.size() > 0) {
            sb.append(" granted-roles=");
            sb.append(this.grantedRoles);
        }
        if (this.grantedPrivileges.size() > 0) {
            sb.append(" granted-privileges=");
            sb.append(this.grantedPrivileges);
        }
        return sb.toString();
    }

    @Override
    public SecurityMetadata.SecurityElementType getElementType() {
        return SecurityMetadata.SecurityElementType.KVSTOREROLE;
    }

    public static String getR3CompatName(String role) {
        if (r3CompatRoleNames.contains(role)) {
            return role.toUpperCase(Locale.ENGLISH);
        }
        return role;
    }

    public static String getNormalizedName(String role) {
        return role.toLowerCase(Locale.ENGLISH);
    }

    public static class RoleDescription
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String brief;
        private final String briefAsJSON;
        private final String details;
        private final String detailsAsJSON;

        public RoleDescription(String brief, String briefAsJSON, String details, String detailsAsJSON) {
            this.brief = brief;
            this.briefAsJSON = briefAsJSON;
            this.details = details;
            this.detailsAsJSON = detailsAsJSON;
        }

        public String brief() {
            return this.brief;
        }

        public String briefAsJSON() {
            return this.briefAsJSON;
        }

        public String details() {
            return this.details;
        }

        public String detailsAsJSON() {
            return this.detailsAsJSON;
        }
    }
}

