/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.security.auth.Subject;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.SessionAccessException;

public final class ExecutionContext {
    private static final ThreadLocal<ExecutionContext> currentContext = new ThreadLocal();
    private final AuthContext requestorCtx;
    private final Subject requestorSubj;
    private final OperationContext opCtx;
    private final String clientHost;
    private final PrivilegeCollection privileges;

    private ExecutionContext(AuthContext requestorCtx, Subject requestorSubject, PrivilegeCollection requestorPrivis, OperationContext opCtx) {
        this.requestorCtx = requestorCtx;
        this.requestorSubj = requestorSubject;
        this.opCtx = opCtx;
        this.clientHost = ExecutionContext.getRMIClientHost();
        this.privileges = requestorPrivis;
    }

    public AuthContext requestorContext() {
        return this.requestorCtx;
    }

    public Subject requestorSubject() {
        return this.requestorSubj;
    }

    public String requestorHost() {
        return this.clientHost;
    }

    public OperationContext operationContext() {
        return this.opCtx;
    }

    public PrivilegeCollection requestorPrivileges() {
        return this.privileges;
    }

    public static ExecutionContext create(AccessChecker accessCheck, AuthContext requestorCtx, OperationContext opCtx) throws AuthenticationRequiredException, UnauthorizedException, SessionAccessException {
        PrivilegeCollection subjPrivis;
        Subject reqSubj;
        if (accessCheck == null) {
            reqSubj = null;
            subjPrivis = null;
        } else {
            reqSubj = accessCheck.identifyRequestor(requestorCtx);
            subjPrivis = new PrivilegeCollection(accessCheck.identifyPrivileges(reqSubj));
        }
        ExecutionContext execCtx = new ExecutionContext(requestorCtx, reqSubj, subjPrivis, opCtx);
        if (accessCheck != null) {
            accessCheck.checkAccess(execCtx, opCtx);
        }
        return execCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, E extends Exception> R runWithContext(Operation<R, E> operation, ExecutionContext execCtx) throws E {
        ExecutionContext priorCtx = currentContext.get();
        try {
            currentContext.set(execCtx);
            R r = operation.run();
            return r;
        }
        finally {
            currentContext.set(priorCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R runWithContext(SimpleOperation<R> operation, ExecutionContext execCtx) {
        ExecutionContext priorCtx = currentContext.get();
        try {
            currentContext.set(execCtx);
            R r = operation.run();
            return r;
        }
        finally {
            currentContext.set(priorCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> void runWithContext(Procedure<E> procedure, ExecutionContext execCtx) throws E {
        ExecutionContext priorCtx = currentContext.get();
        try {
            currentContext.set(execCtx);
            procedure.run();
        }
        finally {
            currentContext.set(priorCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithContext(SimpleProcedure procedure, ExecutionContext execCtx) {
        ExecutionContext priorCtx = currentContext.get();
        try {
            currentContext.set(execCtx);
            procedure.run();
        }
        finally {
            currentContext.set(priorCtx);
        }
    }

    public static ExecutionContext getCurrent() {
        return currentContext.get();
    }

    public static Subject getCurrentUserSubject() {
        ExecutionContext execCtx = ExecutionContext.getCurrent();
        if (execCtx == null) {
            return null;
        }
        return execCtx.requestorSubject();
    }

    public static String getCurrentUserHost() {
        ExecutionContext execCtx = ExecutionContext.getCurrent();
        if (execCtx == null) {
            return null;
        }
        return execCtx.requestorHost();
    }

    public static KVStoreUserPrincipal getCurrentUserPrincipal() {
        return ExecutionContext.getSubjectUserPrincipal(ExecutionContext.getCurrentUserSubject());
    }

    public static PrivilegeCollection getCurrentPrivileges() {
        ExecutionContext execCtx = ExecutionContext.getCurrent();
        if (execCtx == null) {
            return null;
        }
        return execCtx.requestorPrivileges();
    }

    public static KVStoreUserPrincipal getSubjectUserPrincipal(Subject subj) {
        if (subj == null) {
            return null;
        }
        Set<KVStoreUserPrincipal> userPrincs = subj.getPrincipals(KVStoreUserPrincipal.class);
        if (userPrincs.isEmpty()) {
            return null;
        }
        if (userPrincs.size() != 1) {
            throw new IllegalStateException("Current user has multiple user principals");
        }
        return userPrincs.iterator().next();
    }

    public static KVStoreRolePrincipal[] getSubjectRolePrincipals(Subject subj) {
        if (subj == null) {
            return null;
        }
        Set<KVStoreRolePrincipal> rolePrincs = subj.getPrincipals(KVStoreRolePrincipal.class);
        return rolePrincs.toArray(new KVStoreRolePrincipal[rolePrincs.size()]);
    }

    public static String[] getSubjectRoles(Subject subj) {
        if (subj == null) {
            return null;
        }
        Set<KVStoreRolePrincipal> rolePrincs = subj.getPrincipals(KVStoreRolePrincipal.class);
        ArrayList<String> roles = new ArrayList<String>();
        for (KVStoreRolePrincipal princ : rolePrincs) {
            roles.add(princ.getName());
        }
        return roles.toArray(new String[roles.size()]);
    }

    public boolean hasRole(String roleName) {
        return ExecutionContext.subjectHasRole(this.requestorSubj, roleName);
    }

    public static boolean subjectHasRole(Subject subj, String roleName) {
        for (Principal princ : subj.getPrincipals()) {
            KVStoreRolePrincipal rolePrinc;
            if (!KVStoreRolePrincipal.class.isAssignableFrom(princ.getClass()) || !(rolePrinc = (KVStoreRolePrincipal)princ).getName().equals(roleName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllPrivileges(Collection<? extends KVStorePrivilege> privis) {
        return this.privileges != null && this.privileges.impliesAll(privis);
    }

    public boolean hasPrivilege(KVStorePrivilege privi) {
        return this.privileges != null && this.privileges.implies(privi);
    }

    private static String getRMIClientHost() {
        try {
            return RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException snae) {
            return null;
        }
    }

    public static class PrivilegeCollection {
        private final Set<KVStorePrivilege> privilegeSet;

        PrivilegeCollection(Set<KVStorePrivilege> privileges) {
            this.privilegeSet = privileges;
        }

        public boolean implies(KVStorePrivilege privilege) {
            if (this.privilegeSet == null) {
                return false;
            }
            if (this.privilegeSet.contains(privilege)) {
                return true;
            }
            KVStorePrivilege[] implications = privilege.implyingPrivileges();
            if (implications != null) {
                for (KVStorePrivilege privi : implications) {
                    if (!this.privilegeSet.contains(privi)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean impliesAll(Collection<? extends KVStorePrivilege> privileges) {
            if (privileges == null) {
                return false;
            }
            for (KVStorePrivilege kVStorePrivilege : privileges) {
                if (this.implies(kVStorePrivilege)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface SimpleProcedure {
        public void run();
    }

    public static interface Procedure<E extends Exception> {
        public void run() throws E;
    }

    public static interface SimpleOperation<R> {
        public R run();
    }

    public static interface Operation<R, E extends Exception> {
        public R run() throws E;
    }
}

