/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.table;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.api.ops.MultiDeleteTable;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.TableIterate;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.table.SecondaryInfoMap;
import oracle.kv.impl.rep.table.TableManager;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Table;

abstract class MaintenanceThread
extends Thread {
    private static final int NUM_DB_OP_RETRIES = 100;
    private static final long SHORT_RETRY_TIME = 500L;
    private static final long LONG_RETRY_TIME = 1000L;
    private static final int POPULATE_BATCH_SIZE = 100;
    private static final int CLEAN_BATCH_SIZE = 100;
    private static final int DELETE_BATCH_SIZE = 100;
    protected final TableManager tableManager;
    protected final RepNode repNode;
    protected final Logger logger;
    protected final ReplicatedEnvironment repEnv;
    protected volatile boolean stop = false;

    protected MaintenanceThread(String name, TableManager tableManager, RepNode repNode, ReplicatedEnvironment repEnv, Logger logger) {
        super(name);
        this.tableManager = tableManager;
        this.repNode = repNode;
        this.repEnv = repEnv;
        this.logger = logger;
    }

    @Override
    public void run() {
        this.logger.log(Level.INFO, "Starting {0}", this);
        while (!this.isStopped()) {
            try {
                if (!this.repNode.getMigrationManager().awaitIdle(10L, TimeUnit.SECONDS)) continue;
                break;
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
        }
        Throwable de = null;
        long delay = 0L;
        int retryCount = 100;
        Database infoDb = null;
        while (!this.isStopped()) {
            try {
                infoDb = SecondaryInfoMap.openDb(this.repEnv);
                this.doWork(infoDb);
                this.stop = true;
                this.tableManager.maintenanceThreadExit(this.repEnv, infoDb);
                return;
            }
            catch (InsufficientAcksException iae) {
                de = iae;
                delay = 1000L;
            }
            catch (InsufficientReplicasException ire) {
                de = ire;
                delay = 1000L;
            }
            catch (LockConflictException lce) {
                de = lce;
                delay = 500L;
            }
            catch (RuntimeException re) {
                if (this.isStopped()) {
                    this.logger.log(Level.INFO, "{0} exiting after, {1}", new Object[]{this, re});
                    return;
                }
                throw re;
            }
            finally {
                if (infoDb != null) {
                    TxnUtil.close(this.logger, infoDb, null);
                }
            }
            assert (de != null);
            this.retrySleep(retryCount, delay, (DatabaseException)de);
            --retryCount;
        }
        this.logger.log(Level.FINE, "{0} stopped", this);
    }

    private void retrySleep(int count, long sleepTime, DatabaseException de) {
        if (count <= 0) {
            throw de;
        }
        this.logger.log(Level.INFO, "DB op caused {0}, will retry in {1}ms, attempts left: {2}", new Object[]{de, sleepTime, count});
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException(ie);
        }
    }

    abstract void doWork(Database var1);

    protected boolean isStopped() {
        return this.stop || !this.repEnv.isValid() || !this.repEnv.getState().isMaster();
    }

    void waitForStop() {
        assert (Thread.currentThread() != this);
        this.stop = true;
        try {
            this.join();
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException(ie);
        }
    }

    private static class MultiDeleteTableInternal
    extends MultiDeleteTable {
        MultiDeleteTableInternal(byte[] parentKeyBytes, long targetTableId, boolean majorPathComplete, byte[] resumeKey) {
            super(parentKeyBytes, targetTableId, majorPathComplete, 100, resumeKey);
        }

        MultiDeleteTableInternal(ObjectInput in, short serialVersion) throws IOException {
            super(in, serialVersion);
            throw new UnsupportedOperationException("Class cannot be deserialized");
        }

        @Override
        protected void verifyTableAccess(OperationHandler operationHandler) {
        }
    }

    static class PrimaryCleanerThread
    extends MaintenanceThread {
        PrimaryCleanerThread(TableManager tableManager, RepNode repNode, ReplicatedEnvironment repEnv, Logger logger) {
            super("KV primary cleaner", tableManager, repNode, repEnv, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWork(Database infoDb) {
            if (this.isStopped()) {
                return;
            }
            OperationHandler oh = new OperationHandler(this.repNode, this.tableManager.getParams());
            String currentTable = null;
            while (!this.isStopped()) {
                SecondaryInfoMap infoMap;
                Transaction txn;
                block13: {
                    txn = null;
                    txn = this.repEnv.beginTransaction(null, SecondaryInfoMap.CLEANER_CONFIG);
                    infoMap = SecondaryInfoMap.fetch(infoDb, txn, LockMode.RMW);
                    if (currentTable == null) {
                        currentTable = infoMap.getNextDeletedTableToClean();
                    }
                    if (currentTable != null) break block13;
                    this.logger.info("Completed cleaning partition database(s) for all tables");
                    TxnUtil.abort(txn);
                    return;
                }
                try {
                    SecondaryInfoMap.DeletedTableInfo info = infoMap.getDeletedTableInfo(currentTable);
                    assert (info != null);
                    assert (!info.isDone());
                    if (info.getCurrentPartition() == null) {
                        for (PartitionId partition : this.repNode.getPartitions()) {
                            if (info.isCompleted(partition)) continue;
                            info.setCurrentPartition(partition);
                            break;
                        }
                    }
                    if (info.getCurrentPartition() == null) {
                        this.logger.log(Level.FINE, "Completed cleaning partition database(s) for {0}", currentTable);
                        info.setDone();
                        currentTable = null;
                    } else if (this.deleteABlock(info, oh, txn)) {
                        this.logger.log(Level.FINE, "Completed cleaning {0} for {1}", new Object[]{info.getCurrentPartition(), currentTable});
                        info.completeCurrentPartition();
                    }
                    infoMap.persist(infoDb, txn);
                    txn.commit();
                    txn = null;
                }
                catch (Throwable throwable) {
                    TxnUtil.abort(txn);
                    throw throwable;
                }
                TxnUtil.abort(txn);
            }
        }

        private boolean deleteABlock(SecondaryInfoMap.DeletedTableInfo info, OperationHandler oh, Transaction txn) {
            MultiDeleteTableInternal mdt = new MultiDeleteTableInternal(info.getParentKeyBytes(), info.getTargetTableId(), info.getMajorPathComplete(), info.getCurrentKeyBytes());
            Result result = mdt.execute(txn, info.getCurrentPartition(), oh);
            int num = result.getNDeletions();
            this.logger.log(Level.FINE, "Deleted {0} records in partition {1}{2}", new Object[]{num, info.getCurrentPartition(), num < 100 ? ", partition is complete" : ""});
            if (num < 100) {
                info.setCurrentKeyBytes(null);
                return true;
            }
            info.setCurrentKeyBytes(mdt.getLastDeleted());
            return false;
        }
    }

    static class SecondaryCleanerThread
    extends MaintenanceThread {
        SecondaryCleanerThread(TableManager tableManager, RepNode repNode, ReplicatedEnvironment repEnv, Logger logger) {
            super("KV secondary cleaner", tableManager, repNode, repEnv, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWork(Database infoDb) {
            if (this.isStopped()) {
                return;
            }
            String currentSecondary = null;
            while (!this.isStopped()) {
                SecondaryDatabase db;
                SecondaryInfoMap.SecondaryInfo info;
                SecondaryInfoMap infoMap;
                Transaction txn;
                block11: {
                    block10: {
                        txn = null;
                        try {
                            txn = this.repEnv.beginTransaction(null, SecondaryInfoMap.CLEANER_CONFIG);
                            infoMap = SecondaryInfoMap.fetch(infoDb, txn, LockMode.RMW);
                            if (currentSecondary == null && (currentSecondary = infoMap.getNextSecondaryToClean()) != null) {
                                this.logger.log(Level.INFO, "Cleaning {0}", currentSecondary);
                            }
                            if (currentSecondary != null) break block10;
                            this.logger.info("Completed cleaning secondary database(s)");
                        }
                        catch (Throwable throwable) {
                            TxnUtil.abort(txn);
                            throw throwable;
                        }
                        TxnUtil.abort(txn);
                        return;
                    }
                    info = infoMap.getSecondaryInfo(currentSecondary);
                    assert (info != null);
                    assert (info.needsCleaning());
                    db = this.tableManager.getSecondaryDb(currentSecondary);
                    if (db != null) break block11;
                    this.logger.log(Level.WARNING, "Failed to clean {0}, secondary database {1} is missing", new Object[]{info, currentSecondary});
                    TxnUtil.abort(txn);
                    return;
                }
                if (!db.deleteObsoletePrimaryKeys(info.getLastKey(), info.getLastData(), 100)) {
                    this.logger.log(Level.INFO, "Completed cleaning {0}", currentSecondary);
                    info.doneCleaning();
                    currentSecondary = null;
                }
                infoMap.persist(infoDb, txn);
                txn.commit();
                txn = null;
                TxnUtil.abort(txn);
            }
        }
    }

    private static class TableIterateInternal
    extends TableIterate {
        TableIterateInternal(byte[] parentKeyBytes, TargetTables targetTables, boolean majorPathComplete, byte[] resumeKey) {
            super(parentKeyBytes, targetTables, majorPathComplete, 100, resumeKey);
        }

        TableIterateInternal(ObjectInput in, short serialVersion) throws IOException {
            super(in, serialVersion);
            throw new UnsupportedOperationException("Class cannot be deserialized");
        }

        @Override
        protected void verifyTableAccess(OperationHandler operationHandler) {
        }
    }

    static class PopulateThread
    extends MaintenanceThread {
        PopulateThread(TableManager tableManager, RepNode repNode, ReplicatedEnvironment repEnv, Logger logger) {
            super("KV secondary populator", tableManager, repNode, repEnv, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        protected void doWork(Database infoDb) {
            if (this.isStopped()) {
                return;
            }
            oh = new OperationHandler(this.repNode, this.tableManager.getParams());
            currentSecondary = null;
            while (!this.isStopped()) {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                txn = null;
                                txn = this.repEnv.beginTransaction(null, SecondaryInfoMap.SECONDARY_INFO_CONFIG);
                                infoMap = SecondaryInfoMap.fetch(infoDb, txn, LockMode.RMW);
                                if (currentSecondary != null) ** GOTO lbl19
                                currentSecondary = infoMap.getNextSecondaryToPopulate();
                                if (currentSecondary != null) break block14;
                                this.logger.info("Completed populating secondary database(s)");
                                TxnUtil.abort(txn);
                                return;
                            }
                            try {
                                this.logger.log(Level.FINE, "Started populating {0}", currentSecondary);
lbl19:
                                // 2 sources

                                info = infoMap.getSecondaryInfo(currentSecondary);
                                if (!PopulateThread.$assertionsDisabled && info == null) {
                                    throw new AssertionError();
                                }
                                if (!PopulateThread.$assertionsDisabled && !info.needsPopulating()) {
                                    throw new AssertionError();
                                }
                                if (info.getCurrentPartition() == null) {
                                    for (PartitionId partition : this.repNode.getPartitions()) {
                                        if (info.isCompleted(partition)) continue;
                                        info.setCurrentPartition(partition);
                                        break;
                                    }
                                }
                                db = this.tableManager.getSecondaryDb(currentSecondary);
                                if (info.getCurrentPartition() != null) break block15;
                                this.logger.log(Level.FINE, "Finished populating {0} {1}", new Object[]{currentSecondary, info});
                                if (!PopulateThread.$assertionsDisabled && db == null) {
                                    throw new AssertionError();
                                }
                                db.endIncrementalPopulation();
                                info.donePopulation();
                                infoMap.persist(infoDb, txn);
                                txn.commit();
                                txn = null;
                                currentSecondary = null;
                            }
                            catch (Throwable var11_11) {
                                TxnUtil.abort(txn);
                                throw var11_11;
                            }
                            TxnUtil.abort(txn);
                            continue;
                        }
                        if (db != null) break block16;
                        this.logger.log(Level.WARNING, "Failed to populate {0}, secondary database {1} is missing", new Object[]{info, currentSecondary});
                        TxnUtil.abort(txn);
                        return;
                    }
                    this.logger.log(Level.FINE, "Populating {0} {1}", new Object[]{currentSecondary, info});
                    tableName = TableManager.getTableName(db.getDatabaseName());
                    table = this.tableManager.getTable(tableName);
                    if (table != null) break block17;
                    this.logger.log(Level.WARNING, "Failed to populate {0}, missing table {1}", new Object[]{info, tableName});
                    TxnUtil.abort(txn);
                    return;
                }
                more = this.populate(table, oh, txn, info.getCurrentPartition(), info.getLastKey(), db);
                if (!more) {
                    this.logger.log(Level.FINE, "Finished partition for {0}", info);
                    info.completeCurrentPartition();
                }
                infoMap.persist(infoDb, txn);
                txn.commit();
                txn = null;
                TxnUtil.abort(txn);
            }
        }

        private boolean populate(Table table, OperationHandler oh, Transaction txn, PartitionId partitionId, DatabaseEntry lastKey, SecondaryDatabase db) {
            byte[] resumeKey = lastKey.getData();
            PrimaryKey pkey = table.createPrimaryKey();
            TableKey tkey = TableKey.createKey(table, pkey, true);
            TargetTables targetTables = new TargetTables(table, null, null);
            TableIterateInternal iterate = new TableIterateInternal(tkey.getKeyBytes(), targetTables, tkey.getMajorKeyComplete(), resumeKey);
            Result result = iterate.execute(txn, partitionId, oh);
            boolean hasMoreElements = result.hasMoreElements();
            List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
            DatabaseEntry data = new DatabaseEntry();
            for (ResultKeyValueVersion kvv : byteKeyResults) {
                lastKey.setData(kvv.getKeyBytes());
                data.setData(kvv.getValueBytes());
                db.populateSecondaries(txn, lastKey, data);
            }
            return hasMoreElements;
        }
    }
}

