/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.param;

import com.sleepycat.persist.model.Persistent;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.kv.impl.param.DefaultParameter;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.param.ParameterState;

@Persistent(version=1)
public class ParameterMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String eol = System.getProperty("line.separator");
    private static final String INDENT = "  ";
    private static final String PROPINDENT = "    ";
    private String name;
    private String type;
    private boolean validate;
    private final int version;
    private final HashMap<String, Parameter> parameters = new HashMap();
    private static final Parameter nullParameter = new NullParameter();

    public ParameterMap() {
        this(null, null, true, 1);
    }

    public ParameterMap(String name, String type) {
        this(name, type, true, 1);
    }

    public ParameterMap(String name, String type, boolean validate, int version) {
        this.name = name;
        this.type = type;
        this.validate = validate;
        this.version = version;
    }

    public Collection<Parameter> values() {
        return this.parameters.values();
    }

    public Set<Map.Entry<String, Parameter>> entrySet() {
        return this.parameters.entrySet();
    }

    public Set<String> keys() {
        return this.parameters.keySet();
    }

    public int size() {
        return this.parameters.size();
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValidate(boolean value) {
        this.validate = value;
    }

    public ParameterMap copy() {
        ParameterMap newParams = new ParameterMap(this.name, this.type, this.validate, this.version);
        newParams.parameters.putAll(this.parameters);
        return newParams;
    }

    public ParameterMap filter(EnumSet<ParameterState.Info> set) {
        ParameterMap newParams = new ParameterMap(this.name, this.type, this.validate, this.version);
        for (Parameter p : this.values()) {
            ParameterState pstate = ParameterState.lookup(p.getName());
            if (pstate == null || !pstate.containsAll(set)) continue;
            newParams.put(p);
        }
        return newParams;
    }

    public ParameterMap filter(Set<String> set, boolean positive) {
        ParameterMap newParams = new ParameterMap(this.name, this.type, this.validate, this.version);
        for (Parameter p : this.values()) {
            if (ParameterState.lookup(p.getName()) == null) continue;
            if (set.contains(p.getName())) {
                if (!positive) continue;
                newParams.put(p);
                continue;
            }
            if (positive) continue;
            newParams.put(p);
        }
        return newParams;
    }

    public ParameterMap readOnlyFilter() {
        ParameterMap newParams = new ParameterMap(this.name, this.type, this.validate, this.version);
        for (Parameter p : this.values()) {
            ParameterState pstate = ParameterState.lookup(p.getName());
            if (pstate == null || pstate.getReadOnly()) continue;
            newParams.put(p);
        }
        return newParams;
    }

    public ParameterMap filter(ParameterState.Scope scope) {
        ParameterMap newParams = new ParameterMap(this.name, this.type, this.validate, this.version);
        for (Parameter p : this.values()) {
            ParameterState pstate = ParameterState.lookup(p.getName());
            if (pstate == null || pstate.getScope() != scope) continue;
            newParams.put(p);
        }
        return newParams;
    }

    public ParameterMap filter(ParameterState.Info info, boolean includeParamWithInfo) {
        ParameterMap newParams = new ParameterMap(this.name, this.type, this.validate, this.version);
        for (Parameter p : this.values()) {
            ParameterState pstate = ParameterState.lookup(p.getName());
            if (pstate == null || (!includeParamWithInfo || !pstate.appliesTo(info)) && (includeParamWithInfo || pstate.appliesTo(info))) continue;
            newParams.put(p);
        }
        return newParams;
    }

    public Parameter put(Parameter value) {
        return this.parameters.put(value.getName(), value);
    }

    public Parameter get(String pname) {
        Parameter p = this.parameters.get(pname);
        if (p != null) {
            return p;
        }
        return nullParameter;
    }

    public Parameter getOrDefault(String pname) {
        if (this.exists(pname)) {
            return this.get(pname);
        }
        return DefaultParameter.getDefaultParameter(pname);
    }

    public Parameter remove(String pname) {
        return this.parameters.remove(pname);
    }

    public int getOrZeroInt(String pname) {
        Parameter p = this.parameters.get(pname);
        if (p != null) {
            return p.asInt();
        }
        return 0;
    }

    public long getOrZeroLong(String pname) {
        Parameter p = this.parameters.get(pname);
        if (p != null) {
            return p.asLong();
        }
        return 0L;
    }

    public boolean exists(String pname) {
        Parameter p = this.parameters.get(pname);
        return p != null;
    }

    public void clear() {
        this.parameters.clear();
    }

    public boolean equals(ParameterMap other) {
        if (this.size() != other.size()) {
            return false;
        }
        for (Parameter p : this.parameters.values()) {
            if (p.equals(other.get(p.getName()))) continue;
            return false;
        }
        return true;
    }

    public int merge(ParameterMap other, boolean notReadOnly) {
        int numMerged = 0;
        for (Parameter p : other.values()) {
            ParameterState pstate;
            if (this.get(p.getName()).equals(p) || notReadOnly && (pstate = ParameterState.lookup(p.getName())).getReadOnly()) continue;
            this.put(p);
            ++numMerged;
        }
        return numMerged;
    }

    public boolean hasRestartRequiredDiff(ParameterMap other) {
        for (Parameter p : this.parameters.values()) {
            if (p.equals(other.get(p.getName())) || !p.restartRequired()) continue;
            return true;
        }
        return false;
    }

    public boolean hasRestartRequired() {
        for (Parameter p : this.parameters.values()) {
            if (!p.restartRequired()) continue;
            return true;
        }
        return false;
    }

    public ParameterMap diff(ParameterMap other, boolean notReadOnly) {
        ParameterMap map = new ParameterMap();
        for (Parameter p : other.values()) {
            ParameterState pstate;
            if (this.get(p.getName()).equals(p) || notReadOnly && (pstate = ParameterState.lookup(p.getName())).getReadOnly()) continue;
            map.put(p);
        }
        return map;
    }

    public void write(PrintWriter writer) {
        writer.printf("%s<component name=\"%s\" type=\"%s\" validate=\"%s\">\n", INDENT, this.name, this.type, Boolean.toString(this.validate));
        for (Parameter p : this.parameters.values()) {
            writer.printf("%s<property name=\"%s\" value=\"%s\" type=\"%s\"/>\n", PROPINDENT, p.getName(), p.asString(), p.getType().toString());
        }
        writer.printf("%s</component>\n", INDENT);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append("name=" + this.name);
        }
        if (this.type != null) {
            sb.append(" type=" + this.type);
        }
        sb.append(this.parameters.toString());
        return sb.toString();
    }

    public String showContents() {
        return this.showContents(false);
    }

    public String showContents(boolean sort) {
        if (!sort) {
            return this.parameters.toString();
        }
        StringBuilder sb = new StringBuilder();
        TreeSet<String> set = new TreeSet<String>(this.keys());
        boolean first = true;
        for (String s : set) {
            Parameter p = this.get(s);
            if (first) {
                first = false;
            } else {
                sb.append(eol);
            }
            sb.append(p.getName()).append("=").append(p);
        }
        return sb.toString();
    }

    public boolean setParameter(String name, String value) {
        return this.setParameter(name, value, false);
    }

    public boolean setParameter(String name, String value, boolean ignoreUnknown) {
        if (value == null) {
            return this.remove(name) != null;
        }
        Parameter p = null;
        p = this.validate ? Parameter.createParameter(name, value, ignoreUnknown) : Parameter.createParameter(name, value, ParameterState.Type.STRING);
        if (p != null) {
            this.put(p);
            return true;
        }
        return false;
    }

    public static ParameterMap createDefaultPolicyMap() {
        ParameterMap map = new ParameterMap();
        for (ParameterState ps : ParameterState.pstate.values()) {
            if (!ps.getPolicyState()) continue;
            map.put(DefaultParameter.getDefaultParameter(ps));
        }
        return map;
    }

    public void addServicePolicyDefaults(ParameterState.Info service) {
        EnumSet<ParameterState.Info> set = EnumSet.of(ParameterState.Info.POLICY, service);
        for (ParameterState ps : ParameterState.getMap().values()) {
            String defaultName;
            if (!ps.containsAll(set) || this.exists(defaultName = DefaultParameter.getDefaultParameter(ps).getName())) continue;
            this.put(DefaultParameter.getDefaultParameter(ps));
        }
    }

    private static class NullParameter
    extends Parameter {
        private static final long serialVersionUID = 1L;

        public NullParameter() {
            super("noname");
        }

        @Override
        public String asString() {
            return null;
        }

        @Override
        public ParameterState.Type getType() {
            return ParameterState.Type.NONE;
        }
    }
}

