/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor.views;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.measurement.ConciseStats;
import oracle.kv.impl.measurement.EnvStats;
import oracle.kv.impl.measurement.LatencyInfo;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.measurement.MeasurementType;
import oracle.kv.impl.measurement.PerfStatType;
import oracle.kv.impl.measurement.RepEnvStats;
import oracle.kv.impl.monitor.Metrics;
import oracle.kv.impl.monitor.MonitorKeeper;
import oracle.kv.impl.monitor.View;
import oracle.kv.impl.monitor.ViewListener;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.rep.monitor.StatsPacket;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.FormatUtils;
import oracle.kv.impl.util.server.LoggerUtils;

public class PerfView
implements View {
    private final MonitorKeeper admin;
    private final Set<ViewListener<PerfEvent>> listeners;
    private final Logger envStatLogger;

    public PerfView(AdminServiceParams params, MonitorKeeper admin) {
        this.admin = admin;
        this.listeners = new HashSet<ViewListener<PerfEvent>>();
        this.envStatLogger = LoggerUtils.getStatFileLogger(this.getClass(), params.getGlobalParams(), params.getStorageNodeParams());
    }

    @Override
    public String getName() {
        return "Performance Stats";
    }

    @Override
    public Set<MeasurementType> getTargetMetricTypes() {
        return Collections.singleton(Metrics.RNSTATS);
    }

    @Override
    public void applyNewInfo(ResourceId resourceId, Measurement m) {
        List<ConciseStats> otherStats;
        EnvStats envStats;
        StatsPacket statsPacket = (StatsPacket)m;
        LatencyInfo singleInterval = statsPacket.get(PerfStatType.USER_SINGLE_OP_INT);
        LatencyInfo singleCumulative = statsPacket.get(PerfStatType.USER_SINGLE_OP_CUM);
        LatencyInfo multiInterval = statsPacket.get(PerfStatType.USER_MULTI_OP_INT);
        LatencyInfo multiCumulative = statsPacket.get(PerfStatType.USER_MULTI_OP_CUM);
        RepEnvStats repStats = statsPacket.getRepEnvStats();
        if (singleInterval.getLatency().getTotalOps() != 0 || multiInterval.getLatency().getTotalOps() != 0 || PerfEvent.commitLagThresholdExceeded(repStats, 1L)) {
            PerfEvent event = new PerfEvent(resourceId, singleInterval, singleCumulative, this.admin.getLatencyCeiling(resourceId), this.admin.getThroughputFloor(resourceId), this.admin.getCommitLagThreshold(resourceId), multiInterval, multiCumulative, repStats);
            for (ViewListener<PerfEvent> listener : this.listeners) {
                listener.newInfo(resourceId, event);
            }
        }
        if ((envStats = statsPacket.getEnvStats()) != null) {
            this.envStatLogger.info(this.displayConciseStats(resourceId, statsPacket.getStart(), statsPacket.getEnd(), envStats));
        }
        if (repStats != null) {
            this.envStatLogger.info(this.displayConciseStats(resourceId, statsPacket.getStart(), statsPacket.getEnd(), repStats));
        }
        if ((otherStats = statsPacket.getOtherStats()) != null) {
            for (ConciseStats stats : otherStats) {
                this.envStatLogger.info(this.displayConciseStats(resourceId, statsPacket.getStart(), statsPacket.getEnd(), stats));
            }
        }
    }

    public synchronized void addListener(ViewListener<PerfEvent> l) {
        this.listeners.add(l);
    }

    public synchronized void removeListener(ViewListener<PerfEvent> l) {
        this.listeners.remove(l);
    }

    @Override
    public void close() {
    }

    private String displayConciseStats(ResourceId resourceId, long start, long end, ConciseStats stats) {
        StringBuilder sb = new StringBuilder();
        sb.append(resourceId + " (" + FormatUtils.formatTime(start) + " -> " + FormatUtils.formatTime(end) + ")\n");
        sb.append(stats.getFormattedStats());
        return sb.toString();
    }
}

