/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.metadata;

import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataHolder;
import oracle.kv.impl.metadata.MetadataInfo;

public class MetadataStore {
    private MetadataStore() {
    }

    public static <T extends Metadata<? extends MetadataInfo>> T read(Class<T> returnType, Metadata.MetadataType type, EntityStore store, Transaction txn) {
        MetadataHolder holder = (MetadataHolder)MetadataStore.openIndex(store).get(txn, (Object)type.getKey(), LockMode.READ_UNCOMMITTED);
        return (T)((Metadata)returnType.cast(holder == null ? null : holder.getMetadata()));
    }

    public static void save(Metadata<? extends MetadataInfo> md, EntityStore store, Transaction txn) {
        MetadataStore.openIndex(store).put(txn, (Object)new MetadataHolder(md));
    }

    private static PrimaryIndex<String, MetadataHolder> openIndex(EntityStore store) {
        assert (store != null);
        return store.getPrimaryIndex(String.class, MetadataHolder.class);
    }
}

