/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.io.File;
import oracle.kv.impl.diagnostic.SNAInfo;

public class RemoteFile {
    private File file;
    private SNAInfo snaInfo;

    public RemoteFile(File file, SNAInfo snaInfo) {
        this.file = file;
        this.snaInfo = snaInfo;
    }

    public File getLocalFile() {
        return this.file;
    }

    public SNAInfo getSNAInfo() {
        return this.snaInfo;
    }

    public String toString() {
        return this.snaInfo.getIP().getHostName() + ":" + (this.snaInfo.getRemoteRootdir() == null ? "" : this.snaInfo.getRemoteRootdir()) + ":" + this.file.getName();
    }

    private String getRemotePath() {
        return this.snaInfo.getRemoteRootdir() + ":" + this.file.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteFile)) {
            return false;
        }
        RemoteFile remoteFile = (RemoteFile)obj;
        return this.snaInfo.getIP().equals(remoteFile.snaInfo.getIP()) && this.getRemotePath().equals(remoteFile.getRemotePath());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getRemotePath() == null ? 0 : this.getRemotePath().hashCode());
        result = 31 * result + (this.snaInfo.getIP() == null ? 0 : this.snaInfo.getIP().hashCode());
        result = 31 * result + (this.file.getName() == null ? 0 : this.file.getName().hashCode());
        return result;
    }
}

