/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.diagnostic.DiagnosticConfigFile;
import oracle.kv.impl.diagnostic.DiagnosticSSHRunnable;
import oracle.kv.impl.diagnostic.DiagnosticTask;
import oracle.kv.impl.diagnostic.SNAInfo;
import oracle.kv.impl.diagnostic.ssh.SSHClient;
import oracle.kv.impl.diagnostic.ssh.SSHClientManager;
import oracle.kv.util.shell.ShellInputReader;

public abstract class DiagnosticSSHTask
extends DiagnosticTask {
    private List<SNAInfo> snaInfoList;
    private Map<SNAInfo, SSHClient> clientMap = new ConcurrentHashMap<SNAInfo, SSHClient>();
    private DiagnosticConfigFile configFile;
    private final String sshUser;

    public DiagnosticSSHTask(String configdir, String sshUser) throws Exception {
        this.configFile = new DiagnosticConfigFile(configdir);
        this.snaInfoList = this.configFile.getAllSNAInfo();
        this.sshUser = sshUser;
        this.setTotalSubTaskCount(this.snaInfoList.size());
        this.openClient();
    }

    public abstract DiagnosticSSHRunnable getSSHRunnable(SNAInfo var1, SSHClient var2, List<SNAInfo> var3);

    private void openClient() throws Exception {
        boolean isRewrite = false;
        ShellInputReader inputReader = new ShellInputReader(System.in, System.out);
        for (SNAInfo snaInfo : this.snaInfoList) {
            if (this.sshUser != null) {
                snaInfo.setUser(this.sshUser);
                isRewrite = true;
                continue;
            }
            if (snaInfo.getUser() != null && !snaInfo.getUser().equals("")) continue;
            String user = inputReader.readLine("Enter user to ssh to [" + snaInfo.getSNAInfo() + "]: ");
            snaInfo.setUser(user);
            isRewrite = true;
        }
        this.clientMap = SSHClientManager.getClient(this.snaInfoList);
        if (isRewrite) {
            ArrayList<SNAInfo> rewrittenList = new ArrayList<SNAInfo>();
            for (Map.Entry<SNAInfo, SSHClient> entry : this.clientMap.entrySet()) {
                SNAInfo snaInfo = entry.getKey();
                SSHClient client = entry.getValue();
                if (!client.isOpen()) {
                    snaInfo.setUser(null);
                }
                rewrittenList.add(snaInfo);
            }
            this.configFile.rewrite(rewrittenList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doWork() throws Exception {
        ArrayList list = new ArrayList();
        int numberSSHThread = this.getTotalSubTaskCount();
        ThreadPoolExecutor threadExecutor = new ThreadPoolExecutor(numberSSHThread, numberSSHThread, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            for (SNAInfo sNAInfo : this.snaInfoList) {
                SSHClient client = this.clientMap.get(sNAInfo);
                DiagnosticSSHRunnable SSHRunnable = this.getSSHRunnable(sNAInfo, client, this.snaInfoList);
                list.add(threadExecutor.submit(SSHRunnable));
            }
            for (Future future : list) {
                future.get();
            }
        }
        finally {
            threadExecutor.shutdown();
        }
    }
}

