/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import oracle.kv.impl.diagnostic.DiagnosticTask;
import oracle.kv.impl.diagnostic.SNAInfo;
import oracle.kv.impl.diagnostic.ssh.SSHClient;

public abstract class DiagnosticSSHRunnable
implements Runnable {
    private String NEW_LINE_TAB = "\n\t";
    protected SNAInfo snaInfo;
    protected SSHClient client;
    private final DiagnosticTask owner;

    public DiagnosticSSHRunnable(SNAInfo snaInfo, DiagnosticTask owner, SSHClient client) {
        this.snaInfo = snaInfo;
        this.owner = owner;
        this.client = client;
    }

    @Override
    public void run() {
        String message = this.snaInfo.getSNAInfo().trim();
        try {
            message = !this.client.isOpen() ? message + this.NEW_LINE_TAB + this.client.getErrorMessage() : message + this.NEW_LINE_TAB + this.doWork();
        }
        catch (Exception e) {
            message = this.snaInfo.getSNAInfo() + this.NEW_LINE_TAB + e;
        }
        this.owner.notifyCompleteSubTask(message.trim());
    }

    public abstract String doWork() throws Exception;
}

