/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.kv.impl.diagnostic.DiagnosticConfigFile;
import oracle.kv.impl.diagnostic.DiagnosticSSHRunnable;
import oracle.kv.impl.diagnostic.DiagnosticSSHTask;
import oracle.kv.impl.diagnostic.DiagnosticTask;
import oracle.kv.impl.diagnostic.DiagnosticTaskManager;
import oracle.kv.impl.diagnostic.LogFileInfo;
import oracle.kv.impl.diagnostic.LogInfo;
import oracle.kv.impl.diagnostic.LogSectionFileInfo;
import oracle.kv.impl.diagnostic.ParametersValidator;
import oracle.kv.impl.diagnostic.SNAInfo;
import oracle.kv.impl.diagnostic.execution.MasterLogExtractor;
import oracle.kv.impl.diagnostic.execution.SecurityEventExtractor;
import oracle.kv.impl.diagnostic.ssh.SSHClient;
import oracle.kv.impl.diagnostic.util.TopologyDetector;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellUsageException;

public class DiagnosticCollectCommand
extends CommandWithSubs {
    private static final String DEFAULT_WORK_DIR = System.getProperty("user.dir");
    private static final String COMMAND_NAME = "collect";
    private static final String LOGFILE_COMMAND_NAME = "-logfiles";
    private static final String NOT_FOUND_ROOT_MESSAGE = "Cannot find root directory: ";
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new DiagnosticCollectLogSub());

    public DiagnosticCollectCommand() {
        super(subs, COMMAND_NAME, 4, 0);
    }

    @Override
    protected String getCommandOverview() {
        return "The Collect command copies and packages NoSQL DB informational log " + eol + "files to a central " + "location for troubleshooting. Log files can be " + eol + "compressed before copying.A sn-target-list file must exist " + "and can be" + eol + "created with diagnostics setup or " + "diagnostics collect -logfiles -host <name>" + eol + "-port <number>";
    }

    static class DiagnosticCollectLogSub
    extends CommandWithSubs.SubCommand {
        final String HOST_FLAG = "-host";
        final String PORT_FLAG = "-port";
        final String SSH_USER_FLAG = "-sshusername";
        final String USER_FLAG = "-username";
        final String SECURITY_FLAG = "-security";
        final String CONFIG_DIRECTORY_FLAG = "-configdir";
        final String SAVE_DIRECTORY_FLAG = "-savedir";
        final String NO_COMPRESS_FLAG = "-nocompress";
        final String CONFIG_FILE_NAME_STRING = "configuration file";
        final String NOCONNECT_FLAG = "-noconnect";
        final String CONFIG_FILE_NAME = "sn-target-list";
        final String LOG_FILE_NAME_PREFIX = "logs_";
        final String TIMESTAMP_FORMAT = "yyyy-MM-dd-HH.mm.ss";
        String hostname = null;
        int port = -1;
        String sshUser = null;
        String user = null;
        String securityFile = null;
        String savedir = null;
        String configdir = null;
        boolean isCompress = true;
        String saveLogDir = null;
        private List<File> resultDirList = new CopyOnWriteArrayList<File>();
        private List<LogSectionFileInfo> logFileInfoList = new CopyOnWriteArrayList<LogSectionFileInfo>();
        private List<String> securityEventFileList = new CopyOnWriteArrayList<String>();

        DiagnosticCollectLogSub() {
            super(DiagnosticCollectCommand.LOGFILE_COMMAND_NAME, 8);
        }

        @Override
        protected String getCommandSyntax() {
            return "collect -logfiles" + eolt + "[" + "-host" + " <host name of a SN in topology>]" + eolt + "[" + "-port" + " <registry port of a SN in topology>]" + eolt + "[" + "-sshusername" + " <SSH username>]" + eolt + "[" + "-username" + " <store username>]" + eolt + "[" + "-security" + " <security-file-path>]" + eolt + "[" + "-configdir" + " <location of storage node target file>]" + eolt + "[" + "-savedir" + " <destination directory for log files>]" + eolt + "[" + "-nocompress" + " <if specified, copy log files without compressing>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Collect log files of all SNAs";
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            String retMsg;
            this.hostname = null;
            this.port = -1;
            this.sshUser = null;
            this.user = null;
            this.securityFile = null;
            this.savedir = null;
            this.configdir = null;
            this.isCompress = true;
            this.saveLogDir = null;
            Shell.checkHelp(args, this);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if ("-host".equals(arg)) {
                        this.hostname = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-port".equals(arg)) {
                        String sPort = Shell.nextArg(args, i++, this);
                        try {
                            this.port = Integer.valueOf(sPort);
                        }
                        catch (NumberFormatException nfe) {
                            shell.invalidArgument("-port", this);
                        }
                        if (this.port > 0) continue;
                        String info = "-port should be greater than 0";
                        throw new ShellUsageException(info, this);
                    }
                    if ("-sshusername".equals(arg)) {
                        this.sshUser = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-username".equals(arg)) {
                        this.user = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-security".equals(arg)) {
                        this.securityFile = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-savedir".equals(arg)) {
                        this.savedir = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-configdir".equals(arg)) {
                        this.configdir = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-nocompress".equals(arg)) {
                        this.isCompress = false;
                        continue;
                    }
                    shell.unknownArgument(args[i], this);
                }
            }
            if (this.port < 0) {
                if (this.hostname != null && !this.hostname.isEmpty()) {
                    shell.requiredArg("-port", this);
                }
            } else if (this.hostname == null || this.hostname.isEmpty()) {
                shell.requiredArg("-host", this);
            }
            if (this.configdir == null || this.configdir.isEmpty()) {
                this.configdir = DEFAULT_WORK_DIR;
            }
            if ((retMsg = ParametersValidator.checkDirectory("-configdir", this.configdir)) != null) {
                throw new ShellUsageException(retMsg, this);
            }
            if (this.savedir == null || this.savedir.isEmpty()) {
                this.savedir = DEFAULT_WORK_DIR;
            } else {
                retMsg = ParametersValidator.checkDirectory("-savedir", this.savedir);
                if (retMsg != null) {
                    throw new ShellUsageException(retMsg, this);
                }
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
            String dateStr = format.format(new Date());
            this.saveLogDir = this.savedir + File.separator + "logs_" + dateStr;
            this.collect(shell);
            return null;
        }

        private void setUserByHistory(SNAInfo snaInfo, List<SNAInfo> list) {
            for (SNAInfo si : list) {
                if (!si.getIP().equals(snaInfo.getIP())) continue;
                snaInfo.setUser(si.getUser());
            }
        }

        private void updateConfigurationFile(Shell shell) throws Exception {
            TopologyDetector detector = new TopologyDetector(this.hostname, this.port, this.user, this.securityFile);
            Topology topo = detector.getTopology();
            List<StorageNode> list = topo.getSortedStorageNodes();
            DiagnosticConfigFile configFile = new DiagnosticConfigFile(this.configdir);
            List<SNAInfo> historyList = configFile.getAllSNAInfo();
            configFile.clear();
            for (StorageNode sn : list) {
                StorageNodeId snId = sn.getStorageNodeId();
                String rootDir = detector.getRootDirPath(sn);
                if (rootDir != null) {
                    SNAInfo snaInfo = new SNAInfo(topo.getKVStoreName(), snId.getFullName(), sn.getHostname(), rootDir);
                    this.setUserByHistory(snaInfo, historyList);
                    if (this.sshUser != null) {
                        snaInfo.setUser(this.sshUser);
                    }
                    configFile.add(snaInfo);
                    continue;
                }
                shell.getOutput().println("Cannot get root directory path for " + snId.getFullName() + " on host " + sn.getHostname());
            }
        }

        private void collect(Shell shell) throws ShellUsageException {
            try {
                if (this.hostname != null) {
                    this.updateConfigurationFile(shell);
                }
            }
            catch (Exception ex) {
                if (ex.getMessage() != null && ex.getMessage().contains("Problem parsing")) {
                    throw new ShellUsageException(ex.getMessage(), this);
                }
                shell.getOutput().println("Updating configuration file failed: " + ex.getMessage());
            }
            try {
                DiagnosticConfigFile configFile = new DiagnosticConfigFile(this.configdir);
                configFile.verify();
            }
            catch (Exception ex) {
                throw new ShellUsageException(ex.getMessage(), this);
            }
            try {
                this.resultDirList.clear();
                DiagnosticTaskManager diagnosticTaskManager = new DiagnosticTaskManager(shell);
                DiagnosticSSHTask SSHtask = new DiagnosticSSHTask(this.configdir, this.sshUser){

                    @Override
                    public DiagnosticSSHRunnable getSSHRunnable(SNAInfo snaInfo, SSHClient client, List<SNAInfo> taskSNList) {
                        return new FileCopy(snaInfo, this, client);
                    }
                };
                AdminMasterLogMerge masterTask = new AdminMasterLogMerge();
                SecurityEventGenerate securityTask = new SecurityEventGenerate();
                diagnosticTaskManager.addTask(SSHtask);
                diagnosticTaskManager.addTask(masterTask);
                diagnosticTaskManager.addTask(securityTask);
                diagnosticTaskManager.execute();
            }
            catch (Exception ex) {
                throw new ShellUsageException(ex.toString(), this);
            }
        }

        private class FileCopy
        extends DiagnosticSSHRunnable {
            final String PREFIX_MESSAGE = "\n\tLog files copied to ";
            final String EMPTY_STRING = "";
            final String NEW_LINE_TAB = "\n\t";

            public FileCopy(SNAInfo snaInfo, DiagnosticTask threadOwner, SSHClient client) {
                super(snaInfo, threadOwner, client);
                this.PREFIX_MESSAGE = "\n\tLog files copied to ";
                this.EMPTY_STRING = "";
                this.NEW_LINE_TAB = "\n\t";
            }

            @Override
            public String doWork() throws Exception {
                String message = "";
                String retMsg = ParametersValidator.checkHostname("-host", this.snaInfo.getHost());
                if (retMsg != null) {
                    message = message + "\n\t" + retMsg;
                    return message;
                }
                if (!this.client.checkFile(this.snaInfo.getRootdir())) {
                    message = message + "\n\tCannot find root directory: " + this.snaInfo.getRootdir();
                }
                if (!message.equals("")) {
                    return message.trim();
                }
                File file = this.client.getLogFiles(this.snaInfo, DiagnosticCollectLogSub.this.saveLogDir, DiagnosticCollectLogSub.this.isCompress);
                DiagnosticCollectLogSub.this.resultDirList.add(file);
                message = message + "\n\tLog files copied to " + DiagnosticCollectLogSub.this.saveLogDir;
                return message.trim();
            }
        }

        private class SecurityEventGenerate
        extends DiagnosticTask {
            private String SECURITY_EVENT_FILE = "security_event.log";
            private String PREFIX_MESSAGE = "\nSecurity Event Log\n\t";
            private String NO_SECURITY_MESSAGE = "No security event found";
            private boolean hasSecurityEvent = true;

            private SecurityEventGenerate() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doWork() throws Exception {
                String message;
                DiagnosticCollectLogSub.this.securityEventFileList.clear();
                for (File file : DiagnosticCollectLogSub.this.resultDirList) {
                    SecurityEventExtractor extractor = new SecurityEventExtractor(file.getName());
                    extractor.execute(file.getAbsolutePath());
                    File resultFile = extractor.getResultFile();
                    if (resultFile == null) continue;
                    DiagnosticCollectLogSub.this.securityEventFileList.add(resultFile.getAbsolutePath());
                }
                if (DiagnosticCollectLogSub.this.securityEventFileList.size() == 0) {
                    this.notifyCompleteSubTask(this.PREFIX_MESSAGE + this.NO_SECURITY_MESSAGE);
                    return;
                }
                ArrayList<LogInfo> securityEventLogList = new ArrayList<LogInfo>();
                BufferedReader br = null;
                for (String filePath : DiagnosticCollectLogSub.this.securityEventFileList) {
                    File f = new File(filePath);
                    try {
                        String line;
                        br = new BufferedReader(new FileReader(f));
                        while ((line = br.readLine()) != null) {
                            securityEventLogList.add(new LogInfo(line));
                        }
                    }
                    finally {
                        if (br != null) {
                            br.close();
                        }
                    }
                    f.delete();
                }
                DiagnosticCollectLogSub.this.securityEventFileList.clear();
                Collections.sort(securityEventLogList, new LogInfo.LogInfoComparator());
                BufferedWriter bw = null;
                File file = new File(DiagnosticCollectLogSub.this.saveLogDir + File.separator + this.SECURITY_EVENT_FILE);
                try {
                    bw = new BufferedWriter(new FileWriter(file, true));
                    LogInfo currentLog = null;
                    if (securityEventLogList.isEmpty()) {
                        message = this.PREFIX_MESSAGE + this.NO_SECURITY_MESSAGE;
                        this.hasSecurityEvent = false;
                    } else {
                        for (LogInfo log : securityEventLogList) {
                            if (currentLog != null && currentLog.equals(log)) continue;
                            currentLog = log;
                            bw.write(log.toString());
                            bw.newLine();
                        }
                        message = this.PREFIX_MESSAGE + file.getAbsolutePath();
                    }
                }
                catch (Exception e) {
                    message = this.PREFIX_MESSAGE + e;
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                }
                if (!this.hasSecurityEvent) {
                    file.delete();
                }
                this.notifyCompleteSubTask(message);
            }
        }

        private class AdminMasterLogMerge
        extends DiagnosticTask {
            final String ADMIN_MASTER_LOG_FILE_NAME = "admin_master.log";
            final String PREFIX_MESSAGE = "\nAdmin Master Log\n\t";
            final String NO_MASTER_LOG = "No admin master log found";
            final String EMPTY_STRING = "";

            private AdminMasterLogMerge() {
            }

            @Override
            public void doWork() throws Exception {
                try {
                    DiagnosticCollectLogSub.this.logFileInfoList.clear();
                    for (File file : DiagnosticCollectLogSub.this.resultDirList) {
                        MasterLogExtractor extractor = new MasterLogExtractor(LogFileInfo.LogFileType.ADMIN, file.getName());
                        extractor.execute(file.getAbsolutePath());
                        List<LogSectionFileInfo> list = extractor.getLogSectionFileInfoList();
                        for (LogSectionFileInfo sectionList : list) {
                            DiagnosticCollectLogSub.this.logFileInfoList.add(sectionList);
                        }
                    }
                    if (DiagnosticCollectLogSub.this.logFileInfoList.size() > 0) {
                        this.mergeAdminMasterLog();
                    } else {
                        this.notifyCompleteSubTask("\nAdmin Master Log\n\tNo admin master log found");
                    }
                }
                catch (Exception ex) {
                    this.notifyCompleteSubTask("\nAdmin Master Log\n\t" + ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void mergeAdminMasterLog() throws IOException {
                String message;
                BufferedWriter bw = null;
                File file = new File(DiagnosticCollectLogSub.this.saveLogDir + File.separator + "admin_master.log");
                try {
                    bw = new BufferedWriter(new FileWriter(file, true));
                    this.mergeLog(bw);
                    message = "\nAdmin Master Log\n\t" + file.getAbsolutePath();
                }
                catch (Exception e) {
                    message = "\nAdmin Master Log\n\t" + e;
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                }
                this.notifyCompleteSubTask(message);
            }

            private void mergeLog(BufferedWriter bw) throws IOException {
                ArrayList<LogSectionFileInfo> emptyFileInfoList = new ArrayList<LogSectionFileInfo>();
                while (!DiagnosticCollectLogSub.this.logFileInfoList.isEmpty()) {
                    LogSectionFileInfo logSectionFileInfo = null;
                    for (LogSectionFileInfo fileInfo : DiagnosticCollectLogSub.this.logFileInfoList) {
                        Date comparedTimestamp;
                        if (fileInfo.isEmpty()) {
                            emptyFileInfoList.add(fileInfo);
                            DiagnosticCollectLogSub.this.logFileInfoList.remove(fileInfo);
                            break;
                        }
                        if (logSectionFileInfo == null) {
                            logSectionFileInfo = fileInfo;
                            continue;
                        }
                        Date selectTimestamp = logSectionFileInfo.getFirst().getTimestamp();
                        if (selectTimestamp.after(comparedTimestamp = fileInfo.getFirst().getTimestamp())) {
                            logSectionFileInfo = fileInfo;
                            continue;
                        }
                        if (!selectTimestamp.equals(comparedTimestamp)) continue;
                        fileInfo.pop();
                    }
                    if (logSectionFileInfo == null) continue;
                    String beginTimestamp = logSectionFileInfo.pop().getTimestampString();
                    String endTimestamp = "";
                    if (!logSectionFileInfo.isEmpty()) {
                        endTimestamp = logSectionFileInfo.getFirst().getTimestampString();
                    }
                    if (logSectionFileInfo.isEmpty()) {
                        DiagnosticCollectLogSub.this.logFileInfoList.remove(logSectionFileInfo);
                        emptyFileInfoList.add(logSectionFileInfo);
                    }
                    this.writeLog(bw, logSectionFileInfo.getFilePath(), beginTimestamp, endTimestamp);
                }
                for (LogSectionFileInfo fileInfo : emptyFileInfoList) {
                    File file = new File(fileInfo.getFilePath());
                    if (!file.exists()) continue;
                    file.delete();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeLog(BufferedWriter bw, String filePath, String beginTimestamp, String endTimestamp) throws IOException {
                File file = new File(filePath);
                BufferedReader br = null;
                boolean isWrite = false;
                try {
                    String line;
                    br = new BufferedReader(new FileReader(file));
                    while ((line = br.readLine()) != null) {
                        LogInfo logInfo = new LogInfo(line);
                        String timestampString = logInfo.getTimestampString();
                        if (timestampString != null && timestampString.equals(beginTimestamp)) {
                            isWrite = true;
                        }
                        if (timestampString != null && timestampString.equals(endTimestamp)) {
                            break;
                        }
                        if (!isWrite) continue;
                        bw.write(logInfo.toString());
                        bw.newLine();
                    }
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
        }
    }
}

