/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapDef;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordValue;
import org.apache.avro.Schema;
import org.apache.avro.util.Utf8;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
class MapValueImpl
extends ComplexValueImpl
implements MapValue {
    private static final long serialVersionUID = 1L;
    private final Map<String, FieldValue> fields;
    private static final StringDefImpl stringDef = new StringDefImpl();

    MapValueImpl(MapDef field) {
        super(field);
        this.fields = new TreeMap<String, FieldValue>(FieldComparator.instance);
    }

    private MapValueImpl() {
        super(null);
        this.fields = null;
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public FieldValue remove(String fieldName) {
        return this.fields.remove(fieldName);
    }

    @Override
    public FieldValue get(String fieldName) {
        return this.fields.get(fieldName);
    }

    @Override
    public MapValue put(String name, int value) {
        this.validate(name, FieldDef.Type.INTEGER);
        this.fields.put(name, this.getElement().createInteger(value));
        return this;
    }

    @Override
    public MapValue put(String name, long value) {
        this.validate(name, FieldDef.Type.LONG);
        this.fields.put(name, this.getElement().createLong(value));
        return this;
    }

    @Override
    public MapValue put(String name, String value) {
        this.validate(name, FieldDef.Type.STRING);
        this.fields.put(name, this.getElement().createString(value));
        return this;
    }

    @Override
    public MapValue put(String name, double value) {
        this.validate(name, FieldDef.Type.DOUBLE);
        this.fields.put(name, this.getElement().createDouble(value));
        return this;
    }

    @Override
    public MapValue put(String name, float value) {
        this.validate(name, FieldDef.Type.FLOAT);
        this.fields.put(name, this.getElement().createFloat(value));
        return this;
    }

    @Override
    public MapValue put(String name, boolean value) {
        this.validate(name, FieldDef.Type.BOOLEAN);
        this.fields.put(name, this.getElement().createBoolean(value));
        return this;
    }

    @Override
    public MapValue put(String name, byte[] value) {
        this.validate(name, FieldDef.Type.BINARY);
        this.fields.put(name, this.getElement().createBinary(value));
        return this;
    }

    @Override
    public MapValue putNull(String name) {
        this.fields.put(name, NullValueImpl.getInstance());
        return this;
    }

    @Override
    public MapValue putFixed(String name, byte[] value) {
        this.validate(name, FieldDef.Type.FIXED_BINARY);
        this.fields.put(name, this.getElement().createFixedBinary(value));
        return this;
    }

    @Override
    public MapValue putEnum(String name, String value) {
        this.validate(name, FieldDef.Type.ENUM);
        this.fields.put(name, this.getElement().createEnum(value));
        return this;
    }

    MapValue putEnum(String name, int index) {
        this.validate(name, FieldDef.Type.ENUM);
        this.fields.put(name, ((EnumDefImpl)this.getElement()).createEnum(index));
        return this;
    }

    @Override
    public MapValue put(String fieldName, FieldValue value) {
        if (!this.getElement().isType(value.getType())) {
            throw new IllegalArgumentException("Incorrect type for map");
        }
        this.validateIndexField(fieldName);
        this.fields.put(fieldName, value);
        return this;
    }

    @Override
    public RecordValueImpl putRecord(String fieldName) {
        this.validateIndexField(fieldName);
        RecordValue val = this.getElement().createRecord();
        this.fields.put(fieldName, val);
        return (RecordValueImpl)val;
    }

    @Override
    public MapValueImpl putMap(String fieldName) {
        this.validateIndexField(fieldName);
        MapValue val = this.getElement().createMap();
        this.fields.put(fieldName, val);
        return (MapValueImpl)val;
    }

    @Override
    public ArrayValueImpl putArray(String fieldName) {
        this.validateIndexField(fieldName);
        ArrayValue val = this.getElement().createArray();
        this.fields.put(fieldName, val);
        return (ArrayValueImpl)val;
    }

    @Override
    public MapDefImpl getDefinition() {
        return (MapDefImpl)super.getDefinition();
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.MAP;
    }

    @Override
    public MapValueImpl clone() {
        MapValueImpl map = new MapValueImpl(this.getDefinition());
        for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
            if (entry.getValue().isNull()) {
                map.putNull(entry.getKey());
                continue;
            }
            map.put(entry.getKey(), entry.getValue().clone());
        }
        return map;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public MapValue asMap() {
        return this;
    }

    public boolean equals(Object other) {
        if (other instanceof MapValueImpl) {
            MapValueImpl otherValue = (MapValueImpl)other;
            if (this == otherValue) {
                return true;
            }
            if (this.size() == otherValue.size() && this.getElement().equals(otherValue.getElement()) && this.getDefinition().equals(otherValue.getDefinition())) {
                for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
                    if (entry.getValue().equals(otherValue.get(entry.getKey()))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int code = this.size();
        for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
            code += entry.getKey().hashCode() + entry.getValue().hashCode();
        }
        return code;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof MapValueImpl) {
            MapValueImpl otherImpl = (MapValueImpl)other;
            if (!this.getDefinition().equals(otherImpl.getDefinition())) {
                throw new IllegalArgumentException("Cannot compare MapValues with different definitions");
            }
            assert (this.fields instanceof TreeMap);
            assert (otherImpl.fields instanceof TreeMap);
            Iterator<String> keyIter = this.fields.keySet().iterator();
            Iterator<String> otherIter = otherImpl.fields.keySet().iterator();
            while (keyIter.hasNext() && otherIter.hasNext()) {
                FieldValue otherVal;
                String otherKey;
                String key = keyIter.next();
                int keyCompare = key.compareTo(otherKey = otherIter.next());
                if (keyCompare != 0) {
                    return keyCompare;
                }
                FieldValue val = this.fields.get(key);
                int valCompare = val.compareTo(otherVal = otherImpl.fields.get(key));
                if (valCompare == 0) continue;
                return valCompare;
            }
            if (keyIter.hasNext()) {
                return 1;
            }
            if (otherIter.hasNext()) {
                return -1;
            }
            return 0;
        }
        throw new ClassCastException("Object is not a MapValue");
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
            node.put(entry.getKey(), ((FieldValueImpl)entry.getValue()).toJsonNode());
        }
        return node;
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append('{');
        int i = 0;
        for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
            String key = entry.getKey();
            FieldValueImpl val = (FieldValueImpl)entry.getValue();
            if (val == null) continue;
            if (i > 0) {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(key);
            sb.append('\"');
            sb.append(':');
            val.toStringBuilder(sb);
            ++i;
        }
        sb.append('}');
    }

    @Override
    public Map<String, FieldValue> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    Map<String, FieldValue> getFieldsInternal() {
        return this.fields;
    }

    String getMapKey() {
        Iterator<String> i$;
        Set<String> mapKeys = this.fields.keySet();
        if (mapKeys.size() == 1 && (i$ = mapKeys.iterator()).hasNext()) {
            String mapKey = i$.next();
            return mapKey;
        }
        if (mapKeys.size() == 2) {
            for (String keyVal : mapKeys) {
                if (MapDefImpl.isMapValueTag(keyVal)) continue;
                return keyVal;
            }
        }
        return null;
    }

    @Override
    Object toAvroValue(Schema schema) {
        Schema valueSchema = MapValueImpl.getValueSchema(schema);
        TreeMap<String, Object> newMap = new TreeMap<String, Object>(FieldComparator.instance);
        for (Map.Entry<String, FieldValue> entry : this.getFieldsInternal().entrySet()) {
            newMap.put(entry.getKey(), ((FieldValueImpl)entry.getValue()).toAvroValue(valueSchema));
        }
        return newMap;
    }

    private static Schema getValueSchema(Schema schema) {
        return MapValueImpl.getUnionSchema(schema, Schema.Type.MAP).getValueType();
    }

    static MapValueImpl fromAvroValue(FieldDef def, Object o, Schema schema) {
        Map avroMap = (Map)o;
        MapValueImpl map = new MapValueImpl((MapDef)def);
        for (Map.Entry entry : avroMap.entrySet()) {
            String key = ((Utf8)entry.getKey()).toString();
            map.put(key, FieldValueImpl.fromAvroValue(((MapDef)def).getElement(), entry.getValue(), MapValueImpl.getValueSchema(schema)));
        }
        return map;
    }

    @Override
    void addJsonFields(JsonParser jp, boolean isIndexKey, String currentFieldName, boolean exact) {
        try {
            FieldDef element = this.getElement();
            JsonToken t = jp.getCurrentToken();
            if (t == null) {
                return;
            }
            assert (t == JsonToken.START_OBJECT);
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String lower;
                String fieldname = jp.getCurrentName();
                JsonToken token = jp.nextToken();
                if (isIndexKey && (lower = fieldname.toLowerCase()).startsWith("elementof(")) {
                    MapValueImpl.validateElementOfString(lower, currentFieldName);
                    fieldname = "[]";
                }
                if (token == JsonToken.VALUE_NULL) {
                    if (isIndexKey) {
                        this.putNull(fieldname);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid null value in JSON input for field " + fieldname);
                }
                switch (element.getType()) {
                    case INTEGER: {
                        this.put(fieldname, jp.getIntValue());
                        break;
                    }
                    case LONG: {
                        this.put(fieldname, jp.getLongValue());
                        break;
                    }
                    case DOUBLE: {
                        this.put(fieldname, jp.getDoubleValue());
                        break;
                    }
                    case FLOAT: {
                        this.put(fieldname, jp.getFloatValue());
                        break;
                    }
                    case STRING: {
                        this.put(fieldname, jp.getText());
                        break;
                    }
                    case BINARY: {
                        this.put(fieldname, jp.getBinaryValue());
                        break;
                    }
                    case FIXED_BINARY: {
                        this.putFixed(fieldname, jp.getBinaryValue());
                        break;
                    }
                    case BOOLEAN: {
                        this.put(fieldname, jp.getBooleanValue());
                        break;
                    }
                    case ARRAY: {
                        ArrayValueImpl array = this.putArray(fieldname);
                        array.addJsonFields(jp, isIndexKey, null, exact);
                        break;
                    }
                    case MAP: {
                        MapValueImpl map = this.putMap(fieldname);
                        map.addJsonFields(jp, isIndexKey, null, exact);
                        break;
                    }
                    case RECORD: {
                        RecordValueImpl record = this.putRecord(fieldname);
                        record.addJsonFields(jp, isIndexKey, null, exact);
                        break;
                    }
                    case ENUM: {
                        this.putEnum(fieldname, jp.getText());
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
    }

    private static void validateElementOfString(String elementOfString, String currentFieldName) {
        if (currentFieldName != null && elementOfString.endsWith(currentFieldName.toLowerCase() + ")")) {
            return;
        }
        throw new IllegalArgumentException("Invalid use of elementof(mapFieldPath) when constructing an IndexKey from JSON.  The mapFieldPath must contain the path to a map field and there can be no text after the expression: " + elementOfString);
    }

    void clearMap() {
        this.fields.clear();
    }

    private FieldDef getElement() {
        return this.getDefinition().getElement();
    }

    private void validate(String name, FieldDef.Type type) {
        if (!this.getElement().isType(type)) {
            throw new IllegalArgumentException("Incorrect type for map");
        }
        this.validateIndexField(name);
    }

    @Override
    FieldValueImpl findFieldValue(ListIterator<String> fieldPath, int arrayIndex) {
        assert (fieldPath.hasNext());
        String next = fieldPath.next();
        if (MapDefImpl.isMapKeyTag(next)) {
            if (!(this.size() == 1 || this.size() == 2 && this.fields.containsKey("[]"))) {
                throw new IllegalArgumentException("Index keys for maps can contain only one entry");
            }
            for (String keyVal : this.fields.keySet()) {
                if (MapDefImpl.isMapValueTag(keyVal)) continue;
                return stringDef.createString(keyVal);
            }
            return null;
        }
        FieldValueImpl fv = (FieldValueImpl)this.get(next);
        if (fv == null || !fieldPath.hasNext()) {
            return fv;
        }
        return fv.findFieldValue(fieldPath, arrayIndex);
    }

    @Override
    FieldValueImpl findFieldValue(ListIterator<String> fieldPath, String mapKey) {
        FieldValueImpl fv;
        assert (fieldPath.hasNext());
        String next = fieldPath.next();
        if (MapDefImpl.isMapKeyTag(next)) {
            return stringDef.createString(mapKey);
        }
        if (MapDefImpl.isMapValueTag(next) && mapKey == null) {
            mapKey = next;
        }
        if ((fv = (FieldValueImpl)this.get(mapKey)) != null && fv.isNull()) {
            fv = null;
        }
        if (fv == null || !fieldPath.hasNext()) {
            return fv;
        }
        return fv.findFieldValue(fieldPath, mapKey);
    }

    @Override
    int numValues() {
        if (this.fields.isEmpty()) {
            return 1;
        }
        int num = 0;
        for (FieldValue v : this.fields.values()) {
            num += ((FieldValueImpl)v).numValues();
        }
        return num;
    }

    @Override
    FieldValueImpl putComplex(ListIterator<String> fieldPath, FieldDef.Type type, Object value) {
        FieldDefImpl def = (FieldDefImpl)this.getElement();
        String fname = fieldPath.next();
        if (MapDefImpl.isMapKeyTag(fname) && value instanceof StringValueImpl) {
            this.putNull(((StringValueImpl)value).toString());
            return this;
        }
        if (!fieldPath.hasNext()) {
            if (type != def.getType()) {
                throw new IllegalStateException("Incorrect type for map.  Expected " + (Object)((Object)def.getType()) + ", received " + (Object)((Object)type));
            }
            this.put(fname, def.createValue(type, value));
        } else {
            FieldValueImpl val = (FieldValueImpl)this.get(fname);
            if (val == null) {
                val = MapValueImpl.createComplexValue(def);
            }
            this.put(fname, val.putComplex(fieldPath, type, value));
        }
        return this;
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        throw new IllegalArgumentException("Type does not implement getMinimumValue: " + this.getClass().getName());
    }
}

