/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.util.Arrays;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.table.BinaryValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import org.codehaus.jackson.Base64Variants;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.BinaryNode;

@Persistent(version=1)
class BinaryValueImpl
extends FieldValueImpl
implements BinaryValue {
    private static final long serialVersionUID = 1L;
    private final byte[] value;

    BinaryValueImpl(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("Binary values cannot be null");
        }
        this.value = value;
    }

    private BinaryValueImpl() {
        this.value = null;
    }

    public static BinaryValueImpl create(byte[] value) {
        return new BinaryValueImpl(value);
    }

    @Override
    public byte[] get() {
        return this.value;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.BINARY;
    }

    @Override
    public BinaryValueImpl clone() {
        return new BinaryValueImpl(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof BinaryValueImpl) {
            return Arrays.equals(this.value, ((BinaryValueImpl)other).get());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public int compareTo(FieldValue otherValue) {
        return this.equals(otherValue) ? 0 : -1;
    }

    @Override
    public JsonNode toJsonNode() {
        return new BinaryNode(this.value);
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append(Base64Variants.getDefaultVariant().encode(this.value, true));
    }

    @Override
    public BinaryValue asBinary() {
        return this;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public String toString() {
        return Base64Variants.getDefaultVariant().encode(this.value, false);
    }

    public static int compareUnsignedBytes(byte[] key1, int off1, int len1, byte[] key2, int off2, int len2) {
        int limit = Math.min(len1, len2);
        for (int i = 0; i < limit; ++i) {
            byte b1 = key1[i + off1];
            byte b2 = key2[i + off2];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return len1 - len2;
    }
}

