/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;

public class ResultIndexRows
extends ResultKeyValueVersion {
    private static final short RESULT_INDEX_ITERATE_VERSION = 6;
    private final byte[] indexKeyBytes;

    public ResultIndexRows(byte[] indexKeyBytes, byte[] primaryKeyBytes, byte[] valueBytes, Version version) {
        super(primaryKeyBytes, valueBytes, version);
        this.indexKeyBytes = indexKeyBytes;
    }

    public ResultIndexRows(ObjectInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        if (serialVersion >= 6) {
            short keyLen = in.readShort();
            this.indexKeyBytes = new byte[keyLen];
            in.readFully(this.indexKeyBytes);
        } else {
            this.indexKeyBytes = null;
        }
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 6) {
            out.writeShort(this.indexKeyBytes.length);
            out.write(this.indexKeyBytes);
        }
    }

    public byte[] getIndexKeyBytes() {
        return this.indexKeyBytes;
    }
}

