/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.lob.KVLargeObjectImpl;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.RequestValue;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ReturnResultValueVersion;
import oracle.kv.impl.api.ops.SingleKeyOperation;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.TablePrivilege;
import oracle.kv.impl.topo.PartitionId;

public class Put
extends SingleKeyOperation {
    private final RequestValue requestValue;
    private final ReturnValueVersion.Choice prevValChoice;
    private final long tableId;

    public Put(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice) {
        this(InternalOperation.OpCode.PUT, keyBytes, value, prevValChoice, 0L);
    }

    public Put(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, long tableId) {
        this(InternalOperation.OpCode.PUT, keyBytes, value, prevValChoice, tableId);
    }

    Put(InternalOperation.OpCode opCode, byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, long tableId) {
        super(opCode, keyBytes);
        this.requestValue = new RequestValue(value);
        this.prevValChoice = prevValChoice;
        this.tableId = tableId;
    }

    Put(ObjectInput in, short serialVersion) throws IOException {
        this(InternalOperation.OpCode.PUT, in, serialVersion);
    }

    Put(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.requestValue = new RequestValue(in, serialVersion);
        assert (this.requestValue.getBytes() != null);
        this.prevValChoice = ReturnValueVersion.getChoice(in.readUnsignedByte());
        this.tableId = serialVersion >= 4 ? in.readLong() : 0L;
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.requestValue.writeFastExternal(out, serialVersion);
        out.writeByte(this.prevValChoice.ordinal());
        if (serialVersion >= 4) {
            out.writeLong(this.tableId);
        } else if (this.tableId != 0L) {
            this.throwTablesRequired(serialVersion);
        }
    }

    public byte[] getValueBytes() {
        return this.requestValue.getBytes();
    }

    public ReturnValueVersion.Choice getReturnValueVersionChoice() {
        return this.prevValChoice;
    }

    long getTableId() {
        return this.tableId;
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        this.verifyDataAccess(operationHandler, this.getTableId());
        ReturnResultValueVersion prevVal = new ReturnResultValueVersion(this.prevValChoice);
        Version newVersion = operationHandler.put(txn, partitionId, this.getKeyBytes(), this.getValueBytes(), prevVal);
        return new Result.PutResult(this.getOpCode(), prevVal.getValueVersion(), newVersion);
    }

    @Override
    public byte[] checkLOBSuffix(byte[] lobSuffixBytes) {
        return KVLargeObjectImpl.hasLOBSuffix(this.getKeyBytes(), lobSuffixBytes) ? this.getKeyBytes() : null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.tableId != 0L) {
            sb.append(" Table Id ");
            sb.append(this.tableId);
        }
        sb.append(" Value: ");
        sb.append(this.requestValue);
        return sb.toString();
    }

    @Override
    List<? extends KVStorePrivilege> schemaAccessPrivileges() {
        return SystemPrivilege.schemaWritePrivList;
    }

    @Override
    List<? extends KVStorePrivilege> generalAccessPrivileges() {
        return SystemPrivilege.writeOnlyPrivList;
    }

    @Override
    public List<? extends KVStorePrivilege> tableAccessPrivileges(long tableId1) {
        return Collections.singletonList(new TablePrivilege.InsertTable(tableId1));
    }
}

