/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.topo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.param.StorageNodePool;
import oracle.kv.impl.admin.topo.Rules;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.admin.topo.Validations;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.TopologyPrinter;
import oracle.kv.impl.util.server.LoggerUtils;

public class TopologyBuilder {
    private final Topology sourceTopo;
    private final String candidateName;
    private final StorageNodePool snPool;
    private final int numPartitions;
    private final Parameters params;
    private final Logger logger;

    public TopologyBuilder(Topology sourceTopo, String candidateName, StorageNodePool snPool, int numPartitions, Parameters params, AdminServiceParams adminParams) {
        this(sourceTopo, candidateName, snPool, numPartitions, params, adminParams, true);
        if (sourceTopo.getPartitionMap().size() > 0 && sourceTopo.getPartitionMap().size() != numPartitions) {
            throw new IllegalCommandException("The number of partitions cannot be changed.");
        }
    }

    private TopologyBuilder(Topology sourceTopo, String candidateName, StorageNodePool snPool, int numPartitions, Parameters params, AdminServiceParams adminParams, boolean isInitial) {
        this.sourceTopo = sourceTopo;
        this.candidateName = candidateName;
        this.snPool = snPool;
        this.numPartitions = numPartitions;
        this.params = params;
        this.logger = LoggerUtils.getLogger(this.getClass(), adminParams);
        if (snPool.size() < 1) {
            throw new IllegalCommandException("Storage pool " + snPool.getName() + " must not be empty");
        }
        this.checkSNs();
        int totalCapacity = 0;
        int totalRF = 0;
        boolean foundPrimaryDC = false;
        HashSet<DatacenterId> dcs = new HashSet<DatacenterId>();
        for (StorageNodeId snId : snPool) {
            StorageNodeParams snp = params.get(snId);
            totalCapacity += snp.getCapacity();
            DatacenterId dcId = sourceTopo.get(snId).getDatacenterId();
            if (!dcs.add(dcId)) continue;
            totalRF += sourceTopo.get(dcId).getRepFactor();
            Datacenter dc = sourceTopo.get(dcId);
            if (!dc.getDatacenterType().isPrimary()) continue;
            foundPrimaryDC = true;
        }
        if (!foundPrimaryDC) {
            throw new IllegalCommandException("Storage pool " + snPool.getName() + " must contain SNs in a primary zone");
        }
        int minPartitions = totalCapacity / totalRF;
        if (numPartitions < minPartitions) {
            if (isInitial) {
                throw new IllegalCommandException("The number of partitions requested (" + numPartitions + ") is too small.  There must be at least as many" + " partitions as the total SN capacity in the storage node" + " pool (" + totalCapacity + ") divided by the total" + " replication factor (" + totalRF + "), which is " + minPartitions + ".");
            }
            if (numPartitions == 0) {
                throw new IllegalCommandException("topology create must be run before any other topology commands.");
            }
            throw new IllegalCommandException("The number of partitions (" + numPartitions + ") cannot be smaller than the total SN capacity in the" + " storage node pool (" + totalCapacity + ") divided by the total replication factor (" + totalRF + "), which is " + minPartitions + ".");
        }
    }

    public TopologyBuilder(TopologyCandidate origCandidate, StorageNodePool snPool, Parameters params, AdminServiceParams adminParams) {
        this(origCandidate.getTopology(), origCandidate.getName(), snPool, origCandidate.getTopology().getPartitionMap().size(), params, adminParams, false);
    }

    public TopologyCandidate rebalance(DatacenterId dcId) {
        return this.assignMountPoints(this.rebalance(new TopologyCandidate(this.candidateName, this.sourceTopo.getCopy()), dcId));
    }

    private TopologyCandidate rebalance(TopologyCandidate startingPoint, final DatacenterId dcId) {
        if (dcId != null && startingPoint.getTopology().get(dcId) == null) {
            throw new IllegalCommandException(dcId + " is not a valid zone");
        }
        Rules.Results results = Rules.validate(startingPoint.getTopology(), this.params, false);
        List<Validations.RNProximity> proximity = results.find(Validations.RNProximity.class, new Rules.RulesProblemFilter<Validations.RNProximity>(){

            @Override
            public boolean match(Validations.RNProximity p) {
                return TopologyBuilder.this.filterByDC(dcId, p.getSNId());
            }
        });
        List<Validations.OverCapacity> overCap = results.find(Validations.OverCapacity.class, new Rules.RulesProblemFilter<Validations.OverCapacity>(){

            @Override
            public boolean match(Validations.OverCapacity p) {
                return TopologyBuilder.this.filterByDC(dcId, p.getSNId());
            }
        });
        List<Validations.InsufficientRNs> insufficient = results.find(Validations.InsufficientRNs.class, new Rules.RulesProblemFilter<Validations.InsufficientRNs>(){

            @Override
            public boolean match(Validations.InsufficientRNs p) {
                return dcId == null || dcId.equals(p.getDCId());
            }
        });
        if (proximity.isEmpty() && overCap.isEmpty() && insufficient.isEmpty()) {
            this.logger.info(startingPoint + " has nothing to rebalance");
            return startingPoint;
        }
        StoreDescriptor currentLayout = new StoreDescriptor(startingPoint.getTopology(), this.params, this.snPool);
        TopologyCandidate candidate = new TopologyCandidate(startingPoint.getName(), startingPoint.getTopology().getCopy());
        Topology candidateTopo = candidate.getTopology();
        this.logger.log(Level.FINE, "{0} has {1} RN proximity problems to fix", new Object[]{candidate, proximity.size()});
        for (Validations.RNProximity r : proximity) {
            int siblingCount = r.getRNList().size();
            this.moveRNs(candidateTopo, r.getSNId(), currentLayout, r.getRNList().subList(1, siblingCount));
        }
        this.logger.log(Level.FINE, "{0} has {1} over capacity problems to fix", new Object[]{candidate, overCap.size()});
        for (Validations.OverCapacity c : overCap) {
            int needToMove = c.getExcess();
            SNDescriptor owningSND = currentLayout.getSND(c.getSNId(), candidateTopo);
            this.moveRNs(candidateTopo, c.getSNId(), currentLayout, owningSND.getNRns(needToMove));
        }
        this.logger.log(Level.FINE, "{0} has {1} shards with insufficient rep factor", new Object[]{candidate, insufficient.size()});
        for (Validations.InsufficientRNs ir : insufficient) {
            this.addRNs(candidateTopo, ir.getDCId(), ir.getRGId(), currentLayout, ir.getNumNeeded());
        }
        return candidate;
    }

    public TopologyCandidate build() {
        this.logger.log(Level.FINE, "Build {0} using {1}, numPartitions={2}", new Object[]{this.candidateName, this.snPool.getName(), this.numPartitions});
        TopologyCandidate startingPoint = this.rebalance(new TopologyCandidate(this.candidateName, this.sourceTopo.getCopy()), null);
        Topology startingTopo = startingPoint.getTopology();
        TopologyCandidate candidate = null;
        try {
            int currentShards = startingTopo.getRepGroupMap().size();
            EmptyLayout ideal = new EmptyLayout(startingTopo, this.params, this.snPool);
            int maxShards = ideal.getMaxShards();
            if (currentShards == 0 && maxShards == 0) {
                throw new IllegalCommandException("It is not possible to create any shards for this initial topology with the available set of storage nodes. Please increase the number or capacity of storage nodes");
            }
            if (maxShards <= currentShards) {
                this.logger.info("Couldn't improve topology. Store can only support " + maxShards + " shards." + "\nShard calculation based on smallest " + "zone: " + ideal.showDatacenters());
                TopologyCandidate fixPartitions = new TopologyCandidate(this.candidateName, startingTopo.getCopy());
                this.redistributePartitions(fixPartitions);
                return this.assignMountPoints(fixPartitions);
            }
            boolean success = false;
            for (int currentGoal = maxShards; currentGoal > currentShards; --currentGoal) {
                StoreDescriptor currentLayout;
                candidate = new TopologyCandidate(this.candidateName, startingTopo.getCopy());
                if (!this.layoutShardsAndRNs(candidate, currentLayout = new StoreDescriptor(startingTopo, this.params, this.snPool), currentGoal)) continue;
                success = true;
                break;
            }
            if (!success && candidate != null) {
                candidate.resetTopology(startingTopo.getCopy());
            }
            return this.assignMountPoints(candidate);
        }
        catch (RuntimeException e) {
            if (candidate == null) {
                this.logger.log(Level.INFO, "Topology build failed due to " + e);
            } else {
                this.logger.log(Level.INFO, "Topology build failed due to {0}\n{1}", new Object[]{e, candidate.showAudit()});
            }
            throw e;
        }
    }

    public TopologyCandidate changeRepfactor(int newRepFactor, DatacenterId dcId) {
        Datacenter dc = this.sourceTopo.get(dcId);
        if (dc == null) {
            throw new IllegalCommandException(dcId + " is not a valid zone");
        }
        if (dc.getRepFactor() > newRepFactor) {
            throw new IllegalCommandException("The proposed replication factor of " + newRepFactor + " is less than the current replication factor of " + dc.getRepFactor() + " for " + dc + ". Oracle NoSQL Database doesn't yet " + " support the ability to reduce replication factor");
        }
        Rules.validateReplicationFactor(newRepFactor);
        TopologyCandidate startingPoint = new TopologyCandidate(this.candidateName, this.sourceTopo.getCopy());
        if (dc.getRepFactor() != newRepFactor) {
            startingPoint.getTopology().update(dcId, Datacenter.newInstance(dc.getName(), newRepFactor, dc.getDatacenterType()));
        }
        return this.assignMountPoints(this.rebalance(startingPoint, dcId));
    }

    public TopologyCandidate relocateRN(RepNodeId rnId, StorageNodeId proposedSNId) {
        List<SNDescriptor> possibleSNDs;
        Topology topo = this.sourceTopo.getCopy();
        RepNode rn = topo.get(rnId);
        if (rn == null) {
            throw new IllegalCommandException(rnId + " does not exist");
        }
        StorageNodeId oldSNId = rn.getStorageNodeId();
        StoreDescriptor currentLayout = new StoreDescriptor(topo, this.params, this.snPool);
        SNDescriptor owningSND = currentLayout.getSND(oldSNId, topo);
        DatacenterId dcId = currentLayout.getOwningDCId(oldSNId, topo);
        if (proposedSNId == null) {
            possibleSNDs = currentLayout.getAllSNDs(dcId);
        } else {
            StorageNode proposedSN = topo.get(proposedSNId);
            if (proposedSN == null) {
                throw new IllegalCommandException("Proposed target SN " + proposedSNId + " does not exist");
            }
            if (!dcId.equals(proposedSN.getDatacenterId())) {
                throw new IllegalCommandException("Can't move " + rnId + " to " + proposedSN + " because it is in a different zone");
            }
            possibleSNDs = new ArrayList<SNDescriptor>();
            possibleSNDs.add(currentLayout.getSND(proposedSNId, topo));
        }
        for (SNDescriptor snd : possibleSNDs) {
            if (snd.getId().equals(oldSNId)) continue;
            this.logger.log(Level.FINEST, "Trying to move {0} to {1}", new Object[]{rn, snd});
            if (!snd.canAdd(rnId)) continue;
            snd.claim(rnId, owningSND);
            this.changeSNForRN(topo, rnId, snd.getId());
            break;
        }
        return this.assignMountPoints(new TopologyCandidate(this.candidateName, topo));
    }

    private boolean filterByDC(DatacenterId filterDCId, StorageNodeId snId) {
        if (filterDCId == null) {
            return true;
        }
        return this.sourceTopo.get(snId).getDatacenterId().equals(filterDCId);
    }

    private void checkSNs() {
        for (StorageNodeId snId : this.snPool.getList()) {
            if (this.params.get(snId) == null) {
                throw new IllegalCommandException("Storage Node " + snId + " does not exist. " + "Please remove " + "it from " + this.snPool.getName());
            }
            if (this.sourceTopo.get(snId) != null) continue;
            throw new IllegalCommandException("Topology candidate " + this.candidateName + " does not know about " + snId + " which is a member of storage node pool " + this.snPool.getName() + ". Please use a different storage node pool or " + "re-clone your candidate using the command " + "topology clone -current -name <candidateName>");
        }
        HashSet<StorageNodeId> missing = new HashSet<StorageNodeId>();
        for (RepNode rn : this.sourceTopo.getSortedRepNodes()) {
            missing.add(rn.getStorageNodeId());
        }
        HashSet<StorageNodeId> inPool = new HashSet<StorageNodeId>(this.snPool.getList());
        missing.removeAll(inPool);
        if (missing.size() > 0) {
            throw new IllegalCommandException("The storage pool provided for topology candidate " + this.candidateName + " must contain the following SNs which are already in use " + "in the current topology: " + missing);
        }
    }

    private boolean layoutShardsAndRNs(TopologyCandidate candidate, StoreDescriptor currentLayout, int desiredMaxShards) {
        Topology candidateTopo = candidate.getTopology();
        ArrayList<SNDescriptor> fullSNs = new ArrayList<SNDescriptor>();
        int highestExistingShardId = currentLayout.getHighestShardId();
        int numNewShards = desiredMaxShards - candidateTopo.getRepGroupMap().size();
        ArrayList<RepGroup> newShards = new ArrayList<RepGroup>(numNewShards);
        for (int i = 1; i <= numNewShards; ++i) {
            int shardNumber = highestExistingShardId + i;
            RepGroup repGroup = new RepGroup();
            newShards.add(repGroup);
            candidateTopo.add(repGroup);
            int previousDcReplicas = 0;
            for (DCDescriptor dcDesc : currentLayout.getDCDesc()) {
                int repFactor = dcDesc.getRepFactor();
                SNLoopIterator snIter = new SNLoopIterator(new LinkedList<SNDescriptor>(dcDesc.getSortedSNs()));
                List<SNDescriptor> snTargets = this.layoutOneShard(candidate, previousDcReplicas, dcDesc, shardNumber, fullSNs, snIter, true);
                if (snTargets.size() != repFactor) {
                    return false;
                }
                for (int rn = 0; rn < repFactor; ++rn) {
                    repGroup.add(new RepNode(snTargets.get(rn).getId()));
                }
                previousDcReplicas += repFactor;
            }
            candidate.log("added shard " + repGroup.getResourceId());
        }
        int existingPartitions = candidateTopo.getPartitionMap().size();
        if (existingPartitions == 0) {
            int min = this.numPartitions / numNewShards;
            int numXtraLarge = this.numPartitions - min * numNewShards;
            for (int whichShard = 0; whichShard < numNewShards; ++whichShard) {
                int end = whichShard < numXtraLarge ? min + 1 : min;
                for (int numP = 0; numP < end; ++numP) {
                    Partition p = new Partition((RepGroup)newShards.get(whichShard));
                    candidateTopo.add(p);
                }
            }
        } else {
            this.redistributePartitions(candidate);
        }
        return true;
    }

    private void redistributePartitions(TopologyCandidate candidate) {
        ShardDescriptor source;
        ShardDescriptor target;
        Topology candidateTopo = candidate.getTopology();
        int totalPartitions = candidateTopo.getPartitionMap().size();
        int totalShards = candidateTopo.getRepGroupMap().size();
        if (totalShards == 0 || totalPartitions == 0) {
            return;
        }
        int minPartitionsPerShard = Rules.calcMinPartitions(totalPartitions, totalShards);
        int maxPartitionsPerShard = Rules.calcMaxPartitions(totalPartitions, totalShards);
        this.logger.fine("TotalNumPartitions=" + totalPartitions + " total shards=" + totalShards + " minPartsPerShard=" + minPartitionsPerShard + " maxPartsPerShard=" + maxPartitionsPerShard);
        HashMap<RepGroupId, ShardDescriptor> shards = new HashMap<RepGroupId, ShardDescriptor>();
        for (RepGroupId rgId : candidateTopo.getRepGroupIds()) {
            shards.put(rgId, new ShardDescriptor(rgId));
        }
        for (Partition p : candidateTopo.getPartitionMap().getAll()) {
            ((ShardDescriptor)shards.get(p.getRepGroupId())).addPartition((PartitionId)p.getResourceId());
        }
        TreeSet<ShardDescriptor> tooFew = new TreeSet<ShardDescriptor>();
        TreeSet<ShardDescriptor> tooMany = new TreeSet<ShardDescriptor>();
        ArrayList<ShardDescriptor> hasMax = new ArrayList<ShardDescriptor>();
        ArrayList<ShardDescriptor> hasMin = new ArrayList<ShardDescriptor>();
        for (ShardDescriptor desc : shards.values()) {
            int nParts = desc.getNumPartitions();
            if (nParts < minPartitionsPerShard) {
                tooFew.add(desc);
                continue;
            }
            if (nParts > maxPartitionsPerShard) {
                tooMany.add(desc);
                continue;
            }
            if (nParts == maxPartitionsPerShard) {
                hasMax.add(desc);
                continue;
            }
            hasMin.add(desc);
        }
        while (!tooMany.isEmpty()) {
            target = (ShardDescriptor)tooFew.pollFirst();
            if (target == null) {
                if (hasMin.isEmpty()) break;
                target = (ShardDescriptor)hasMin.get(0);
                hasMin.remove(0);
            }
            source = (ShardDescriptor)tooMany.pollLast();
            PartitionId moveTarget = source.removePartition();
            target.addPartition(moveTarget);
            if (source.getNumPartitions() > maxPartitionsPerShard) {
                tooMany.add(source);
            } else if (source.getNumPartitions() == maxPartitionsPerShard) {
                hasMax.add(source);
            }
            if (target.getNumPartitions() < minPartitionsPerShard) {
                tooFew.add(target);
            } else if (target.getNumPartitions() == minPartitionsPerShard) {
                hasMin.add(target);
            }
            candidateTopo.update(moveTarget, new Partition(target.rgId));
        }
        if (!tooMany.isEmpty()) {
            throw new OperationFaultException("Unexpected state found when redistributing partitions for " + this.candidateName + ". After first processing pass, shards " + tooMany + " have more than " + maxPartitionsPerShard + " partitions. Candidate looks like " + TopologyPrinter.printTopology(candidateTopo, null, true));
        }
        while (!tooFew.isEmpty() && (target = (ShardDescriptor)tooFew.pollFirst()) != null && !hasMax.isEmpty()) {
            source = (ShardDescriptor)hasMax.get(0);
            hasMax.remove(0);
            PartitionId moveTarget = source.removePartition();
            target.addPartition(moveTarget);
            if (target.getNumPartitions() < minPartitionsPerShard) {
                tooFew.add(target);
            }
            candidateTopo.update(moveTarget, new Partition(target.rgId));
        }
    }

    private List<SNDescriptor> layoutOneShard(TopologyCandidate candidate, int existingReplicas, DCDescriptor dcDesc, int shardNumber, List<SNDescriptor> fullSNs, SNLoopIterator availableSNs, boolean updateTopology) {
        int repFactor = dcDesc.getRepFactor();
        ArrayList<SNDescriptor> snsForShard = new ArrayList<SNDescriptor>();
        candidate.log("laying out shard " + shardNumber + ", " + availableSNs.size() + " SNs in pool");
        for (int i = 1; i <= repFactor; ++i) {
            boolean snFound = false;
            StorageNodeId startingSN = null;
            RepNodeId rId = new RepNodeId(shardNumber, existingReplicas + i);
            while (availableSNs.hasNext()) {
                SNDescriptor snDesc = availableSNs.next();
                if (snDesc.isFull()) {
                    fullSNs.add(snDesc);
                    availableSNs.remove();
                    candidate.log(" remove " + snDesc + " from available list");
                    continue;
                }
                this.logger.log(Level.FINEST, "Trying to add RN {0} for shard {1} to {2}", new Object[]{rId, shardNumber, snDesc});
                if (startingSN == null) {
                    startingSN = snDesc.getId();
                } else if (startingSN.equals(snDesc.getId())) break;
                if (!snDesc.canAdd(rId)) continue;
                snDesc.add(rId);
                snsForShard.add(snDesc);
                snFound = true;
                break;
            }
            if (snFound) continue;
            if (!availableSNs.hasNext()) break;
            candidate.log("Problem placing " + rId + " trying swap");
            List<SNDescriptor> hasRoom = availableSNs.getList();
            DatacenterId dcId = dcDesc.getDatacenterId();
            for (SNDescriptor fullSND : fullSNs) {
                if (!dcId.equals(fullSND.getStorageNode().getDatacenterId()) || !this.swapRNToEmptySlot(fullSND, hasRoom, rId, candidate, updateTopology)) continue;
                snsForShard.add(fullSND);
                snFound = true;
                break;
            }
            if (!snFound) break;
        }
        if (snsForShard.size() == repFactor) {
            candidate.log("shard " + shardNumber + " successfully assigned to " + snsForShard);
        } else {
            candidate.log("shard " + shardNumber + " incompletely assigned to " + snsForShard);
        }
        return snsForShard;
    }

    private boolean swapRNToEmptySlot(SNDescriptor fullSND, List<SNDescriptor> availableSNDs, RepNodeId targetRN, TopologyCandidate candidate, boolean updateTopology) {
        if (!fullSND.canAddIgnoreCapacity(targetRN)) {
            return false;
        }
        for (RepNodeId target : fullSND.getRNs()) {
            for (SNDescriptor sndWithRoom : availableSNDs) {
                if (!sndWithRoom.canAdd(target)) continue;
                candidate.log("Swap: " + targetRN + " goes to " + fullSND + ", " + target + " goes to " + sndWithRoom);
                sndWithRoom.claim(target, fullSND);
                if (updateTopology) {
                    this.changeSNForRN(candidate.getTopology(), target, sndWithRoom.getId());
                }
                fullSND.add(targetRN);
                return true;
            }
        }
        return false;
    }

    private boolean moveRNs(Topology topo, StorageNodeId currentSNId, StoreDescriptor currentLayout, List<RepNodeId> moveTargets) {
        SNDescriptor owningSND = currentLayout.getSND(currentSNId, topo);
        DatacenterId dcId = currentLayout.getOwningDCId(currentSNId, topo);
        List<SNDescriptor> possibleSNDs = currentLayout.getAllSNDs(dcId);
        int moved = 0;
        block0: for (RepNodeId rnToMove : moveTargets) {
            for (SNDescriptor snd : possibleSNDs) {
                this.logger.log(Level.FINEST, "Trying to move {0} to {1}", new Object[]{rnToMove, snd});
                if (!snd.canAdd(rnToMove)) continue;
                snd.claim(rnToMove, owningSND);
                this.changeSNForRN(topo, rnToMove, snd.getId());
                ++moved;
                continue block0;
            }
        }
        return moved == moveTargets.size();
    }

    private void changeSNForRN(Topology topo, RepNodeId rnToMove, StorageNodeId snId) {
        this.logger.finest("Swapped " + rnToMove + " to " + snId);
        RepNode updatedRN = new RepNode(snId);
        RepGroupId rgId = topo.get(rnToMove).getRepGroupId();
        RepGroup rg = topo.get(rgId);
        rg.update(rnToMove, updatedRN);
    }

    private void addOneRN(Topology topo, SNDescriptor snd, RepGroupId rgId) {
        RepNode newRN = new RepNode(snd.getId());
        RepNode added = topo.get(rgId).add(newRN);
        snd.add((RepNodeId)added.getResourceId());
    }

    private void moveAnyRNAway(Topology topo, StoreDescriptor currentLayout, SNDescriptor snd) {
        for (RepNodeId rnId : snd.getRNs()) {
            ArrayList<RepNodeId> moveList = new ArrayList<RepNodeId>();
            moveList.add(rnId);
            if (!this.moveRNs(topo, snd.getId(), currentLayout, moveList)) continue;
            return;
        }
    }

    private void addRNs(Topology topo, DatacenterId dcId, RepGroupId rgId, StoreDescriptor currentLayout, int numNeeded) {
        List<SNDescriptor> possibleSNDs = currentLayout.getAllSNDs(dcId);
        int fixed = 0;
        for (int i = 0; i < numNeeded; ++i) {
            boolean success = false;
            for (SNDescriptor snd : possibleSNDs) {
                this.logger.log(Level.FINEST, "Trying add an RN to {0} on {1}", new Object[]{rgId, snd});
                if (!snd.canAdd(rgId)) continue;
                this.addOneRN(topo, snd, rgId);
                ++fixed;
                success = true;
                break;
            }
            if (!success) break;
        }
        int remaining = numNeeded - fixed;
        for (int i = 0; i < remaining; ++i) {
            boolean success = false;
            for (SNDescriptor snd : possibleSNDs) {
                if (snd.hosts(rgId)) continue;
                this.moveAnyRNAway(topo, currentLayout, snd);
                if (!snd.canAdd(rgId)) continue;
                this.addOneRN(topo, snd, rgId);
                ++fixed;
                success = true;
                break;
            }
            if (!success) break;
        }
    }

    private TopologyCandidate assignMountPoints(TopologyCandidate candidate) {
        Topology candTopo = candidate.getTopology();
        ArrayList<RepNode> needsMountPoint = new ArrayList<RepNode>();
        HashMap<StorageNodeId, Set<String>> usedMountPoints = new HashMap<StorageNodeId, Set<String>>();
        for (RepNode rn : candTopo.getSortedRepNodes()) {
            RepNodeId rnId = (RepNodeId)rn.getResourceId();
            StorageNodeId snId = rn.getStorageNodeId();
            RepNodeParams rnp = this.params.get(rnId);
            if (rnp == null) {
                needsMountPoint.add(rn);
                continue;
            }
            if (!rnp.getStorageNodeId().equals(snId)) {
                needsMountPoint.add(rn);
                continue;
            }
            if (rnp.getMountPointString() == null) continue;
            Set<String> used = this.getUsedSet(snId, usedMountPoints);
            used.add(rnp.getMountPointString());
            candidate.saveMountPoint(rnId, rnp.getMountPointString());
        }
        block1: for (RepNode rn : needsMountPoint) {
            StorageNodeId snId = rn.getStorageNodeId();
            StorageNodeParams snp = this.params.get(snId);
            if (snp.getMountPoints() == null) continue;
            Set<String> used = this.getUsedSet(snId, usedMountPoints);
            for (String possibleMountPoint : snp.getMountPoints()) {
                if (used.contains(possibleMountPoint)) continue;
                used.add(possibleMountPoint);
                candidate.saveMountPoint((RepNodeId)rn.getResourceId(), possibleMountPoint);
                continue block1;
            }
        }
        HashMap<String, RepNodeId> mountPointToRN = new HashMap<String, RepNodeId>();
        for (RepNode rn : candTopo.getSortedRepNodes()) {
            RepNodeId rnId = (RepNodeId)rn.getResourceId();
            StorageNodeId snId = rn.getStorageNodeId();
            String assignedMP = candidate.getMountPoint(rnId);
            if (assignedMP == null) continue;
            String key = snId + assignedMP;
            RepNodeId clashingRN = (RepNodeId)mountPointToRN.get(key);
            if (clashingRN == null) {
                mountPointToRN.put(key, rnId);
                continue;
            }
            throw new OperationFaultException("Topology candidate " + candidate.getName() + " is invalid because " + clashingRN + " and " + rnId + " are both assigned to " + snId + ", mount point " + assignedMP);
        }
        Rules.checkAllMountPointsExist(candidate, this.params);
        return candidate;
    }

    private Set<String> getUsedSet(StorageNodeId snId, Map<StorageNodeId, Set<String>> usedMap) {
        Set<String> used = usedMap.get(snId);
        if (used == null) {
            used = new HashSet<String>();
            usedMap.put(snId, used);
        }
        return used;
    }

    private class SNDescriptor {
        private final StorageNode sn;
        private final StorageNodeParams snp;
        private Set<RepNodeId> assignedRNs;

        SNDescriptor(StorageNode sn, StorageNodeParams snp) {
            this.sn = sn;
            this.snp = snp;
            this.assignedRNs = new HashSet<RepNodeId>();
        }

        public boolean hosts(RepGroupId rgId) {
            for (RepNodeId rnId : this.assignedRNs) {
                if (rnId.getGroupId() != rgId.getGroupId()) continue;
                return true;
            }
            return false;
        }

        private boolean canAdd(RepNodeId rId) {
            return Rules.checkRNPlacement(this.snp, this.assignedRNs, rId.getGroupId(), false, TopologyBuilder.this.logger);
        }

        private boolean canAdd(RepGroupId rgId) {
            return Rules.checkRNPlacement(this.snp, this.assignedRNs, rgId.getGroupId(), false, TopologyBuilder.this.logger);
        }

        private boolean canAddIgnoreCapacity(RepNodeId rId) {
            return Rules.checkRNPlacement(this.snp, this.assignedRNs, rId.getGroupId(), true, TopologyBuilder.this.logger);
        }

        private boolean isFull() {
            return this.assignedRNs.size() >= this.snp.getCapacity();
        }

        private void add(RepNodeId rId) {
            this.assignedRNs.add(rId);
        }

        StorageNode getStorageNode() {
            return this.sn;
        }

        StorageNodeId getId() {
            return this.sn.getStorageNodeId();
        }

        void clearAssignedRNs() {
            this.assignedRNs = new HashSet<RepNodeId>();
        }

        void claim(RepNodeId rnId, SNDescriptor owner) {
            owner.assignedRNs.remove(rnId);
            this.assignedRNs.add(rnId);
            TopologyBuilder.this.logger.log(Level.FINE, "Moved {0} from {1} to {2}", new Object[]{rnId, owner, this});
        }

        List<RepNodeId> getNRns(int numRequested) {
            if (numRequested > this.assignedRNs.size()) {
                throw new IllegalStateException("Requesting too many RNs (" + numRequested + ") during topology building:" + this);
            }
            ArrayList<RepNodeId> rnList = new ArrayList<RepNodeId>(this.assignedRNs);
            return rnList.subList(0, numRequested);
        }

        Set<RepNodeId> getRNs() {
            return this.assignedRNs;
        }

        public String toString() {
            return this.sn.getResourceId() + " hosted RNs=" + this.assignedRNs + " capacity= " + this.snp.getCapacity();
        }
    }

    private class DCDescriptor {
        private final DatacenterId dcId;
        private final int repFactor;
        private int numShards;
        private final Map<StorageNodeId, SNDescriptor> sns;

        DCDescriptor(DatacenterId dcId, int repFactor) {
            this.dcId = dcId;
            this.repFactor = repFactor;
            this.sns = new HashMap<StorageNodeId, SNDescriptor>();
        }

        List<SNDescriptor> getSortedSNs() {
            ArrayList<SNDescriptor> snList = new ArrayList<SNDescriptor>(this.sns.values());
            Collections.sort(snList, new Comparator<SNDescriptor>(){

                @Override
                public int compare(SNDescriptor snA, SNDescriptor snB) {
                    return snA.getId().getStorageNodeId() - snB.getId().getStorageNodeId();
                }
            });
            return snList;
        }

        DatacenterId getDatacenterId() {
            return this.dcId;
        }

        int getRepFactor() {
            return this.repFactor;
        }

        int getNumShards() {
            return this.numShards;
        }

        void add(StorageNode sn, StorageNodeParams snp) {
            this.sns.put((StorageNodeId)sn.getResourceId(), new SNDescriptor(sn, snp));
        }

        private void initSNDescriptors(Topology topo) {
            this.numShards = 0;
            if (topo == null) {
                return;
            }
            for (SNDescriptor snd : this.getSortedSNs()) {
                snd.clearAssignedRNs();
            }
            for (RepNode rn : topo.getSortedRepNodes()) {
                StorageNodeId snId = rn.getStorageNodeId();
                if (!this.dcId.equals(topo.get(snId).getDatacenterId())) continue;
                SNDescriptor snd = this.sns.get(snId);
                snd.add((RepNodeId)rn.getResourceId());
            }
            this.numShards = topo.getRepGroupMap().size();
        }

        void calculateMaxShards(TopologyCandidate candidate, int highestShardId) {
            List snsForShard;
            LinkedList<SNDescriptor> available = new LinkedList<SNDescriptor>(this.getSortedSNs());
            SNLoopIterator loopIter = new SNLoopIterator(available);
            ArrayList fullSNs = new ArrayList();
            candidate.log("calculating max number of shards");
            int wholeShards = 0;
            int shardNumber = highestShardId;
            while (loopIter.hasNext() && (snsForShard = TopologyBuilder.this.layoutOneShard(candidate, 0, this, ++shardNumber, fullSNs, loopIter, false)).size() >= this.repFactor) {
                ++wholeShards;
            }
            this.numShards += wholeShards;
        }

        SNDescriptor get(StorageNodeId snId) {
            return this.sns.get(snId);
        }
    }

    private class EmptyLayout {
        private final Map<DatacenterId, DCDescriptor> dcMap = new HashMap<DatacenterId, DCDescriptor>();
        private final int maxShards;

        EmptyLayout(Topology topo, Parameters params, StorageNodePool snPool) {
            for (StorageNodeId snId : snPool) {
                StorageNode sn = topo.get(snId);
                DatacenterId dcId = sn.getDatacenterId();
                DCDescriptor dcDesc = this.dcMap.get(dcId);
                if (dcDesc == null) {
                    int rf = topo.getDatacenter(snId).getRepFactor();
                    dcDesc = new DCDescriptor(dcId, rf);
                    this.dcMap.put(dcId, dcDesc);
                }
                dcDesc.add(sn, params.get(sn.getStorageNodeId()));
            }
            this.initClean();
            this.maxShards = this.calculateMaxShards(new TopologyCandidate("scratch", topo.getCopy()));
        }

        public String showDatacenters() {
            StringBuilder sb = new StringBuilder();
            for (DCDescriptor dcDesc : this.dcMap.values()) {
                sb.append("zn id=").append(dcDesc.getDatacenterId());
                sb.append(" maximum shards= ").append(dcDesc.getNumShards());
                sb.append('\n');
            }
            return sb.toString();
        }

        private int calculateMaxShards(TopologyCandidate candidate) {
            int calculatedMax = Integer.MAX_VALUE;
            for (Map.Entry<DatacenterId, DCDescriptor> entry : this.dcMap.entrySet()) {
                DCDescriptor dcDesc = entry.getValue();
                dcDesc.calculateMaxShards(candidate, 0);
                int dcMax = dcDesc.getNumShards();
                if (calculatedMax <= dcMax) continue;
                calculatedMax = dcMax;
            }
            return calculatedMax;
        }

        private void initClean() {
            for (DCDescriptor dcDesc : this.dcMap.values()) {
                dcDesc.initSNDescriptors(null);
            }
        }

        public int getMaxShards() {
            return this.maxShards;
        }
    }

    private class StoreDescriptor {
        private final Map<DatacenterId, DCDescriptor> dcMap = new HashMap<DatacenterId, DCDescriptor>();
        private final int highestShardId;
        private final Map<DatacenterId, List<SNDescriptor>> sndMap;

        StoreDescriptor(Topology topo, Parameters params, StorageNodePool snPool) {
            for (StorageNodeId storageNodeId : snPool) {
                StorageNode sn = topo.get(storageNodeId);
                DatacenterId dcId = sn.getDatacenterId();
                DCDescriptor dcDesc = this.dcMap.get(dcId);
                if (dcDesc == null) {
                    int rf = topo.getDatacenter(storageNodeId).getRepFactor();
                    dcDesc = new DCDescriptor(dcId, rf);
                    this.dcMap.put(dcId, dcDesc);
                }
                dcDesc.add(sn, params.get(sn.getStorageNodeId()));
            }
            this.sndMap = new HashMap<DatacenterId, List<SNDescriptor>>();
            for (Map.Entry entry : this.dcMap.entrySet()) {
                this.sndMap.put((DatacenterId)entry.getKey(), ((DCDescriptor)entry.getValue()).getSortedSNs());
            }
            for (DCDescriptor dCDescriptor : this.dcMap.values()) {
                dCDescriptor.initSNDescriptors(topo);
            }
            int findHighestShardId = 0;
            for (RepGroupId rgId : topo.getRepGroupIds()) {
                if (findHighestShardId >= rgId.getGroupId()) continue;
                findHighestShardId = rgId.getGroupId();
            }
            this.highestShardId = findHighestShardId;
        }

        public int getHighestShardId() {
            return this.highestShardId;
        }

        Collection<DCDescriptor> getDCDesc() {
            return this.dcMap.values();
        }

        List<SNDescriptor> getAllSNDs(DatacenterId dcId) {
            List<SNDescriptor> v = this.sndMap.get(dcId);
            return v != null ? v : Collections.emptyList();
        }

        DatacenterId getOwningDCId(StorageNodeId snId, Topology topo) {
            return topo.get(snId).getDatacenterId();
        }

        SNDescriptor getSND(StorageNodeId snId, Topology topo) {
            DatacenterId dcId = this.getOwningDCId(snId, topo);
            return this.dcMap.get(dcId).get(snId);
        }
    }

    private static class ShardDescriptor
    implements Comparable<ShardDescriptor> {
        private final RepGroupId rgId;
        private final List<PartitionId> partitions = new ArrayList<PartitionId>();

        ShardDescriptor(RepGroupId rgId) {
            this.rgId = rgId;
        }

        int getNumPartitions() {
            return this.partitions.size();
        }

        PartitionId removePartition() {
            return this.partitions.isEmpty() ? null : this.partitions.remove(0);
        }

        void addPartition(PartitionId partitionId) {
            this.partitions.add(partitionId);
        }

        @Override
        public int compareTo(ShardDescriptor gd) {
            if (this.equals(gd)) {
                return 0;
            }
            int diff = this.partitions.size() - gd.partitions.size();
            return diff == 0 ? 1 : diff;
        }

        public String toString() {
            return "ShardDescriptor[" + this.rgId + ", " + this.partitions.size() + "]";
        }
    }

    private class SNLoopIterator
    implements Iterator<SNDescriptor> {
        private final LinkedList<SNDescriptor> available;
        private Iterator<SNDescriptor> iter;

        SNLoopIterator(LinkedList<SNDescriptor> available) {
            this.available = available;
            this.iter = available.iterator();
        }

        public List<SNDescriptor> getList() {
            return new ArrayList<SNDescriptor>(this.available);
        }

        int size() {
            return this.available.size();
        }

        @Override
        public boolean hasNext() {
            return this.available.size() > 0;
        }

        @Override
        public SNDescriptor next() {
            if (!this.iter.hasNext()) {
                this.iter = this.available.iterator();
            }
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

