/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.plan.TopologyPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class RemoveDatacenter
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private DatacenterId targetId;
    private TopologyPlan plan;

    public RemoveDatacenter(TopologyPlan plan, DatacenterId targetId) {
        this.plan = plan;
        this.targetId = targetId;
    }

    private RemoveDatacenter() {
    }

    @Override
    public Task.State doWork() throws Exception {
        Topology currentTopo = this.plan.getTopology();
        currentTopo.remove(this.targetId);
        if (this.plan.isFirstExecutionAttempt()) {
            this.plan.getAdmin().saveTopoAndRemoveDatacenter(currentTopo, this.plan.getDeployedInfo(), this.targetId, this.plan);
        }
        if (!Utils.broadcastTopoChangesToRNs(this.plan.getLogger(), currentTopo, "remove zone [id=" + this.targetId + "]", this.plan.getAdmin().getParams().getAdminParams(), this.plan)) {
            return Task.State.INTERRUPTED;
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

