/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import java.util.HashSet;
import java.util.Set;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.AccessCheckUtils;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.KVStorePrivilegeLabel;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.TablePrivilege;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class PrivilegeTask
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private static final String ALLPRIVS = "ALL";
    final String roleName;
    final String tableName;
    final Set<KVStorePrivilege> privileges = new HashSet<KVStorePrivilege>();

    public PrivilegeTask(SecurityMetadataPlan.PrivilegePlan plan, String roleName, String tableName, Set<String> privNames) {
        super(plan);
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        this.roleName = roleName;
        this.tableName = tableName;
        if (secMd == null || secMd.getRole(roleName) == null) {
            throw new IllegalCommandException("Role with name " + roleName + " does not exist in store");
        }
        if (secMd.getRole(roleName).readonly()) {
            throw new IllegalCommandException("Cannot grant or revoke privileges to or from a read-only role: " + roleName);
        }
        this.parseToPrivileges(privNames);
    }

    void parseToPrivileges(Set<String> privNames) {
        if (this.tableName == null) {
            for (String privName : privNames) {
                if (ALLPRIVS.equalsIgnoreCase(privName)) {
                    this.privileges.addAll(SystemPrivilege.getAllSystemPrivileges());
                    return;
                }
                this.privileges.add(SystemPrivilege.get(KVStorePrivilegeLabel.valueOf(privName.toUpperCase())));
            }
            return;
        }
        TableMetadata tableMd = this.plan.getAdmin().getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
        if (tableMd == null || tableMd.getTable(this.tableName) == null) {
            throw new IllegalCommandException("Table with name " + this.tableName + " does not exist");
        }
        TableImpl table = tableMd.getTable(this.tableName);
        this.checkPermission(table);
        for (String privName : privNames) {
            if (ALLPRIVS.equalsIgnoreCase(privName)) {
                this.privileges.addAll(TablePrivilege.getAllTablePrivileges(table.getId(), table.getFullName()));
                return;
            }
            KVStorePrivilegeLabel privLabel = KVStorePrivilegeLabel.valueOf(privName.toUpperCase());
            this.privileges.add(TablePrivilege.get(privLabel, table.getId(), table.getFullName()));
        }
    }

    private void checkPermission(TableImpl table) {
        ExecutionContext execCtx = ExecutionContext.getCurrent();
        if (execCtx == null) {
            return;
        }
        if (!AccessCheckUtils.currentUserOwnsResource(table) && !execCtx.hasPrivilege(SystemPrivilege.SYSOPER)) {
            throw new UnauthorizedException("Insufficient privilege granted to grant or revoke privilege on non-owned tables.");
        }
    }
}

