/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.PlanLocksHeldException;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.plan.DeployTopoPlan;
import oracle.kv.impl.admin.plan.PlanExecutor;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.AbstractTask;
import oracle.kv.impl.admin.plan.task.JobWrapper;
import oracle.kv.impl.admin.plan.task.NextJob;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.server.LoggerUtils;
import oracle.kv.util.Ping;

@Persistent
public class MigratePartition
extends AbstractTask {
    private static final long serialVersionUID = 1L;
    private DeployTopoPlan plan;
    private RepGroupId sourceRGId;
    private RepGroupId targetRGId;
    private PartitionId partitionId;
    private transient RepNodeId targetRNId;

    public MigratePartition(DeployTopoPlan plan, RepGroupId sourceRGId, RepGroupId targetRGId, PartitionId partitionId) {
        this.plan = plan;
        this.sourceRGId = sourceRGId;
        this.targetRGId = targetRGId;
        this.partitionId = partitionId;
    }

    protected MigratePartition() {
    }

    private RepNodeAdminAPI getTarget() throws RemoteException, NotBoundException {
        Admin admin = this.plan.getAdmin();
        Topology topology = admin.getCurrentTopology();
        RepNode targetMasterRN = Ping.getMaster(topology, this.targetRGId);
        if (targetMasterRN == null) {
            this.targetRNId = null;
            return null;
        }
        this.targetRNId = (RepNodeId)targetMasterRN.getResourceId();
        LoginManager loginMgr = admin.getLoginManager();
        RegistryUtils registryUtils = new RegistryUtils(topology, loginMgr);
        return registryUtils.getRepNodeAdmin((RepNodeId)targetMasterRN.getResourceId());
    }

    private RepNodeAdminAPI getSource() throws RemoteException, NotBoundException {
        Admin admin = this.plan.getAdmin();
        Topology topology = admin.getCurrentTopology();
        RepNode masterRN = Ping.getMaster(topology, this.sourceRGId);
        if (masterRN == null) {
            return null;
        }
        LoginManager loginMgr = admin.getLoginManager();
        RegistryUtils registryUtils = new RegistryUtils(topology, loginMgr);
        return registryUtils.getRepNodeAdmin((RepNodeId)masterRN.getResourceId());
    }

    @Override
    public Callable<Task.State> getFirstJob(int taskId, PlanExecutor.ParallelTaskRunner runner) {
        return this.makeRequestMigrationJob(taskId, runner);
    }

    private NextJob requestMigration(int taskId, PlanExecutor.ParallelTaskRunner runner) {
        AdminParams ap = this.plan.getAdmin().getParams().getAdminParams();
        RepNodeAdminAPI target = null;
        try {
            target = this.getTarget();
            if (target == null) {
                return new NextJob(Task.State.RUNNING, this.makeRequestMigrationJob(taskId, runner), ap.getRNFailoverPeriod());
            }
            this.plan.getLogger().log(Level.INFO, "{0}: target={1} migration submitted", new Object[]{this.partitionId, this.targetRNId});
            RepNodeAdmin.PartitionMigrationState mState = target.migratePartition(this.partitionId, this.sourceRGId);
            return this.checkMigrationState(target, mState, taskId, runner, ap);
        }
        catch (RemoteException e) {
            return new NextJob(Task.State.RUNNING, this.makeRequestMigrationJob(taskId, runner), ap.getServiceUnreachablePeriod());
        }
        catch (NotBoundException e) {
            return new NextJob(Task.State.RUNNING, this.makeRequestMigrationJob(taskId, runner), ap.getServiceUnreachablePeriod());
        }
    }

    private JobWrapper makeRequestMigrationJob(int taskId, PlanExecutor.ParallelTaskRunner runner) {
        return new PartitionJob(taskId, runner, "request migration"){

            @Override
            public NextJob doJob() {
                return MigratePartition.this.requestMigration(this.taskId, this.runner);
            }
        };
    }

    private NextJob checkMigrationState(RepNodeAdminAPI target, RepNodeAdmin.PartitionMigrationState mState, int taskId, PlanExecutor.ParallelTaskRunner runner, AdminParams ap) {
        NextJob nextJob = null;
        String errorInfo = null;
        if (mState.getCause() != null) {
            errorInfo = LoggerUtils.getStackTrace(mState.getCause());
        }
        try {
            this.getMigrationDetails(target, mState, taskId, runner);
        }
        catch (Exception e) {
            this.plan.getLogger().log(Level.INFO, "{0}: target={1} source={2} migration state={3}  exception seen when getting detailed status: {4}", new Object[]{this.partitionId, this.targetRNId, this.sourceRGId, mState, LoggerUtils.getStackTrace(e)});
        }
        switch (mState) {
            case ERROR: {
                String additionalInfo = "target=" + this.targetRNId + " state=" + (Object)((Object)mState);
                if (errorInfo != null) {
                    additionalInfo = additionalInfo + " " + errorInfo;
                }
                nextJob = this.cancelMigration(taskId, runner, additionalInfo, ap);
                break;
            }
            case PENDING: 
            case RUNNING: {
                nextJob = new NextJob(Task.State.RUNNING, this.makeStatusQueryJob(taskId, runner, ap), ap.getCheckPartitionMigrationPeriod(), errorInfo);
                break;
            }
            case UNKNOWN: {
                nextJob = new NextJob(Task.State.RUNNING, this.makeStatusQueryJob(taskId, runner, ap), ap.getRNFailoverPeriod(), errorInfo);
                break;
            }
            case SUCCEEDED: {
                nextJob = this.updateTopoInAdminDB(taskId, runner);
            }
        }
        return nextJob;
    }

    private NextJob queryForStatus(int taskId, PlanExecutor.ParallelTaskRunner runner, AdminParams ap) {
        try {
            RepNodeAdminAPI target = this.getTarget();
            if (target == null) {
                return new NextJob(Task.State.RUNNING, this.makeStatusQueryJob(taskId, runner, ap), ap.getRNFailoverPeriod());
            }
            RepNodeAdmin.PartitionMigrationState mstate = target.getMigrationState(this.partitionId);
            this.plan.getLogger().log(Level.FINE, "{0}: target={1} migration state={2}", new Object[]{this.partitionId, this.targetRNId, mstate});
            return this.checkMigrationState(target, mstate, taskId, runner, ap);
        }
        catch (RemoteException e) {
            return new NextJob(Task.State.RUNNING, this.makeStatusQueryJob(taskId, runner, ap), ap.getServiceUnreachablePeriod());
        }
        catch (NotBoundException e) {
            return new NextJob(Task.State.RUNNING, this.makeStatusQueryJob(taskId, runner, ap), ap.getServiceUnreachablePeriod());
        }
    }

    private void getMigrationDetails(RepNodeAdminAPI target, RepNodeAdmin.PartitionMigrationState mState, int taskId, PlanExecutor.ParallelTaskRunner runner) throws RemoteException, NotBoundException {
        switch (mState) {
            case RUNNING: 
            case SUCCEEDED: {
                RepNodeAdminAPI source;
                PartitionMigrationStatus status = target.getMigrationStatus(this.partitionId);
                if (status != null) {
                    this.plan.addTaskDetails(runner.getDetails(taskId), status.toMap());
                }
                if ((source = this.getSource()) == null || (status = source.getMigrationStatus(this.partitionId)) == null) break;
                this.plan.addTaskDetails(runner.getDetails(taskId), status.toMap());
                break;
            }
            case ERROR: 
            case PENDING: {
                PartitionMigrationStatus status = target.getMigrationStatus(this.partitionId);
                if (status == null) break;
                this.plan.addTaskDetails(runner.getDetails(taskId), status.toMap());
                break;
            }
        }
    }

    private JobWrapper makeStatusQueryJob(int taskId, PlanExecutor.ParallelTaskRunner runner, final AdminParams ap) {
        return new PartitionJob(taskId, runner, "query migration status"){

            @Override
            public NextJob doJob() {
                return MigratePartition.this.queryForStatus(this.taskId, this.runner, ap);
            }
        };
    }

    private NextJob cancelMigration(int taskId, PlanExecutor.ParallelTaskRunner runner, String cancelReason, AdminParams ap) {
        try {
            RepNodeId sourceRNId;
            Admin admin = this.plan.getAdmin();
            Topology topology = admin.getCurrentTopology();
            RepNode sourceMasterRN = Ping.getMaster(topology, this.sourceRGId);
            if (sourceMasterRN == null) {
                return new NextJob(Task.State.RUNNING, this.makeCancelJob(taskId, runner, cancelReason, ap), ap.getRNFailoverPeriod());
            }
            LoginManager loginMgr = admin.getLoginManager();
            RegistryUtils registryUtils = new RegistryUtils(topology, loginMgr);
            RepNodeAdminAPI source = registryUtils.getRepNodeAdmin(sourceRNId = (RepNodeId)sourceMasterRN.getResourceId());
            if (source == null) {
                return new NextJob(Task.State.RUNNING, this.makeCancelJob(taskId, runner, cancelReason, ap), ap.getRNFailoverPeriod());
            }
            boolean done = source.canceled(this.partitionId, this.targetRGId);
            this.plan.getLogger().log(Level.INFO, "{0}: source={1} cancellation confirmation={2}", new Object[]{this.partitionId, sourceRNId, done});
            if (done) {
                return new NextJob(Task.State.ERROR, cancelReason);
            }
            return new NextJob(Task.State.RUNNING, this.makeCancelJob(taskId, runner, cancelReason, ap), ap.getCheckPartitionMigrationPeriod());
        }
        catch (RemoteException e) {
            return new NextJob(Task.State.RUNNING, this.makeCancelJob(taskId, runner, cancelReason, ap), ap.getServiceUnreachablePeriod());
        }
        catch (NotBoundException e) {
            return new NextJob(Task.State.RUNNING, this.makeCancelJob(taskId, runner, cancelReason, ap), ap.getServiceUnreachablePeriod());
        }
    }

    private JobWrapper makeCancelJob(int taskId, PlanExecutor.ParallelTaskRunner runner, final String cancelReason, final AdminParams ap) {
        return new PartitionJob(taskId, runner, "cancel migration"){

            @Override
            public NextJob doJob() {
                return MigratePartition.this.cancelMigration(this.taskId, this.runner, cancelReason, ap);
            }
        };
    }

    private NextJob updateTopoInAdminDB(int taskId, PlanExecutor.ParallelTaskRunner runner) {
        Admin admin = this.plan.getAdmin();
        try {
            if (!admin.updatePartition(this.partitionId, this.targetRGId, this.plan.getDeployedInfo(), this.plan)) {
                return NextJob.END_WITH_SUCCESS;
            }
            return this.broadcastTopo(admin, taskId, runner);
        }
        catch (Exception e) {
            AdminParams ap = admin.getParams().getAdminParams();
            return new NextJob(Task.State.RUNNING, this.makePersistToDBJob(taskId, runner), ap.getAdminFailoverPeriod());
        }
    }

    private JobWrapper makePersistToDBJob(int taskId, PlanExecutor.ParallelTaskRunner runner) {
        return new PartitionJob(taskId, runner, "update topo in admin db"){

            @Override
            public NextJob doJob() {
                return MigratePartition.this.updateTopoInAdminDB(this.taskId, this.runner);
            }
        };
    }

    private NextJob broadcastTopo(Admin admin, int taskId, PlanExecutor.ParallelTaskRunner runner) {
        try {
            if (!Utils.broadcastTopoChangesToRNs(this.plan.getLogger(), admin.getCurrentTopology(), this.toString(), admin.getParams().getAdminParams(), this.plan)) {
                return new NextJob(Task.State.INTERRUPTED, "task interrupted before new topology was sent to enough nodes");
            }
            return NextJob.END_WITH_SUCCESS;
        }
        catch (Exception e) {
            AdminParams ap = admin.getParams().getAdminParams();
            return new NextJob(Task.State.RUNNING, this.makeBroadcastJob(taskId, runner, admin), ap.getServiceUnreachablePeriod());
        }
    }

    private JobWrapper makeBroadcastJob(int taskId, PlanExecutor.ParallelTaskRunner runner, final Admin admin) {
        return new PartitionJob(taskId, runner, "broadcast topology"){

            @Override
            public NextJob doJob() {
                return MigratePartition.this.broadcastTopo(admin, this.taskId, this.runner);
            }
        };
    }

    @Override
    public boolean continuePastError() {
        return true;
    }

    @Override
    public String toString() {
        return this.getName() + " from " + this.sourceRGId + " to " + this.targetRGId;
    }

    @Override
    public String getName() {
        return super.getName() + " " + this.partitionId;
    }

    @Override
    public Runnable getCleanupJob() {
        return new Runnable(){

            @Override
            public void run() {
                RepNodeAdmin.PartitionMigrationState targetState = RepNodeAdmin.PartitionMigrationState.UNKNOWN;
                while (!MigratePartition.this.plan.cleanupInterrupted()) {
                    try {
                        if (targetState == RepNodeAdmin.PartitionMigrationState.UNKNOWN) {
                            targetState = MigratePartition.this.cancelTarget();
                        }
                        if (targetState == null) {
                            return;
                        }
                        switch (targetState) {
                            case SUCCEEDED: {
                                Admin admin = MigratePartition.this.plan.getAdmin();
                                if (!admin.updatePartition(MigratePartition.this.partitionId, MigratePartition.this.targetRGId, MigratePartition.this.plan.getDeployedInfo(), MigratePartition.this.plan)) {
                                    return;
                                }
                                try {
                                    if (Utils.broadcastTopoChangesToRNs(MigratePartition.this.plan.getLogger(), admin.getCurrentTopology(), this.toString(), admin.getParams().getAdminParams(), MigratePartition.this.plan)) {
                                        return;
                                    }
                                    break;
                                }
                                catch (InterruptedException interruptedException) {
                                    break;
                                }
                            }
                            case ERROR: {
                                if (MigratePartition.this.cancelSource()) {
                                    return;
                                }
                                break;
                            }
                            default: {
                                targetState = RepNodeAdmin.PartitionMigrationState.UNKNOWN;
                            }
                        }
                    }
                    catch (Exception e) {
                        MigratePartition.this.plan.getLogger().log(Level.SEVERE, "{0}: target={1} problem when cancelling migration:{2}", new Object[]{MigratePartition.this.partitionId, MigratePartition.this.targetRNId, LoggerUtils.getStackTrace(e)});
                    }
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
    }

    private RepNodeAdmin.PartitionMigrationState cancelTarget() throws RemoteException, NotBoundException {
        RepNodeAdminAPI target = this.getTarget();
        if (target == null) {
            this.plan.getLogger().log(Level.INFO, "{0}: attempted to cancel migration, but can't contact target RN", this.partitionId);
            return RepNodeAdmin.PartitionMigrationState.UNKNOWN;
        }
        RepNodeAdmin.PartitionMigrationState state = target.canCancel(this.partitionId);
        String meaning = state == RepNodeAdmin.PartitionMigrationState.SUCCEEDED ? "migration finished, can't be canceled" : (state == RepNodeAdmin.PartitionMigrationState.ERROR ? "migration will be stopped" : "problem canceling migration");
        this.plan.getLogger().log(Level.INFO, "{0}: target={1} request to cancel migration: {2} {3}", new Object[]{this.partitionId, this.targetRNId, state, meaning});
        return state;
    }

    private boolean cancelSource() throws RemoteException, NotBoundException {
        RepNodeAdminAPI source = this.getSource();
        if (source == null) {
            return false;
        }
        boolean canceled = source.canceled(this.partitionId, this.targetRGId);
        this.plan.getLogger().log(Level.INFO, "{0}: source={1} target={2} cancel at source={3}", new Object[]{this.partitionId, this.sourceRGId, this.targetRNId, canceled});
        return canceled;
    }

    @Override
    public void lockTopoComponents(Planner planner) throws PlanLocksHeldException {
        planner.lockShard(this.plan.getId(), this.plan.getName(), this.sourceRGId);
        planner.lockShard(this.plan.getId(), this.plan.getName(), this.targetRGId);
    }

    @Override
    public String displayExecutionDetails(Map<String, String> details, String displayPrefix) {
        PartitionMigrationStatus targetStatus = PartitionMigrationStatus.parseTargetStatus(details);
        if (targetStatus == null) {
            return null;
        }
        return targetStatus.display(displayPrefix);
    }

    private abstract class PartitionJob
    extends JobWrapper {
        public PartitionJob(int taskId, PlanExecutor.ParallelTaskRunner runner, String description) {
            super(taskId, runner, description);
        }

        @Override
        public String getDescription() {
            return MigratePartition.this.partitionId + ": " + super.getDescription();
        }
    }
}

